/* service.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

private class Sugar.ShellService {
    public DBus.Connection connection;
    public dynamic DBus.Object object;

    private ShellService () throws Error {
        connection = DBus.Bus.get (DBus.BusType.SESSION);
        object = connection.get_object (_NAME, _PATH, _INTERFACE);
    }

    public static ShellService instance () throws Error {
        if (_instance == null)
            _instance = new ShellService ();
        return _instance;
    }

    private const string _NAME = "org.laptop.Shell";
    private const string _INTERFACE = "org.laptop.Shell";
    private const string _PATH = "/org/laptop/Shell";

    private static ShellService _instance;
}

private class Sugar.JournalService {
    public DBus.Connection connection;
    public dynamic DBus.Object object;

    public JournalService () throws Error {
        connection = DBus.Bus.get (DBus.BusType.SESSION);
        object = connection.get_object (_NAME, _PATH, _INTERFACE);
    }

    private const string _NAME = "org.laptop.Journal";
    private const string _INTERFACE = "org.laptop.Journal";
    private const string _PATH = "/org/laptop/Journal";
}

private class Sugar.ActivityService {
    public delegate void SetActive (bool active);

    public DBus.Connection connection;
    public dynamic Server object;

    public ActivityService () throws Error {
        string name = _NAME + Environ.activity_id;
        string path = _PATH + Environ.activity_id;

        connection = DBus.Bus.get (DBus.BusType.SESSION);

        dynamic DBus.Object bus = connection.get_object (
                "org.freedesktop.DBus", "/org/freedesktop/DBus",
                "org.freedesktop.DBus");
        uint request_name_result = bus.request_name (name, (uint) 0);
        if (request_name_result != DBus.RequestNameReply.PRIMARY_OWNER)
            throw new DBus.Error.FAILED (@"Cannot request name $(name)");

        object = new Server ();
        connection.register_object (path, object);
    }

    [DBus (name = "org.laptop.Activity")]
    public class Server : Object {
        public ActivityService.SetActive set_active_cb;

        public void SetActive (bool active) {
            if (set_active_cb != null)
                set_active_cb (active);
        }

        public void Invite (string buddy_key) {
        }
    }

    private const string _NAME = "org.laptop.Activity";
    private const string _PATH = "/org/laptop/Activity/";
}
