/* alert.c generated by valac 0.12.1, the Vala compiler
 * generated from alert.vala, do not modify */

/* alert.vala
 *
 * Copyright (C) 2010, Aleksey Lim
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "polyol/toolkit.h"
#include <gtk/gtk.h>
#include <polyol/gui.h>
#include <polyol/env.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <math.h>
#include <cairo.h>
#include <float.h>
#include <glib/gi18n-lib.h>

#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SUGAR_MESSAGE_ALERT_TYPE__COUNTDOWNLABEL (sugar_message_alert__countdownlabel_get_type ())
#define SUGAR_MESSAGE_ALERT__COUNTDOWNLABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUGAR_MESSAGE_ALERT_TYPE__COUNTDOWNLABEL, SugarMessageAlert_CountDownLabel))
#define SUGAR_MESSAGE_ALERT__COUNTDOWNLABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUGAR_MESSAGE_ALERT_TYPE__COUNTDOWNLABEL, SugarMessageAlert_CountDownLabelClass))
#define SUGAR_MESSAGE_ALERT_IS__COUNTDOWNLABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUGAR_MESSAGE_ALERT_TYPE__COUNTDOWNLABEL))
#define SUGAR_MESSAGE_ALERT_IS__COUNTDOWNLABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUGAR_MESSAGE_ALERT_TYPE__COUNTDOWNLABEL))
#define SUGAR_MESSAGE_ALERT__COUNTDOWNLABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUGAR_MESSAGE_ALERT_TYPE__COUNTDOWNLABEL, SugarMessageAlert_CountDownLabelClass))

typedef struct _SugarMessageAlert_CountDownLabel SugarMessageAlert_CountDownLabel;
typedef struct _SugarMessageAlert_CountDownLabelClass SugarMessageAlert_CountDownLabelClass;
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _SugarMessageAlert_CountDownLabelPrivate SugarMessageAlert_CountDownLabelPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _SugarAlertBinPrivate {
	GQueue* _queue;
};

struct _SugarMessageAlertPrivate {
	GtkHButtonBox* _buttons_box;
	SugarMessageAlert_CountDownLabel* _count_down;
};

struct _Block1Data {
	int _ref_count_;
	SugarMessageAlert * self;
	gint response_id;
};

struct _SugarMessageAlert_CountDownLabel {
	GtkLabel parent_instance;
	SugarMessageAlert_CountDownLabelPrivate * priv;
};

struct _SugarMessageAlert_CountDownLabelClass {
	GtkLabelClass parent_class;
};

struct _SugarMessageAlert_CountDownLabelPrivate {
	guint _sid;
	gint _count;
	SugarAlert* _alert;
};


static gpointer sugar_alert_bin_parent_class = NULL;
static SugarAlertBin* sugar_alert_bin__singleton;
static SugarAlertBin* sugar_alert_bin__singleton = NULL;
static gpointer sugar_message_alert_parent_class = NULL;
static gpointer sugar_message_alert__countdownlabel_parent_class = NULL;
static SugarAlertIface* sugar_message_alert_sugar_alert_parent_iface = NULL;
static gpointer sugar_confirmation_alert_parent_class = NULL;
static gpointer sugar_timeout_alert_parent_class = NULL;
static gpointer sugar_notify_alert_parent_class = NULL;

#define SUGAR_ALERT_BIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_ALERT_BIN, SugarAlertBinPrivate))
enum  {
	SUGAR_ALERT_BIN_DUMMY_PROPERTY
};
static void _sugar_alert_bin_next (SugarAlertBin* self);
static void _sugar_alert_bin_response_cb (SugarAlertBin* self);
static void __sugar_alert_bin_response_cb_sugar_alert_response (SugarAlert* _sender, gint response_id, gpointer self);
static GObject * sugar_alert_bin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void sugar_alert_bin_finalize (GObject* obj);
static GType sugar_message_alert__countdownlabel_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SUGAR_MESSAGE_ALERT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_TYPE_MESSAGE_ALERT, SugarMessageAlertPrivate))
enum  {
	SUGAR_MESSAGE_ALERT_DUMMY_PROPERTY
};
static void _sugar_message_alert_popup_cb (SugarMessageAlert* self);
static void __sugar_message_alert_popup_cb_sugar_alert_popup (SugarAlert* _sender, gpointer self);
static void _sugar_message_alert_response_cb (SugarMessageAlert* self);
static void __sugar_message_alert_response_cb_sugar_alert_response (SugarAlert* _sender, gint response_id, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static SugarMessageAlert_CountDownLabel* sugar_message_alert__countdownlabel_new (gint count, SugarAlert* alert);
static SugarMessageAlert_CountDownLabel* sugar_message_alert__countdownlabel_construct (GType object_type, gint count, SugarAlert* alert);
static void _lambda2_ (Block1Data* _data1_);
static void __lambda2__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void sugar_message_alert__countdownlabel_start (SugarMessageAlert_CountDownLabel* self);
static void sugar_message_alert__countdownlabel_stop (SugarMessageAlert_CountDownLabel* self);
#define SUGAR_MESSAGE_ALERT__COUNTDOWNLABEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUGAR_MESSAGE_ALERT_TYPE__COUNTDOWNLABEL, SugarMessageAlert_CountDownLabelPrivate))
enum  {
	SUGAR_MESSAGE_ALERT__COUNTDOWNLABEL_DUMMY_PROPERTY
};
static gboolean _lambda1_ (SugarMessageAlert_CountDownLabel* self);
static gboolean __lambda1__gsource_func (gpointer self);
static gboolean sugar_message_alert__countdownlabel_real_expose_event (GtkWidget* base, GdkEventExpose* event);
static void sugar_message_alert__countdownlabel_finalize (GObject* obj);
static void sugar_message_alert_finalize (GObject* obj);
enum  {
	SUGAR_CONFIRMATION_ALERT_DUMMY_PROPERTY
};
enum  {
	SUGAR_TIMEOUT_ALERT_DUMMY_PROPERTY
};
enum  {
	SUGAR_NOTIFY_ALERT_DUMMY_PROPERTY
};


/**
     * Push new alert to the queue
     *
     * @param widget alert widget, it will be owned by AlertBin right after
     *               this call (regardless if alsert queue is empty or not)
     *               and could be unreffed on caller side
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sugar_alert_bin_push (SugarAlert* alert) {
	g_return_if_fail (alert != NULL);
	if (sugar_alert_bin__singleton == NULL) {
		g_warning ("alert.vala:57: AlertBin was not created");
	} else {
		gboolean _tmp0_;
		gboolean is_new;
		SugarAlert* _tmp1_;
		_tmp0_ = g_queue_is_empty (sugar_alert_bin__singleton->priv->_queue);
		is_new = _tmp0_;
		_tmp1_ = _g_object_ref0 (alert);
		g_queue_push_tail (sugar_alert_bin__singleton->priv->_queue, _tmp1_);
		if (is_new) {
			_sugar_alert_bin_next (sugar_alert_bin__singleton);
		}
	}
}


/**
     * Remove alert from the queue
     *
     * There is no need to call pop method for every alert, after disappearing,
     * alert widget will be unreffed and removed from the queue automatically.
     *
     * @param widget alert widget to remove
     */
void sugar_alert_bin_pop (SugarAlert* alert) {
	g_return_if_fail (alert != NULL);
	if (sugar_alert_bin__singleton == NULL) {
		g_warning ("alert.vala:76: AlertBin was not created");
	} else {
		gconstpointer _tmp0_ = NULL;
		g_queue_remove (sugar_alert_bin__singleton->priv->_queue, alert);
		_tmp0_ = g_queue_peek_head (sugar_alert_bin__singleton->priv->_queue);
		if (alert == ((SugarAlert*) _tmp0_)) {
			_sugar_alert_bin_next (sugar_alert_bin__singleton);
		}
	}
}


static void __sugar_alert_bin_response_cb_sugar_alert_response (SugarAlert* _sender, gint response_id, gpointer self) {
	_sugar_alert_bin_response_cb (self);
}


static void _sugar_alert_bin_next (SugarAlertBin* self) {
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	if (((GtkBin*) self)->child != NULL) {
		gpointer _tmp0_ = NULL;
		SugarAlert* alert;
		guint _tmp1_;
		gtk_container_remove ((GtkContainer*) self, ((GtkBin*) self)->child);
		_tmp0_ = g_queue_pop_head (self->priv->_queue);
		alert = (SugarAlert*) _tmp0_;
		g_signal_parse_name ("response", SUGAR_TYPE_ALERT, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (alert, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __sugar_alert_bin_response_cb_sugar_alert_response, self);
		_g_object_unref0 (alert);
	}
	_tmp2_ = g_queue_is_empty (self->priv->_queue);
	if (_tmp2_) {
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		gconstpointer _tmp3_ = NULL;
		SugarAlert* _tmp4_;
		SugarAlert* alert;
		_tmp3_ = g_queue_peek_head (self->priv->_queue);
		_tmp4_ = _g_object_ref0 ((SugarAlert*) _tmp3_);
		alert = _tmp4_;
		g_signal_connect_object (alert, "response", (GCallback) __sugar_alert_bin_response_cb_sugar_alert_response, self, 0);
		g_signal_emit_by_name (alert, "popup");
		gtk_widget_show ((GtkWidget*) alert);
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) alert);
		gtk_widget_show ((GtkWidget*) self);
		_g_object_unref0 (alert);
	}
}


static void _sugar_alert_bin_response_cb (SugarAlertBin* self) {
	g_return_if_fail (self != NULL);
	_sugar_alert_bin_next (self);
}


SugarAlertBin* sugar_alert_bin_construct (GType object_type) {
	SugarAlertBin * self = NULL;
	self = (SugarAlertBin*) g_object_new (object_type, NULL);
	return self;
}


SugarAlertBin* sugar_alert_bin_new (void) {
	return sugar_alert_bin_construct (SUGAR_TYPE_ALERT_BIN);
}


static GObject * sugar_alert_bin_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SugarAlertBin * self;
	GdkColor _tmp0_ = {0};
	GdkColor _tmp1_ = {0};
	GQueue* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (sugar_alert_bin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SUGAR_ALERT_BIN (obj);
	sugar_color_type_to_rgb (SUGAR_COLOR_BLACK, &_tmp0_);
	_tmp1_ = _tmp0_;
	gtk_widget_modify_bg ((GtkWidget*) self, GTK_STATE_NORMAL, &_tmp1_);
	_tmp2_ = g_queue_new ();
	_g_queue_free0 (self->priv->_queue);
	self->priv->_queue = _tmp2_;
	sugar_alert_bin__singleton = self;
	return obj;
}


static void sugar_alert_bin_class_init (SugarAlertBinClass * klass) {
	sugar_alert_bin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarAlertBinPrivate));
	G_OBJECT_CLASS (klass)->constructor = sugar_alert_bin_constructor;
	G_OBJECT_CLASS (klass)->finalize = sugar_alert_bin_finalize;
}


static void sugar_alert_bin_instance_init (SugarAlertBin * self) {
	self->priv = SUGAR_ALERT_BIN_GET_PRIVATE (self);
}


static void sugar_alert_bin_finalize (GObject* obj) {
	SugarAlertBin * self;
	self = SUGAR_ALERT_BIN (obj);
	sugar_alert_bin__singleton = NULL;
	_g_queue_free0 (self->priv->_queue);
	G_OBJECT_CLASS (sugar_alert_bin_parent_class)->finalize (obj);
}


/**
 * Container for various user level messages and short iteractions
 *
 * Alerts are used inside the activity window instead of being a
 * separate popup window. They do not hide canvas content. You can use
 * push and pop functions inside your activity to add and remove the
 * alsert. The position of the alert is below the toolbox or top in
 * fullscreen mode.
 *
 * Alerts could be regular widgets that implement Alert interface, but
 * predefined classes like MessageAlert, ConfirmationAlert etc are
 * especially useful. Only one alert will be visible at the same time. If
 * there are other alerts, they will be queued.
 *
 * AlertBin is designed to be used directly from various parts of code since its
 * methods are static, just create one AlertBin instance to shoow all alerts in
 * activity.
 */
GType sugar_alert_bin_get_type (void) {
	static volatile gsize sugar_alert_bin_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_alert_bin_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarAlertBinClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_alert_bin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarAlertBin), 0, (GInstanceInitFunc) sugar_alert_bin_instance_init, NULL };
		GType sugar_alert_bin_type_id;
		sugar_alert_bin_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "SugarAlertBin", &g_define_type_info, 0);
		g_once_init_leave (&sugar_alert_bin_type_id__volatile, sugar_alert_bin_type_id);
	}
	return sugar_alert_bin_type_id__volatile;
}


static void sugar_alert_base_init (SugarAlertIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		     * Alert was made visible in AlertBin
		     */
		g_signal_new ("popup", SUGAR_TYPE_ALERT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		/**
		     * Alert button was clicked
		     *
		     * The Alert class will pass "response" events to your activity when any
		     * of its buttons are clicked.
		     *
		     * @param response_id   button id to help identify what button was clicked
		     */
		g_signal_new ("response", SUGAR_TYPE_ALERT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	}
}


/**
 * Interface for alerts that should be placed to AlertBin
 */
GType sugar_alert_get_type (void) {
	static volatile gsize sugar_alert_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_alert_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarAlertIface), (GBaseInitFunc) sugar_alert_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType sugar_alert_type_id;
		sugar_alert_type_id = g_type_register_static (G_TYPE_INTERFACE, "SugarAlert", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (sugar_alert_type_id, GTK_TYPE_WIDGET);
		g_once_init_leave (&sugar_alert_type_id__volatile, sugar_alert_type_id);
	}
	return sugar_alert_type_id__volatile;
}


/**
     * Create basic message alert
     *
     * @param title_text    title of the alert, will be shown in bold
     * @param message_text  message of the alert
     * @param icon_name     icon name of full path to icon file that appears at
     *                      the far left; if null then do not use icon
     */
static void __sugar_message_alert_popup_cb_sugar_alert_popup (SugarAlert* _sender, gpointer self) {
	_sugar_message_alert_popup_cb (self);
}


static void __sugar_message_alert_response_cb_sugar_alert_response (SugarAlert* _sender, gint response_id, gpointer self) {
	_sugar_message_alert_response_cb (self);
}


SugarMessageAlert* sugar_message_alert_construct (GType object_type, const gchar* title_text, const gchar* message_text, const gchar* icon_name) {
	SugarMessageAlert * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GtkVBox* _tmp4_ = NULL;
	GtkVBox* message_box;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* title;
	PangoAttrList* _tmp6_ = NULL;
	PangoAttrList* _tmp7_;
	PangoAttrList* _tmp8_ = NULL;
	PangoAttribute* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* message;
	GtkHButtonBox* _tmp11_ = NULL;
	gint _tmp12_;
	g_return_val_if_fail (title_text != NULL, NULL);
	g_return_val_if_fail (message_text != NULL, NULL);
	self = (SugarMessageAlert*) g_object_new (object_type, NULL);
	_tmp0_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	gtk_box_set_spacing ((GtkBox*) self, _tmp0_);
	_tmp1_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) _tmp1_);
	if (icon_name != NULL) {
		SugarIcon* _tmp2_ = NULL;
		SugarIcon* icon;
		gint _tmp3_;
		_tmp2_ = sugar_icon_new ();
		icon = g_object_ref_sink (_tmp2_);
		sugar_icon_set_file (icon, icon_name);
		_tmp3_ = sugar_metrics_get (SUGAR_STANDARD_ICON_SIZE);
		sugar_icon_set_pixel_size (icon, _tmp3_);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) icon, FALSE, TRUE, (guint) 0);
		_g_object_unref0 (icon);
	}
	_tmp4_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	message_box = g_object_ref_sink (_tmp4_);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) message_box, FALSE, TRUE, (guint) 0);
	_tmp5_ = (GtkLabel*) gtk_label_new (title_text);
	title = g_object_ref_sink (_tmp5_);
	_tmp6_ = pango_attr_list_new ();
	_tmp7_ = _tmp6_;
	gtk_label_set_attributes (title, _tmp7_);
	_pango_attr_list_unref0 (_tmp7_);
	_tmp8_ = gtk_label_get_attributes (title);
	_tmp9_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (_tmp8_, _tmp9_);
	gtk_misc_set_alignment ((GtkMisc*) title, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) message_box, (GtkWidget*) title, FALSE, TRUE, (guint) 0);
	_tmp10_ = (GtkLabel*) gtk_label_new (message_text);
	message = g_object_ref_sink (_tmp10_);
	gtk_misc_set_alignment ((GtkMisc*) message, 0.0f, 0.5f);
	gtk_box_pack_start ((GtkBox*) message_box, (GtkWidget*) message, FALSE, TRUE, (guint) 0);
	_tmp11_ = (GtkHButtonBox*) gtk_hbutton_box_new ();
	_g_object_unref0 (self->priv->_buttons_box);
	self->priv->_buttons_box = g_object_ref_sink (_tmp11_);
	g_object_set ((GtkButtonBox*) self->priv->_buttons_box, "layout-style", GTK_BUTTONBOX_END, NULL);
	_tmp12_ = sugar_metrics_get (SUGAR_DEFAULT_SPACING);
	gtk_box_set_spacing ((GtkBox*) self->priv->_buttons_box, _tmp12_);
	gtk_box_pack_end ((GtkBox*) self, (GtkWidget*) self->priv->_buttons_box, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object ((SugarAlert*) self, "popup", (GCallback) __sugar_message_alert_popup_cb_sugar_alert_popup, self, 0);
	g_signal_connect_object ((SugarAlert*) self, "response", (GCallback) __sugar_message_alert_response_cb_sugar_alert_response, self, 0);
	_g_object_unref0 (message);
	_g_object_unref0 (title);
	_g_object_unref0 (message_box);
	return self;
}


SugarMessageAlert* sugar_message_alert_new (const gchar* title_text, const gchar* message_text, const gchar* icon_name) {
	return sugar_message_alert_construct (SUGAR_TYPE_MESSAGE_ALERT, title_text, message_text, icon_name);
}


/**
     * Add button to alert
     *
     * @param response_id   will be emitted with the response signal
     * @param label         that will occure right to the buttom
     * @param icon_name     optional icon name or full path to icon image
     * @param timeout       optional timeout to auto send response event
     */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda2_ (Block1Data* _data1_) {
	SugarMessageAlert * self;
	self = _data1_->self;
	g_signal_emit_by_name ((SugarAlert*) self, "response", _data1_->response_id);
}


static void __lambda2__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda2_ (self);
}


void sugar_message_alert_add_button (SugarMessageAlert* self, gint response_id, const gchar* label, const gchar* icon_name, gint timeout) {
	Block1Data* _data1_;
	GtkButton* _tmp0_ = NULL;
	GtkButton* button;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->response_id = response_id;
	_tmp0_ = (GtkButton*) gtk_button_new ();
	button = g_object_ref_sink (_tmp0_);
	gtk_button_set_label (button, label);
	gtk_widget_show ((GtkWidget*) button);
	gtk_box_pack_start ((GtkBox*) self->priv->_buttons_box, (GtkWidget*) button, FALSE, TRUE, (guint) 0);
	if (timeout > 0) {
		SugarMessageAlert_CountDownLabel* _tmp1_ = NULL;
		_tmp1_ = sugar_message_alert__countdownlabel_new (timeout, (SugarAlert*) self);
		_g_object_unref0 (self->priv->_count_down);
		self->priv->_count_down = g_object_ref_sink (_tmp1_);
		gtk_button_set_image (button, (GtkWidget*) self->priv->_count_down);
	} else {
		if (icon_name != NULL) {
			SugarIcon* _tmp2_ = NULL;
			SugarIcon* icon;
			_tmp2_ = sugar_icon_new ();
			icon = g_object_ref_sink (_tmp2_);
			g_object_set ((GtkImage*) icon, "icon-name", icon_name, NULL);
			gtk_button_set_image (button, (GtkWidget*) icon);
			_g_object_unref0 (icon);
		}
	}
	g_signal_connect_data (button, "clicked", (GCallback) __lambda2__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_object_unref0 (button);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void _sugar_message_alert_popup_cb (SugarMessageAlert* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_count_down != NULL) {
		sugar_message_alert__countdownlabel_start (self->priv->_count_down);
	}
}


static void _sugar_message_alert_response_cb (SugarMessageAlert* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_count_down != NULL) {
		sugar_message_alert__countdownlabel_stop (self->priv->_count_down);
		_g_object_unref0 (self->priv->_count_down);
		self->priv->_count_down = NULL;
	}
}


static SugarMessageAlert_CountDownLabel* sugar_message_alert__countdownlabel_construct (GType object_type, gint count, SugarAlert* alert) {
	SugarMessageAlert_CountDownLabel * self = NULL;
	SugarAlert* _tmp0_;
	GdkColor _tmp1_ = {0};
	GdkColor _tmp2_ = {0};
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (alert != NULL, NULL);
	self = (SugarMessageAlert_CountDownLabel*) g_object_new (object_type, NULL);
	self->priv->_count = count;
	_tmp0_ = _g_object_ref0 (alert);
	_g_object_unref0 (self->priv->_alert);
	self->priv->_alert = _tmp0_;
	sugar_color_type_to_rgb (SUGAR_COLOR_BUTTON_GREY, &_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_widget_modify_fg ((GtkWidget*) self, GTK_STATE_NORMAL, &_tmp2_);
	_tmp3_ = g_strdup_printf ("%i", self->priv->_count);
	_tmp4_ = _tmp3_;
	gtk_label_set_label ((GtkLabel*) self, _tmp4_);
	_g_free0 (_tmp4_);
	gtk_label_set_width_chars ((GtkLabel*) self, 1);
	return self;
}


static SugarMessageAlert_CountDownLabel* sugar_message_alert__countdownlabel_new (gint count, SugarAlert* alert) {
	return sugar_message_alert__countdownlabel_construct (SUGAR_MESSAGE_ALERT_TYPE__COUNTDOWNLABEL, count, alert);
}


static gboolean _lambda1_ (SugarMessageAlert_CountDownLabel* self) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self->priv->_count = self->priv->_count - 1;
	_tmp0_ = g_strdup_printf ("%i", self->priv->_count);
	_tmp1_ = _tmp0_;
	gtk_label_set_label ((GtkLabel*) self, _tmp1_);
	_g_free0 (_tmp1_);
	if (self->priv->_count > 0) {
		result = TRUE;
		return result;
	}
	g_signal_emit_by_name (self->priv->_alert, "response", (gint) GTK_RESPONSE_OK);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static void sugar_message_alert__countdownlabel_start (SugarMessageAlert_CountDownLabel* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->_sid != 0) {
		return;
	}
	_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __lambda1__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->_sid = _tmp0_;
}


static void sugar_message_alert__countdownlabel_stop (SugarMessageAlert_CountDownLabel* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_sid != 0) {
		g_source_remove (self->priv->_sid);
		self->priv->_sid = (guint) 0;
	}
}


static gboolean sugar_message_alert__countdownlabel_real_expose_event (GtkWidget* base, GdkEventExpose* event) {
	SugarMessageAlert_CountDownLabel * self;
	gboolean result = FALSE;
	gint x;
	GtkContainer* _tmp0_ = NULL;
	gdouble _tmp1_;
	gint y;
	gint d;
	cairo_t* _tmp2_ = NULL;
	cairo_t* cr;
	GdkColor _tmp3_ = {0};
	GdkColor _tmp4_ = {0};
	gboolean _tmp5_;
	self = (SugarMessageAlert_CountDownLabel*) base;
	x = ((GtkWidget*) self)->allocation.x + (((GtkWidget*) self)->allocation.width / 2);
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) self);
	_tmp1_ = ceil (((GtkWidget*) self)->allocation.height / 2.0);
	y = ((GtkWidget*) _tmp0_)->allocation.y + ((gint) _tmp1_);
	d = (gint) ((((GtkWidget*) self)->allocation.height / 5.0) * 3.0);
	_tmp2_ = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self)->window);
	cr = _tmp2_;
	sugar_color_type_to_rgb (SUGAR_COLOR_WHITE, &_tmp3_);
	_tmp4_ = _tmp3_;
	gdk_cairo_set_source_color (cr, &_tmp4_);
	cairo_move_to (cr, (gdouble) ((GtkWidget*) self)->allocation.x, (gdouble) ((GtkWidget*) self)->allocation.y);
	cairo_arc (cr, (gdouble) x, (gdouble) y, (gdouble) d, (gdouble) 0, G_PI * 2);
	cairo_fill (cr);
	_tmp5_ = GTK_WIDGET_CLASS (sugar_message_alert__countdownlabel_parent_class)->expose_event ((GtkWidget*) GTK_LABEL (self), event);
	result = _tmp5_;
	_cairo_destroy0 (cr);
	return result;
}


static void sugar_message_alert__countdownlabel_class_init (SugarMessageAlert_CountDownLabelClass * klass) {
	sugar_message_alert__countdownlabel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarMessageAlert_CountDownLabelPrivate));
	GTK_WIDGET_CLASS (klass)->expose_event = sugar_message_alert__countdownlabel_real_expose_event;
	G_OBJECT_CLASS (klass)->finalize = sugar_message_alert__countdownlabel_finalize;
}


static void sugar_message_alert__countdownlabel_instance_init (SugarMessageAlert_CountDownLabel * self) {
	self->priv = SUGAR_MESSAGE_ALERT__COUNTDOWNLABEL_GET_PRIVATE (self);
}


static void sugar_message_alert__countdownlabel_finalize (GObject* obj) {
	SugarMessageAlert_CountDownLabel * self;
	self = SUGAR_MESSAGE_ALERT__COUNTDOWNLABEL (obj);
	_g_object_unref0 (self->priv->_alert);
	G_OBJECT_CLASS (sugar_message_alert__countdownlabel_parent_class)->finalize (obj);
}


static GType sugar_message_alert__countdownlabel_get_type (void) {
	static volatile gsize sugar_message_alert__countdownlabel_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_message_alert__countdownlabel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarMessageAlert_CountDownLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_message_alert__countdownlabel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarMessageAlert_CountDownLabel), 0, (GInstanceInitFunc) sugar_message_alert__countdownlabel_instance_init, NULL };
		GType sugar_message_alert__countdownlabel_type_id;
		sugar_message_alert__countdownlabel_type_id = g_type_register_static (GTK_TYPE_LABEL, "SugarMessageAlert_CountDownLabel", &g_define_type_info, 0);
		g_once_init_leave (&sugar_message_alert__countdownlabel_type_id__volatile, sugar_message_alert__countdownlabel_type_id);
	}
	return sugar_message_alert__countdownlabel_type_id__volatile;
}


static void sugar_message_alert_class_init (SugarMessageAlertClass * klass) {
	sugar_message_alert_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SugarMessageAlertPrivate));
	G_OBJECT_CLASS (klass)->finalize = sugar_message_alert_finalize;
}


static void sugar_message_alert_sugar_alert_interface_init (SugarAlertIface * iface) {
	sugar_message_alert_sugar_alert_parent_iface = g_type_interface_peek_parent (iface);
}


static void sugar_message_alert_instance_init (SugarMessageAlert * self) {
	self->priv = SUGAR_MESSAGE_ALERT_GET_PRIVATE (self);
}


static void sugar_message_alert_finalize (GObject* obj) {
	SugarMessageAlert * self;
	self = SUGAR_MESSAGE_ALERT (obj);
	_g_object_unref0 (self->priv->_buttons_box);
	_g_object_unref0 (self->priv->_count_down);
	G_OBJECT_CLASS (sugar_message_alert_parent_class)->finalize (obj);
}


/**
 * Basic notification alert
 *
 * At a high level, MessageAlert and its different variations (NotifyAlert,
 * ConfirmationAlert, etc.) have a title, an alert message and then several
 * buttons that the user can click (response signal will be emited).
 *
 * To make alerts visible in activity, use AlertBin.
 */
GType sugar_message_alert_get_type (void) {
	static volatile gsize sugar_message_alert_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_message_alert_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarMessageAlertClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_message_alert_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarMessageAlert), 0, (GInstanceInitFunc) sugar_message_alert_instance_init, NULL };
		static const GInterfaceInfo sugar_alert_info = { (GInterfaceInitFunc) sugar_message_alert_sugar_alert_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType sugar_message_alert_type_id;
		sugar_message_alert_type_id = g_type_register_static (GTK_TYPE_HBOX, "SugarMessageAlert", &g_define_type_info, 0);
		g_type_add_interface_static (sugar_message_alert_type_id, SUGAR_TYPE_ALERT, &sugar_alert_info);
		g_once_init_leave (&sugar_message_alert_type_id__volatile, sugar_message_alert_type_id);
	}
	return sugar_message_alert_type_id__volatile;
}


/**
     * {@inheritDoc}
     */
SugarConfirmationAlert* sugar_confirmation_alert_construct (GType object_type, const gchar* title_text, const gchar* message_text, const gchar* icon_name) {
	SugarConfirmationAlert * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (title_text != NULL, NULL);
	g_return_val_if_fail (message_text != NULL, NULL);
	self = (SugarConfirmationAlert*) sugar_message_alert_construct (object_type, title_text, message_text, icon_name);
	_tmp0_ = _ ("Cancel");
	sugar_message_alert_add_button ((SugarMessageAlert*) self, (gint) GTK_RESPONSE_CANCEL, _tmp0_, "dialog-cancel", 0);
	_tmp1_ = _ ("Ok");
	sugar_message_alert_add_button ((SugarMessageAlert*) self, (gint) GTK_RESPONSE_OK, _tmp1_, "dialog-ok", 0);
	return self;
}


SugarConfirmationAlert* sugar_confirmation_alert_new (const gchar* title_text, const gchar* message_text, const gchar* icon_name) {
	return sugar_confirmation_alert_construct (SUGAR_TYPE_CONFIRMATION_ALERT, title_text, message_text, icon_name);
}


static void sugar_confirmation_alert_class_init (SugarConfirmationAlertClass * klass) {
	sugar_confirmation_alert_parent_class = g_type_class_peek_parent (klass);
}


static void sugar_confirmation_alert_instance_init (SugarConfirmationAlert * self) {
}


/**
 * A ready-made two button (Cancel, Ok) alert
 *
 * A confirmation alert is a nice shortcut from a standard Alert because it
 * comes with 'OK' and 'Cancel' buttons already built-in. When clicked, the 'OK'
 * button will emit a response with a response_id of Gtk.ResponseType.OK, while
 * the 'Cancel' button will emit Gtk.ResponseType.CANCEL.
 */
GType sugar_confirmation_alert_get_type (void) {
	static volatile gsize sugar_confirmation_alert_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_confirmation_alert_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarConfirmationAlertClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_confirmation_alert_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarConfirmationAlert), 0, (GInstanceInitFunc) sugar_confirmation_alert_instance_init, NULL };
		GType sugar_confirmation_alert_type_id;
		sugar_confirmation_alert_type_id = g_type_register_static (SUGAR_TYPE_MESSAGE_ALERT, "SugarConfirmationAlert", &g_define_type_info, 0);
		g_once_init_leave (&sugar_confirmation_alert_type_id__volatile, sugar_confirmation_alert_type_id);
	}
	return sugar_confirmation_alert_type_id__volatile;
}


/**
     * Create an alert
     *
     * @param title_text    title of the alert, will be shown in bold
     * @param message_text  message of the alert
     * @param icon_name     icon name of full path to icon file that appears at
     *                      the far left; if null then do not use icon
     * @param timeout       timeout in seconds to auto close alert
     */
SugarTimeoutAlert* sugar_timeout_alert_construct (GType object_type, const gchar* title_text, const gchar* message_text, const gchar* icon_name, gint timeout) {
	SugarTimeoutAlert * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (title_text != NULL, NULL);
	g_return_val_if_fail (message_text != NULL, NULL);
	self = (SugarTimeoutAlert*) sugar_message_alert_construct (object_type, title_text, message_text, icon_name);
	_tmp0_ = _ ("Cancel");
	sugar_message_alert_add_button ((SugarMessageAlert*) self, (gint) GTK_RESPONSE_CANCEL, _tmp0_, "dialog-cancel", 0);
	_tmp1_ = _ ("Continue");
	sugar_message_alert_add_button ((SugarMessageAlert*) self, (gint) GTK_RESPONSE_OK, _tmp1_, NULL, timeout);
	return self;
}


SugarTimeoutAlert* sugar_timeout_alert_new (const gchar* title_text, const gchar* message_text, const gchar* icon_name, gint timeout) {
	return sugar_timeout_alert_construct (SUGAR_TYPE_TIMEOUT_ALERT, title_text, message_text, icon_name, timeout);
}


static void sugar_timeout_alert_class_init (SugarTimeoutAlertClass * klass) {
	sugar_timeout_alert_parent_class = g_type_class_peek_parent (klass);
}


static void sugar_timeout_alert_instance_init (SugarTimeoutAlert * self) {
}


/**
 * A ready-made two button (Cancel, Continue) alert
 *
 * A confirmation alert is a nice shortcut from a standard Alert because it
 * comes with 'Cancel' and 'Continue' buttons already built-in. When clicked,
 * the 'Cancel' button will emit a response with a response_id of
 * Gtk.ResponseType.Cancel, while the 'Continue' button will emit
 * Gtk.ResponseType.OK.
 *
 * It times out with a positive response after the given amount of seconds.
 */
GType sugar_timeout_alert_get_type (void) {
	static volatile gsize sugar_timeout_alert_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_timeout_alert_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarTimeoutAlertClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_timeout_alert_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarTimeoutAlert), 0, (GInstanceInitFunc) sugar_timeout_alert_instance_init, NULL };
		GType sugar_timeout_alert_type_id;
		sugar_timeout_alert_type_id = g_type_register_static (SUGAR_TYPE_MESSAGE_ALERT, "SugarTimeoutAlert", &g_define_type_info, 0);
		g_once_init_leave (&sugar_timeout_alert_type_id__volatile, sugar_timeout_alert_type_id);
	}
	return sugar_timeout_alert_type_id__volatile;
}


/**
     * Create an alert
     *
     * @param title_text    title of the alert, will be shown in bold
     * @param message_text  message of the alert
     * @param icon_name     icon name of full path to icon file that appears at
     *                      the far left; if null then do not use icon
     * @param timeout       timeout in seconds to auto close alert
     */
SugarNotifyAlert* sugar_notify_alert_construct (GType object_type, const gchar* title_text, const gchar* message_text, const gchar* icon_name, gint timeout) {
	SugarNotifyAlert * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (title_text != NULL, NULL);
	g_return_val_if_fail (message_text != NULL, NULL);
	self = (SugarNotifyAlert*) sugar_message_alert_construct (object_type, title_text, message_text, icon_name);
	_tmp0_ = _ ("Ok");
	sugar_message_alert_add_button ((SugarMessageAlert*) self, (gint) GTK_RESPONSE_OK, _tmp0_, NULL, timeout);
	return self;
}


SugarNotifyAlert* sugar_notify_alert_new (const gchar* title_text, const gchar* message_text, const gchar* icon_name, gint timeout) {
	return sugar_notify_alert_construct (SUGAR_TYPE_NOTIFY_ALERT, title_text, message_text, icon_name, timeout);
}


static void sugar_notify_alert_class_init (SugarNotifyAlertClass * klass) {
	sugar_notify_alert_parent_class = g_type_class_peek_parent (klass);
}


static void sugar_notify_alert_instance_init (SugarNotifyAlert * self) {
}


/**
 * Timeout alert with only an "OK" button - just for notifications
 */
GType sugar_notify_alert_get_type (void) {
	static volatile gsize sugar_notify_alert_type_id__volatile = 0;
	if (g_once_init_enter (&sugar_notify_alert_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SugarNotifyAlertClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sugar_notify_alert_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SugarNotifyAlert), 0, (GInstanceInitFunc) sugar_notify_alert_instance_init, NULL };
		GType sugar_notify_alert_type_id;
		sugar_notify_alert_type_id = g_type_register_static (SUGAR_TYPE_MESSAGE_ALERT, "SugarNotifyAlert", &g_define_type_info, 0);
		g_once_init_leave (&sugar_notify_alert_type_id__volatile, sugar_notify_alert_type_id);
	}
	return sugar_notify_alert_type_id__volatile;
}



