# Copyright (C) 2012, Sebastian Silva
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from .env import webui, webui_host, webui_port


def get_app(commands_processor, api_url, anonymous=False):
    from . import client
    client.commands_processor = commands_processor
    client.anonymous = anonymous
    client.api_url = api_url
    from . import cursors
    # XXX
    if anonymous:
        cursors.home_mount = cursors.network_mount
    from .app import app
    return app
