# -*- coding: utf-8 -*-
# Copyright (C) 2012, Sebastian Silva
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from client import Client


class Mount:
    def __init__(self, clone=None):
        self.client = Client()

        if not clone:
            self.Contexts = self.client.Context.cursor(
                type=["activity", "project"],
                reply=['guid', 'type', 'title', 'author', 'summary',
                        'description', 'favorite', 'clone', 'mtime'],
                order_by='-mtime')
            self.autocomplete_Contexts = self.client.Context.cursor(
                reply=['guid', 'title'], order_by='-mtime')
            self.Projects = self.client.Context.cursor(type='project',
                reply=['guid', 'type', 'title', 'author', 'summary',
                        'description', 'favorite', 'clone', 'mtime'],
                order_by='-mtime')
            self.Activities = self.client.Context.cursor(type='activity',
                reply=['guid', 'type', 'title', 'author', 'summary',
                        'description', 'favorite', 'clone', 'mtime'],
                order_by='-mtime')
        else:
            self.Contexts = self.client.Context.cursor(
                clone=clone,
                reply=['guid', 'type', 'title', 'author', 'summary',
                        'description', 'favorite', 'clone', 'mtime'],
                order_by='-mtime')
            self.autocomplete_Contexts = self.client.Context.cursor(
                clone=clone,
                reply=['guid', 'title'],
                order_by='-mtime')
            self.Projects = self.client.Context.cursor(type='project',
                reply=['guid', 'type', 'title', 'author', 'summary',
                        'description', 'favorite', 'clone', 'mtime'],
                order_by='-mtime')
            self.Activities = self.client.Context.cursor(type='activity',
                clone=clone,
                reply=['guid', 'type', 'title', 'author', 'summary',
                        'description', 'favorite', 'clone', 'mtime'],
                order_by='-mtime')

        self.Questions = self.client.Feedback.cursor(type="question",
            reply=['guid', 'type', 'title', 'content', 'context', 'author',
                    'tags', 'mtime'], order_by='-mtime')
        self.Problems = self.client.Feedback.cursor(type="problem",
            reply=['guid', 'type', 'title', 'content', 'context', 'author',
                    'tags', 'mtime'], order_by='-mtime')
        self.Ideas = self.client.Feedback.cursor(type="idea",
            reply=['guid', 'type', 'title', 'content', 'context', 'author',
                    'tags', 'mtime'], order_by='-mtime')
        self.Solutions = self.client.Solution.cursor(
            reply=['guid', 'content', 'feedback', 'author', 'tags',
                    'mtime'], order_by='-mtime')
        self.Comments = self.client.Comment.cursor(
            reply=['guid', 'message', 'tags', 'author',
                    'feedback', 'review', 'solution', 'mtime'])
        self.Reviews = self.client.Review.cursor(
            reply=['guid', 'content', 'context', 'author',
                    'tags', 'mtime'], order_by='-mtime')
        self.Resources = self.client.Feedback.cursor(
            reply=['guid', 'type', 'title', 'content', 'context', 'author',
                    'tags', 'mtime'], order_by='-mtime')
        self.Artifacts = self.client.Artifact.cursor(
            reply=['guid', 'title', 'description', 'context',
                    'author', 'tags', 'mtime'],
            order_by='-mtime')


network_mount = Mount()
home_mount = Mount(clone=2)
