import flask
from flask_classy import FlaskView
from flaskext.babel import gettext as _
import logging


class FeedbackView(FlaskView):

    def new(self):
        context_guid = flask.request.args.get('context') or \
                            flask.session.get('last_context') or \
                            'sugar-network'
        title = flask.request.args.get('title')
        return flask.render_template('dialog_resource.html',
                    title=title,
                    context=context_guid,
                    mode='new')

    def edit(self):
        context_guid = flask.request.args.get('context')
        title = flask.request.args.get('title')
        content = flask.request.args.get('content')
        resource = flask.request.args.get('resource')
        resource_type = flask.request.args.get('resource_type')
        return flask.render_template('dialog_resource.html',
                    context=context_guid,
                    title=title,
                    content=content,
                    resource=resource,
                    resource_type=resource_type,
                    mode='edit')


class ProjectView(FlaskView):

    def new(self):
        if flask.request.args.get('returnto'):
            flask.session['returnto'] = flask.request.args.get('returnto')
        return flask.render_template('dialog_project.html',
                    mode='new', **flask.request.args)

    def edit(self):
        if flask.request.args.get('returnto'):
            flask.session['returnto'] = flask.request.args.get('returnto')
        return flask.render_template('dialog_project.html',
                    mode='edit', **flask.request.args)


class AboutView(FlaskView):

    def index(self):
        if flask.request.args.get('returnto'):
            flask.session['returnto'] = flask.request.args.get('returnto')
        return flask.render_template('dialog_about.html')
