from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import Select
from selenium.common.exceptions import NoSuchElementException
import unittest, time, re
import datetime

class CreateProject(unittest.TestCase):
    def setUp(self):
        self.driver = webdriver.Firefox()
        self.driver.implicitly_wait(30)
        self.base_url = "http://network-devel.sugarlabs.org/"
        self.verificationErrors = []
        self.accept_next_alert = True
    
    def test_create_project(self):
        driver = self.driver
        driver.get(self.base_url + "/context?page=1")
        date = str(datetime.date.today())
        driver.find_element_by_xpath("//div[@id='toolbar']/ul/li[7]/div/img").click()
        driver.find_element_by_id("title").clear()
        driver.find_element_by_id("title").send_keys("Autotest " + date)
        driver.find_element_by_id("summary").clear()
        driver.find_element_by_id("summary").send_keys("Automatic Test #1 Pass")
        driver.find_element_by_id("edit-content").clear()
        driver.find_element_by_id("edit-content").send_keys("Create new project")
        driver.find_element_by_id("accept-button").click()
        try: self.assertRegexpMatches(driver.find_element_by_css_selector("BODY").text, r"^[\s\S]*Autotest "+date+"[\s\S]*$")
        except AssertionError as e: self.verificationErrors.append(str(e))
    
    def is_element_present(self, how, what):
        try: self.driver.find_element(by=how, value=what)
        except NoSuchElementException, e: return False
        return True
    
    def is_alert_present(self):
        try: self.driver.switch_to_alert()
        except NoAlertPresentException, e: return False
        return True
    
    def close_alert_and_get_its_text(self):
        try:
            alert = self.driver.switch_to_alert()
            alert_text = alert.text
            if self.accept_next_alert:
                alert.accept()
            else:
                alert.dismiss()
            return alert_text
        finally: self.accept_next_alert = True
    
    def tearDown(self):
        self.driver.quit()
        self.assertEqual([], self.verificationErrors)

if __name__ == "__main__":
    unittest.main()
