#!/usr/bin/env python

import logging
import gobject
from dbus.mainloop.glib import DBusGMainLoop

from sugar_stats import Collector


class CustomCollector(Collector):

    def update(self, stat, value, instance=None):
        postfix = ''
        if instance is not None:
            postfix = instance
        print '%-20s%-10s%s' % (stat, value, postfix)


logging.basicConfig(level=logging.DEBUG)
DBusGMainLoop(set_as_default=True)

collector = CustomCollector()
collector.start()

mainloop = gobject.MainLoop()
try:
    mainloop.run()
except KeyboardInterrupt:
    pass
finally:
    collector.stop()
