# Copyright (C) 2012 Aleksey Lim
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gettext import gettext as _

from sugar_network.toolkit import Option


webui = Option(
        _('start web application to serve Sugar Network content'),
        default=False, type_cast=Option.bool_cast, action='store_true')

webui_host = Option(
        _('hostname to bind'),
        default='127.0.0.1', name='webui-host')

webui_port = Option(
        _('address to listen for Web clients'),
        default=5000, type_cast=int, name='webui-port')
