# Copyright (C) 2012, Sebastian Silva
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from .env import webui, webui_host, webui_port


def get_app(call, api_url, anonymous=False):
    from . import client
    from .client import Client
    from .app import app
    from . import cursors

    client._call = call
    Client.api_url = api_url
    Client.anonymous = anonymous

    if anonymous:
        Client.sugar_uid = 'demo'
        cursors.home_mount = cursors.network_mount
    else:
        Client.sugar_uid = Client.call('GET', [], cmd='whoami')['guid']

    return app
