#Copyright (c) 2009, Walter Bender

#Permission is hereby granted, free of charge, to any person obtaining a copy
#of this software and associated documentation files (the "Software"), to deal
#in the Software without restriction, including without limitation the rights
#to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#copies of the Software, and to permit persons to whom the Software is
#furnished to do so, subject to the following conditions:

#The above copyright notice and this permission notice shall be included in
#all copies or substantial portions of the Software.

#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
#THE SOFTWARE.

import pygtk
pygtk.require('2.0')
import gtk
import gobject

import sugar
from sugar.activity import activity
from sugar.bundle.activitybundle import ActivityBundle
from sugar.activity.widgets import ActivityToolbarButton
from sugar.activity.widgets import StopButton
from sugar.graphics.toolbarbox import ToolbarBox
from sugar.graphics.toolbarbox import ToolbarButton
from sugar.graphics.toolbutton import ToolButton
from sugar.graphics.menuitem import MenuItem
from sugar.graphics.icon import Icon
from sugar.graphics import style
from sugar.datastore import datastore

from sugar import profile
from gettext import gettext as _
import locale
import os.path
from sprites import *

class taWindow: pass

SERVICE = 'org.sugarlabs.CardSortActivity'
IFACE = SERVICE
PATH = '/org/augarlabs/CardSortActivity'
CARD = 135
CARD_DEFS = ((1,3,-2,-3),(2,3,-3,-2),(2,3,-4,-4),\
             (2,1,-1,-4),(3,4,-4,-3),(4,2,-1,-2),\
             (1,1,-2,-4),(4,2,-3,-4),(1,3,-1,-2))


#
# class for defining 3x3 matrix of cards
#
class Grid:
    # 123
    # 456
    # 789
    def __init__(self):
        self.grid = (1,2,3,4,5,6,7,8,9)
        self.card_table = {}

    def swap(self,a,b):
        tmp = self.grid[a]
        self.grid[a] = self.grid[b]
        self.grid[b] = tmp

    def print_grid(self):
        print self.grid
        return

    def test(self):
        for i in (0,1,3,4,6,7):
            if self.card_table[self.grid[i]].east + \
               self.card_table[self.grid[i+1]].west != 0:
                return False
        for i in (0,1,2,3,4,5):
            if self.card_table[self.grid[i]].south + \
               self.card_table[self.grid[i+3]].north != 0:
                return False
        return True


#
# class for defining individual caards
#
class Card:
    # Spade   = 1,-1
    # Heart   = 2,-2
    # Club    = 3,-3
    # Diamond = 4,-4
    def __init__(self):
        self.north = 0
        self.east = 0
        self.south = 0
        self.west = 0
        self.rotate = 0
        self.spr = None

    def rotate_cw(self):
        print "rotating card"
        tmp = self.north
        self.north = self.west
        self.west = self.south
        self.south = self.east
        self.east = tmp
        self.rotate -= 90
        if self.rotate < 0:
            self.rotate += 360
        if self.spr is not None:
            tmp = self.spr.image.rotate_simple(self.rotate)
            self.image = tmp

    def print_card(self):
        print "(" + self.north + "," + self.east + "," + self.south + ","  + \
              self.west + ") " + self.rotation + " x:" + self.spr.x + " y:" + \
              self.spr.y

#
# Sugar activity
#
class CardSortActivity(activity.Activity):

    def __init__(self, handle):
        super(CardSortActivity,self).__init__(handle)

        # Use 0.86 toolbar design
        toolbar_box = ToolbarBox()

        # Buttons added to the Activity toolbar
        activity_button = ActivityToolbarButton(self)
        toolbar_box.toolbar.insert(activity_button, 0)
        activity_button.show()

        # The ever-present Stop Button
        stop_button = StopButton(self)
        stop_button.props.accelerator = '<Ctrl>Q'
        toolbar_box.toolbar.insert(stop_button, -1)
        stop_button.show()

        self.results_label = gtk.Label(_("click to rotate; drag to swap"))
        self.results_label.show()
        results_toolitem = gtk.ToolItem()
        results_toolitem.add(self.results_label)
        toolbar_box.toolbar.insert(results_toolitem,-1)

        self.set_toolbar_box(toolbar_box)
        toolbar_box.show()

        # Create a canvas
        canvas = gtk.DrawingArea()
        canvas.set_size_request(gtk.gdk.screen_width(), \
                                gtk.gdk.screen_height())
        self.set_canvas(canvas)
        self.show_all()

        # Initialize the canvas
        self.tw = taWindow()
        self.tw.window = canvas
        canvas.set_flags(gtk.CAN_FOCUS)
        canvas.add_events(gtk.gdk.BUTTON_PRESS_MASK)
        canvas.add_events(gtk.gdk.BUTTON_RELEASE_MASK)
        canvas.connect("expose-event", self._expose_cb, self.tw)
        canvas.connect("button-press-event", self._button_press_cb, self.tw)
        canvas.connect("button-release-event", self._button_release_cb, self.tw)
        self.tw.width = gtk.gdk.screen_width()
        self.tw.height = gtk.gdk.screen_height()-style.GRID_CELL_SIZE
        self.tw.area = canvas.window
        self.tw.gc = self.tw.area.new_gc()
        self.tw.scale = 5
        self.tw.cm = self.tw.gc.get_colormap()
        self.tw.msgcolor = self.tw.cm.alloc_color('black')

        # Initialize the grid
        self.tw.sprites = []
        self.tw.path = os.path.join(activity.get_bundle_path(),'images')
        self.tw.press = -1
        self.tw.release = -1
        self.tw.foo = Card()
        print self.tw.foo.north
        self.tw.grid = Grid()

        # Initialize the cards
        self.tw.card_shapes = {}
        i = 0
        for c in CARD_DEFS:
            self.tw.grid.card_table[i] = Card()
            self.tw.grid.card_table[i].north = c[0]
            self.tw.grid.card_table[i].east  = c[1]
            self.tw.grid.card_table[i].south = c[2]
            self.tw.grid.card_table[i].west  = c[3]
            self.tw.grid.card_table[i].rotate = 0
            self.tw.grid.card_table[i].spr = None
            i += 1
        x = (self.tw.width-(CARD*3))/2
        y = (self.tw.height-(CARD*3))/2
        for i in range(0,9):
            self.tw.card_shapes['card'+str(i)] = \
                self.load_image(self.tw.path, '', 'card'+str(i))
            self.tw.grid.card_table[i].spr = \
                sprNew(self.tw,x,y,self.tw.card_shapes['card'+ str(i)])
            self.tw.grid.card_table[i].spr.label = str(i)
            setlayer(self.tw.grid.card_table[i].spr,2000)
            draw(self.tw.grid.card_table[i].spr)
            # self.tw.cards[i].draw(x,y)
            x += CARD
            if x > (self.tw.width+(CARD*2))/2:
                x = (self.tw.width-(CARD*3))/2
                y += CARD

    def load_image(self,path, dir, file):
        return gtk.gdk.pixbuf_new_from_file(os.path.join(path, \
                                                         dir, \
                                                         file +'.svg'))
    #
    # Repaint
    #
    def _expose_cb(self, win, event, tw):
        redrawsprites(tw)
        return True

    #
    # Button press
    #
    def _button_press_cb(self, win, event, tw):
        win.grab_focus()
        x, y = map(int, event.get_coords())
        # print "button press: " + str(x) + " " + str(y)
        spr = findsprite(tw,(x,y))
        if spr is None:
            # print "no spr found on button press"
            tw.press = -1
            tw.release = -1
            return True
        # print "found spr: " + spr.label
        # take note of card under button press
        tw.press = int(spr.label)
        return True

    #
    # Button press
    #
    def _button_release_cb(self, win, event, tw):
        win.grab_focus()
        x, y = map(int, event.get_coords())
        # print "button release: " + str(x) + " " + str(y)
        spr = findsprite(tw,(x,y))
        if spr is None:
            # print "no spr found on button release"
            tw.press = -1
            tw.release = -1
            return True
        # take note of card under button release
        tw.release = int(spr.label)
        # if the same card (click) then rotate
        if tw.press == tw.release:
            print "rotating: " + spr.label
            tmp = tw.grid.card_table[tw.press].spr.image.rotate_simple(90)
            tw.grid.card_table[tw.press].spr.image = tmp

            tw.grid.card_table[tw.press].print_card

        # if different card (drag) then swap
        else:
            x = tw.grid.card_table[tw.press].spr.x
            y = tw.grid.card_table[tw.press].spr.y
            tw.grid.card_table[tw.press].spr.x = \
                tw.grid.card_table[tw.release].spr.x
            tw.grid.card_table[tw.press].spr.y = \
                tw.grid.card_table[tw.release].spr.y
            tw.grid.card_table[tw.release].spr.x = x
            tw.grid.card_table[tw.release].spr.y = y
            print "swapping: " + str(tw.press) + " and " + str(tw.release)
        inval(tw.grid.card_table[tw.press].spr)
        inval(tw.grid.card_table[tw.release].spr)
        redrawsprites(tw)
        tw.press = -1
        tw.release = -1
        if tw.grid.test() == True:
            self.results_label.set_text(_("You solved the puzzle."))
            self.results_label.show()
        else:
            self.results_label.set_text(_("Keep trying."))
            self.results_label.show()

        return True

    #
    # Mouse move (animate drag?)
    #

