# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os
from gettext import gettext as _

from gi.repository import Gtk
from gi.repository import GObject
from gi.repository import WebKit

from sugar3.activity import activity
from sugar3.graphics.toolbutton import ToolButton
from sugar3.graphics.toolbarbox import ToolbarBox
from sugar3.graphics.toolbarbox import ToolbarButton
from sugar3.activity.widgets import ActivityToolbarButton
from sugar3.activity.widgets import StopButton

from viewtoolbar import ViewToolbar

HOME = 'file://' + os.path.join(activity.get_bundle_path(),
                                'help/index.html')


class HelpActivity(activity.Activity):
    def __init__(self, handle):
        activity.Activity.__init__(self, handle)

        self.props.max_participants = 1

        self._web_view = WebKit.WebView()
        self._web_view.set_full_content_zoom(True)

        _scrolled_window = Gtk.ScrolledWindow()
        _scrolled_window.add(self._web_view)
        _scrolled_window.show()

        toolbar_box = ToolbarBox()

        activity_button = ActivityToolbarButton(self)
        toolbar_box.toolbar.insert(activity_button, 0)
        activity_button.show()

        viewtoolbar = ViewToolbar(self)
        viewbutton = ToolbarButton(page=viewtoolbar, \
                                   icon_name='toolbar-view')
        toolbar_box.toolbar.insert(viewbutton, -1)
        viewbutton.show()

        separator = Gtk.SeparatorToolItem()
        #separator.props.draw = False
        #separator.set_expand(True)
        toolbar_box.toolbar.insert(separator, -1)
        separator.show()

        #lets reuse the code below
        navtoolbar = Toolbar(self._web_view)

        toolitem = Gtk.ToolItem()
        navtoolbar._home.reparent(toolitem)
        toolbar_box.toolbar.insert(toolitem, -1)
        navtoolbar._home.show()
        toolitem.show()

        toolitem = Gtk.ToolItem()
        navtoolbar._back.reparent(toolitem)
        toolbar_box.toolbar.insert(toolitem, -1)
        navtoolbar._back.show()
        toolitem.show()

        toolitem = Gtk.ToolItem()
        navtoolbar._forward.reparent(toolitem)
        toolbar_box.toolbar.insert(toolitem, -1)
        navtoolbar._forward.show()
        toolitem.show()

        # we do not have collaboration features
        # make the share option insensitive
        self.max_participants = 1

        separator = Gtk.SeparatorToolItem()
        separator.props.draw = False
        separator.set_expand(True)
        toolbar_box.toolbar.insert(separator, -1)
        separator.show()

        stop_button = StopButton(self)
        toolbar_box.toolbar.insert(stop_button, -1)
        stop_button.show()

        self.set_toolbar_box(toolbar_box)
        toolbar_box.show()

        self.set_canvas(_scrolled_window)
        self._web_view.show()
        self._web_view.load_uri(HOME)


class Toolbar(Gtk.Toolbar):
    def __init__(self, web_view):
        GObject.GObject.__init__(self)

        self._web_view = web_view

        self._back = ToolButton('go-previous-paired')
        self._back.set_tooltip(_('Back'))
        self._back.props.sensitive = False
        self._back.connect('clicked', self._go_back_cb)
        self.insert(self._back, -1)
        self._back.show()

        self._forward = ToolButton('go-next-paired')
        self._forward.set_tooltip(_('Forward'))
        self._forward.props.sensitive = False
        self._forward.connect('clicked', self._go_forward_cb)
        self.insert(self._forward, -1)
        self._forward.show()

        self._home = ToolButton('go-home')
        self._home.set_tooltip(_('Home'))
        self._home.connect('clicked', self._go_home_cb)
        self.insert(self._home, -1)
        self._home.show()

        self._web_view.connect('notify::uri', self._uri_changed_cb)

    def _uri_changed_cb(self, progress_listener, uri):
        self.update_navigation_buttons()

    def _loading_stop_cb(self, progress_listener):
        self.update_navigation_buttons()

    def update_navigation_buttons(self):
        self._back.props.sensitive = self._web_view.can_go_back()
        self._forward.props.sensitive = self._web_view.can_go_forward()

    def _go_back_cb(self, button):
        self._web_view.go_back()

    def _go_forward_cb(self, button):
        self._web_view.go_forward()

    def _go_home_cb(self, button):
        self._web_view.load_uri(HOME)
