"""
 aplay.py
 refactored based on Jukebox Activity
 Copyright (C) 2007 Andy Wingo <wingo@pobox.com>
 Copyright (C) 2007 Red Hat, Inc.
 Copyright (C) 2008-2010 Kushal Das <kushal@fedoraproject.org>
 Copyright (C) 2010-11 Walter Bender
"""

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA


import subprocess

def play_audio_from_file(parent, file_path):
    """ Audio media """
    command_line = ['gst-launch', 'filesrc', 'location=' + file_path,
                    '! oggdemux', '! vorbisdec', '! audioconvert',
                    '! alsasink']
    try:
        subprocess.call(command_line)
    except:
        try:
            command_line = ['gst-launch-10', 'filesrc',
                            'location=' + file_path,
                            '! oggdemux', '! vorbisdec', '! audioconvert',
                            '! alsasink']
            subprocess.call(command_line)
        except:
            pass

