# -*- coding: utf-8 -*-
from gettext import gettext as _

# ================================= CATALOG DATA ================================
#
# Constellation Stick-figures -- this is a map of <identifier> to an array that
# contains a <name_string> a <count> and an array of line segments between a
# pair of points in the sky specified as right ascention and declination (J2000)
# specifying the two points as four coordinates expressed as fractional degrees.
#
#	Constellation line segments (J2000 coordinates)
#      RA start     Dec Start       RA End        Dec End
data = {                                                     \
'And' : [ _("Andromeda"), [                                  \
  (    2.065000,    42.329722,     1.162222,    35.620556),  \
  (    1.162222,    35.620556,     0.655556,    30.860833),  \
  (    0.655556,    30.860833,     0.139722,    29.090556),  \
  (    0.139722,    29.090556,     0.614722,    33.719444),  \
  (    0.614722,    33.719444,     0.945833,    38.499444),  \
  (    0.945833,    38.499444,    23.626111,    46.458056),  \
  (   23.626111,    46.458056,    23.031944,    42.326111),  \
  (    0.945833,    38.499444,     1.158333,    47.241944),  \
]],                                                          \
'Ant' : [ _("Antlia"), [                                     \
  (   10.945278,   -37.137778,    10.452500,   -31.067778),  \
  (   10.452500,   -31.067778,     9.487500,   -35.951389),  \
]],                                                          \
'Aps' : [ _("Apus"),  [                                      \
  (   16.718056,   -77.517500,    16.339167,   -78.695833),  \
  (   16.339167,   -78.695833,    16.557500,   -78.897222),  \
  (   16.718056,   -77.517500,    16.557500,   -78.897222),  \
  (   16.440833,   -78.794444,    14.797778,   -79.044722),  \
]],                                                          \
'Aqr' : [ _("Aquarius"), [                                   \
  (   20.794722,    -9.495833,    21.525278,    -5.571111),  \
  (   21.525278,    -5.571111,    22.055278,    -2.155278),  \
  (   22.055278,    -2.155278,    22.360833,    -1.387222),  \
  (   22.360833,    -1.387222,    22.480556,    -0.020000),  \
  (   22.480556,    -0.020000,    22.589167,    -0.117500),  \
  (   22.480556,    -0.020000,    22.421389,     1.377500),  \
  (   22.421389,     1.377500,    22.876944,    -7.579722),  \
  (   22.876944,    -7.579722,    23.238611,    -6.048889),  \
  (   23.238611,    -6.048889,    23.316111,    -9.610833),  \
  (   23.316111,    -9.610833,    23.711944,   -14.545000),  \
  (   23.711944,   -14.545000,    23.766944,   -18.678056),  \
  (   23.766944,   -18.678056,    23.434167,   -20.641944),  \
  (   23.434167,   -20.641944,    23.157500,   -21.172500),  \
  (   23.157500,   -21.172500,    22.910833,   -15.820833),  \
  (   22.910833,   -15.820833,    22.826667,   -13.592500),  \
  (   22.826667,   -13.592500,    22.876944,    -7.579722),  \
  (   23.157500,   -21.172500,    22.960833,   -29.622222),  \
]],                                                          \
'Aql' : [ _("Aquila"), [                                     \
  (   18.993611,    15.068333,    19.090278,    13.863333),  \
  (   19.090278,    13.863333,    19.771111,    10.613333),  \
  (   19.771111,    10.613333,    19.846389,     8.868333),  \
  (   19.846389,     8.868333,    19.921944,     6.406667),  \
  (   19.921944,     6.406667,    20.188333,    -0.821389),  \
  (   20.188333,    -0.821389,    19.874444,     1.005556),  \
  (   19.874444,     1.005556,    19.611944,    -1.286389),  \
  (   19.611944,    -1.286389,    19.104167,    -4.882500),  \
  (   19.104167,    -4.882500,    19.425000,     3.114722),  \
  (   19.425000,     3.114722,    19.771111,    10.613333),  \
  (   19.104167,    -4.882500,    19.028056,    -5.738889),  \
]],                                                          \
'Ara' : [ _("Ara"), [                                        \
  (   18.110556,   -50.091667,    17.530833,   -49.875833),  \
  (   17.530833,   -49.875833,    17.421667,   -55.530000),  \
  (   17.421667,   -55.530000,    17.423333,   -56.377778),  \
  (   17.423333,   -56.377778,    17.518333,   -60.683889),  \
  (   17.421667,   -55.530000,    16.976944,   -55.990278),  \
  (   16.976944,   -55.990278,    16.993056,   -53.160556),  \
  (   16.976944,   -55.990278,    16.829722,   -59.041389),  \
]],                                                          \
'Ari' : [ _("Aries"), [                                      \
  (    3.193889,    19.726667,     2.119444,    23.462500),  \
  (    2.119444,    23.462500,     1.910556,    20.808056),  \
  (    1.910556,    20.808056,     1.892222,    19.293889),  \
]],                                                          \
'Aur' : [ _("Auriga"), [                                     \
  (    5.438333,    28.607500,     5.995278,    37.212500),  \
  (    5.995278,    37.212500,     5.992222,    44.947500),  \
  (    5.992222,    44.947500,     5.992222,    54.284722),  \
  (    5.992222,    54.284722,     5.278056,    45.998056),  \
  (    5.278056,    45.998056,     5.108611,    41.234444),  \
  (    5.108611,    41.234444,     4.950000,    33.166111),  \
  (    4.950000,    33.166111,     5.438333,    28.607500),  \
  (    5.992222,    44.947500,     5.278056,    45.998056),  \
]],                                                          \
'Boo' : [ _("Boötes"), [                                     \
  (   14.261111,    19.182500,    14.685833,    13.728333),  \
  (   14.261111,    19.182500,    13.911389,    18.397778),  \
  (   13.911389,    18.397778,    13.824722,    15.797778),  \
  (   14.261111,    19.182500,    14.749722,    27.074167),  \
  (   14.749722,    27.074167,    15.258333,    33.314722),  \
  (   15.258333,    33.314722,    15.032500,    40.390556),  \
  (   15.032500,    40.390556,    14.578056,    29.745000),  \
  (   14.578056,    29.745000,    14.261111,    19.182500),  \
  (   15.032500,    40.390556,    14.273056,    46.088333),  \
  (   14.273056,    46.088333,    14.420000,    51.850833),  \
]],                                                          \
'Cae' : [ _("Caelum"), [                                     \
  (    5.073333,   -35.482778,     4.701111,   -37.144444),  \
  (    4.701111,   -37.144444,     4.676111,   -41.863889),  \
  (    4.676111,   -41.863889,     4.513889,   -44.953889),  \
]],                                                          \
'Cam' : [ _("Camelopardalis"), [                             \
  (    6.895000,    68.888333,     6.214167,    65.718333),  \
  (    6.214167,    65.718333,     4.900833,    66.342778),  \
  (    4.900833,    66.342778,     3.839444,    71.332222),  \
  (    4.900833,    66.342778,     5.056944,    60.442222),  \
  (    5.056944,    60.442222,     4.954722,    53.752222),  \
]],                                                          \
'Cnc' : [ _("Cancer"), [                                     \
  (    8.778333,    28.760000,     8.721389,    21.468611),  \
  (    8.721389,    21.468611,     8.744722,    18.154167),  \
  (    8.744722,    18.154167,     8.974722,    11.857778),  \
  (    8.744722,    18.154167,     8.445556,    12.654444),  \
  (    8.445556,    12.654444,     8.275278,     9.185556),  \
]],                                                          \
'Cvn' : [ _("Canis Venatici"), [                             \
  (   13.292500,    40.572500,    13.228611,    40.152778),  \
  (   13.228611,    40.152778,    12.933889,    38.318333),  \
  (   12.933889,    38.318333,    12.562500,    41.357500),  \
]],                                                          \
'Cma' : [ _("Canis Major"), [                                \
  (    6.752500,   -16.716111,     7.062778,   -15.633333),  \
  (    6.752500,   -16.716111,     6.378333,   -17.955833),  \
  (    6.752500,   -16.716111,     6.892500,   -20.224167),  \
  (    6.892500,   -20.224167,     7.050556,   -23.833333),  \
  (    7.050556,   -23.833333,     7.140000,   -26.393333),  \
  (    7.140000,   -26.393333,     7.028611,   -27.934722),  \
  (    7.028611,   -27.934722,     6.977222,   -28.972222),  \
  (    6.977222,   -28.972222,     6.338611,   -30.063333),  \
  (    7.140000,   -26.393333,     7.276389,   -27.881111),  \
  (    7.276389,   -27.881111,     7.401667,   -29.303056),  \
]],                                                          \
'Cmi' : [ _("Canis Minor"), [                                \
  (    7.655000,     5.225000,     7.452500,     8.289444),  \
]],                                                          \
'Cap' : [ _("Capricornus"), [                                \
  (   21.783889,   -16.127222,    21.668333,   -16.662222),  \
  (   21.668333,   -16.662222,    21.370833,   -16.834444),  \
  (   21.370833,   -16.834444,    21.099167,   -17.232778),  \
  (   21.099167,   -17.232778,    20.294167,   -12.508333),  \
  (   20.294167,   -12.508333,    20.346389,   -14.785000),  \
  (   20.346389,   -14.785000,    20.768333,   -25.270833),  \
  (   20.768333,   -25.270833,    20.863611,   -26.919167),  \
  (   20.863611,   -26.919167,    21.118889,   -25.005833),  \
  (   21.118889,   -25.005833,    21.444444,   -22.411389),  \
  (   21.444444,   -22.411389,    21.618056,   -19.465833),  \
  (   21.618056,   -19.465833,    21.783889,   -16.127222),  \
]],                                                          \
'Car' : [ _("Carina"), [                                     \
  (    6.399167,   -52.695833,     7.946389,   -52.982222),  \
  (    7.946389,   -52.982222,     8.375278,   -59.509722),  \
  (    8.375278,   -59.509722,     9.182778,   -58.966944),  \
  (    9.182778,   -58.966944,     9.284722,   -59.275278),  \
  (    9.284722,   -59.275278,    10.456667,   -57.638889),  \
  (   10.456667,   -57.638889,    10.533611,   -61.685278),  \
  (   10.533611,   -61.685278,    10.715833,   -64.394444),  \
  (   10.715833,   -64.394444,    10.228889,   -70.038056),  \
  (   10.228889,   -70.038056,     9.220000,   -69.717222),  \
  (    9.220000,   -69.717222,     9.785000,   -65.071944),  \
  (    9.785000,   -65.071944,     9.284722,   -59.275278),  \
]],                                                          \
'Cas' : [ _("Cassiopeia"), [                                 \
  (    1.906667,    63.670000,     1.430278,    60.235278),  \
  (    1.430278,    60.235278,     0.945278,    60.716667),  \
  (    0.945278,    60.716667,     0.675278,    56.537222),  \
  (    0.675278,    56.537222,     0.153056,    59.149722),  \
]],                                                          \
'Cen' : [ _("Centaurus"), [                                  \
  (   14.660000,   -60.835278,    14.063611,   -60.373056),  \
  (   14.063611,   -60.373056,    13.664722,   -53.466389),  \
  (   13.664722,   -53.466389,    12.691944,   -48.959722),  \
  (   12.691944,   -48.959722,    12.139444,   -50.722500),  \
  (   12.139444,   -50.722500,    11.350000,   -54.491111),  \
  (   11.350000,   -54.491111,    11.596389,   -63.019722),  \
  (   13.664722,   -53.466389,    13.925556,   -47.288333),  \
  (   13.925556,   -47.288333,    14.591667,   -42.157778),  \
  (   14.591667,   -42.157778,    14.111389,   -36.370000),  \
  (   14.111389,   -36.370000,    13.343333,   -36.712222),  \
  (   13.343333,   -36.712222,    12.691944,   -48.959722),  \
  (   14.591667,   -42.157778,    14.986111,   -42.104167),  \
]],                                                          \
'Cep' : [ _("Cepheus"), [                                    \
  (   23.655833,    77.632500,    21.477778,    70.560833),  \
  (   21.477778,    70.560833,    21.309722,    62.585556),  \
  (   21.309722,    62.585556,    22.180833,    58.201111),  \
  (   22.180833,    58.201111,    22.828056,    66.200556),  \
  (   22.828056,    66.200556,    23.655833,    77.632500),  \
  (   21.477778,    70.560833,    22.828056,    66.200556),  \
]],                                                          \
'Cet' : [ _("Cetus"), [                                      \
  (    0.323889,    -8.823889,     0.726389,   -17.986667),  \
  (    0.726389,   -17.986667,     1.143056,   -10.182222),  \
  (    1.143056,   -10.182222,     1.400278,    -8.183333),  \
  (    1.400278,    -8.183333,     1.857778,   -10.335000),  \
  (    1.857778,   -10.335000,     2.735278,   -13.858611),  \
  (    1.857778,   -10.335000,     1.734444,   -15.937500),  \
  (    1.734444,   -15.937500,     2.000000,   -21.077778),  \
  (    1.857778,   -10.335000,     2.322500,    -2.977500),  \
  (    2.322500,    -2.977500,     2.658056,     0.328611),  \
  (    2.658056,     0.328611,     2.721667,     3.235833),  \
  (    2.721667,     3.235833,     3.038056,     4.089722),  \
  (    3.038056,     4.089722,     2.995278,     8.907500),  \
  (    2.995278,     8.907500,     2.749167,    10.114167),  \
  (    2.749167,    10.114167,     2.469444,     8.460000),  \
  (    2.469444,     8.460000,     2.721667,     3.235833),  \
]],                                                          \
'Cha' : [ _("Chamaeleon"), [                                 \
  (   12.305750,   -79.312222,    10.591139,   -78.607778),  \
  (   10.591139,   -78.607778,     8.308778,   -76.919722),  \
  (    8.308778,   -76.919722,    10.763000,   -80.540278),  \
  (   10.763000,   -80.540278,    12.305750,   -79.312222),  \
]],                                                          \
'Cir' : [ _("Circinus"), [                                   \
  (   15.389722,   -59.320833,    14.708333,   -64.975278),  \
  (   14.708333,   -64.975278,    15.291944,   -58.801111),  \
]],                                                          \
'Col' : [ _("Columba"), [                                    \
  (    5.985833,   -42.815278,     5.849444,   -35.768333),  \
  (    5.849444,   -35.768333,     5.958889,   -35.283333),  \
  (    5.958889,   -35.283333,     6.368611,   -33.436389),  \
  (    5.849444,   -35.768333,     5.660833,   -34.074167),  \
  (    5.660833,   -34.074167,     5.520278,   -35.470556),  \
]],                                                          \
'Com' : [ _("Coma Berenices"), [                             \
  (   13.166389,    17.529444,    13.197778,    27.878056),  \
  (   13.197778,    27.878056,    12.448889,    28.268333),  \
]],                                                          \
'Cra' : [ _("Corona Australis"), [                           \
  (   18.978611,   -37.107500,    19.106944,   -37.063333),  \
  (   19.106944,   -37.063333,    19.157778,   -37.904444),  \
  (   19.157778,   -37.904444,    19.167222,   -39.340833),  \
  (   19.167222,   -39.340833,    19.139167,   -40.496667),  \
  (   19.139167,   -40.496667,    19.051944,   -42.095278),  \
  (   19.051944,   -42.095278,    18.814167,   -43.680000),  \
  (   18.814167,   -43.680000,    18.558333,   -42.312500),  \
]],                                                          \
'Crb' : [ _("Corona Borealis"), [                            \
  (   16.024167,    29.851111,    15.959722,    26.877778),  \
  (   15.959722,    26.877778,    15.826667,    26.068333),  \
  (   15.826667,    26.068333,    15.712500,    26.295556),  \
  (   15.712500,    26.295556,    15.578056,    26.714722),  \
  (   15.578056,    26.714722,    15.463889,    29.105833),  \
  (   15.463889,    29.105833,    15.548889,    31.359167),  \
]],                                                          \
'Crv' : [ _("Corvus"), [                                     \
  (   12.140278,   -24.728889,    12.168889,   -22.619722),  \
  (   12.168889,   -22.619722,    12.573056,   -23.396667),  \
  (   12.573056,   -23.396667,    12.497778,   -16.515556),  \
  (   12.497778,   -16.515556,    12.263333,   -17.541944),  \
  (   12.263333,   -17.541944,    12.168889,   -22.619722),  \
]],                                                          \
'Crt' : [ _("Crater"), [                                     \
  (   10.827222,   -16.193611,    10.996389,   -18.298889),  \
  (   10.996389,   -18.298889,    11.194444,   -22.825833),  \
  (   10.996389,   -18.298889,    11.366944,   -16.225000),  \
  (   11.933611,   -17.150833,    11.746111,   -18.350833),  \
  (   11.746111,   -18.350833,    11.414722,   -17.683889),  \
  (   11.414722,   -17.683889,    11.322500,   -14.778611),  \
  (   11.322500,   -14.778611,    11.410278,   -10.859444),  \
  (   11.410278,   -10.859444,    11.611389,    -9.802222),  \
]],                                                          \
'Cru' : [ _("Crux"), [                                       \
  (   12.795278,   -59.688611,    12.252500,   -58.748889),  \
  (   12.443333,   -63.098889,    12.519444,   -57.113056),  \
]],                                                          \
'Cyg' : [ _("Cygnus"), [                                     \
  (   20.690556,    45.280278,    20.370556,    40.256667),  \
  (   20.370556,    40.256667,    20.770278,    33.970278),  \
  (   20.370556,    40.256667,    19.749722,    45.130833),  \
  (   20.370556,    40.256667,    19.938333,    35.083333),  \
  (   19.938333,    35.083333,    19.511944,    27.959722),  \
]],                                                          \
'Del' : [ _("Delphinus"), [                                  \
  (   20.625833,    14.595278,    20.553611,    11.303333),  \
  (   20.625833,    14.595278,    20.724444,    15.074444),  \
  (   20.724444,    15.074444,    20.777778,    16.124167),  \
  (   20.777778,    16.124167,    20.660556,    15.911944),  \
  (   20.660556,    15.911944,    20.625833,    14.595278),  \
]],                                                          \
'Dor' : [ _("Dorado"), [                                     \
  (    5.746111,   -65.735556,     5.560556,   -62.489722),  \
  (    5.560556,   -62.489722,     4.533333,   -55.045000),  \
  (    4.533333,   -55.045000,     4.267222,   -51.486667),  \
]],                                                          \
'Dra' : [ _("Draco"), [                                      \
  (   11.523333,    69.331111,    12.558056,    69.788333),  \
  (   12.558056,    69.788333,    14.073056,    64.375833),  \
  (   14.073056,    64.375833,    15.415556,    58.966111),  \
  (   15.415556,    58.966111,    16.031389,    58.565278),  \
  (   16.031389,    58.565278,    16.400000,    61.514167),  \
  (   16.400000,    61.514167,    17.146389,    65.714722),  \
  (   17.146389,    65.714722,    18.350833,    72.732778),  \
  (   18.350833,    72.732778,    19.259167,    73.355556),  \
  (   19.259167,    73.355556,    19.802778,    70.267778),  \
  (   19.802778,    70.267778,    20.046944,    67.873611),  \
  (   20.046944,    67.873611,    18.853333,    59.388333),  \
  (   18.853333,    59.388333,    17.892222,    56.872778),  \
  (   17.892222,    56.872778,    17.943333,    51.488889),  \
  (   17.943333,    51.488889,    17.507222,    52.301389),  \
  (   17.507222,    52.301389,    17.537778,    55.173056),  \
  (   17.537778,    55.173056,    17.892222,    56.872778),  \
  (   17.892222,    56.872778,    19.344444,    65.714722),  \
  (   19.344444,    65.714722,    19.209167,    67.661667),  \
  (   19.209167,    67.661667,    18.346111,    71.337778),  \
  (   18.346111,    71.337778,    17.146389,    65.714722),  \
]],                                                          \
'Equ' : [ _("Equuleus"), [                                   \
  (   21.263611,     5.247778,    21.241389,    10.006944),  \
  (   21.241389,    10.006944,    21.172500,    10.131667),  \
]],                                                          \
'Eri' : [ _("Eridanus"), [                                   \
  (    5.130833,    -5.086389,     4.758333,    -3.254722),  \
  (    4.758333,    -3.254722,     4.605278,    -3.352500),  \
  (    4.605278,    -3.352500,     4.197778,    -6.837500),  \
  (    4.197778,    -6.837500,     3.967222,   -13.508611),  \
  (    3.967222,   -13.508611,     3.769167,   -12.101667),  \
  (    3.769167,   -12.101667,     3.720833,    -9.763333),  \
  (    3.720833,    -9.763333,     3.548889,    -9.458333),  \
  (    3.548889,    -9.458333,     3.263889,    -8.819722),  \
  (    3.263889,    -8.819722,     2.940556,    -8.898056),  \
  (    2.940556,    -8.898056,     2.735278,   -13.858611),  \
  (    2.735278,   -13.858611,     2.751667,   -18.572500),  \
  (    2.751667,   -18.572500,     3.040000,   -23.624444),  \
  (    3.040000,   -23.624444,     3.325278,   -21.757778),  \
  (    3.325278,   -21.757778,     3.563056,   -21.632778),  \
  (    3.563056,   -21.632778,     3.780833,   -23.249722),  \
  (    3.780833,   -23.249722,     3.895278,   -24.612500),  \
  (    3.895278,   -24.612500,     3.998889,   -24.016389),  \
  (    3.998889,   -24.016389,     4.558611,   -29.766667),  \
  (    4.558611,   -29.766667,     4.592500,   -30.562222),  \
  (    4.592500,   -30.562222,     4.400556,   -34.016944),  \
  (    4.400556,   -34.016944,     4.298333,   -33.798333),  \
  (    4.298333,   -33.798333,     3.810000,   -37.620556),  \
  (    3.810000,   -37.620556,     3.713889,   -37.313611),  \
  (    3.713889,   -37.313611,     2.971111,   -40.304722),  \
  (    2.971111,   -40.304722,     2.677778,   -39.855556),  \
  (    2.677778,   -39.855556,     2.663333,   -42.891667),  \
  (    2.663333,   -42.891667,     2.449722,   -47.703889),  \
  (    2.449722,   -47.703889,     2.275278,   -51.512222),  \
  (    2.275278,   -51.512222,     1.932778,   -51.608889),  \
  (    1.932778,   -51.608889,     1.628611,   -57.236667),  \
]],                                                          \
'For' : [ _("Fornax"), [                                     \
# Officially, this constellation has no figure.  But I'm drawing
# a single line from Alpha For to Beta For just so there's some
# object to correspond to the constellation name.
  (    3.201194,   -28.986944,     2.818167,   -32.405833),  \
]],                                                          \
'Gem' : [ _("Gemini"), [                                     \
  (    6.754722,    12.895556,     6.628611,    16.399167),  \
  (    6.628611,    16.399167,     7.068611,    20.570278),  \
  (    7.068611,    20.570278,     7.335278,    21.982222),  \
  (    7.335278,    21.982222,     7.755278,    28.026111),  \
  (    7.755278,    28.026111,     7.576667,    31.888333),  \
  (    7.576667,    31.888333,     6.732222,    25.131111),  \
  (    6.732222,    25.131111,     6.382778,    22.513611),  \
  (    6.382778,    22.513611,     6.248056,    22.506667),  \
  (    6.248056,    22.506667,     6.068611,    23.263333),  \
]],                                                          \
'Gru' : [ _("Grus"), [                                       \
  (   21.898889,   -37.365000,    21.988333,   -38.395278),  \
  (   21.988333,   -38.395278,    22.101944,   -39.543333),  \
  (   22.101944,   -39.543333,    22.260278,   -41.346667),  \
  (   22.260278,   -41.346667,    22.487778,   -43.495556),  \
  (   22.487778,   -43.495556,    22.137222,   -46.961111),  \
  (   22.487778,   -43.495556,    22.711111,   -46.884722),  \
  (   22.711111,   -46.884722,    23.172778,   -45.246667),  \
  (   23.172778,   -45.246667,    23.110833,   -43.503611),  \
  (   22.711111,   -46.884722,    22.809167,   -51.316944),  \
  (   22.809167,   -51.316944,    23.014722,   -52.754167),  \
]],                                                          \
'Her' : [ _("Hercules"), [                                   \
  (   18.125833,    28.762500,    17.962778,    29.247778),  \
  (   17.962778,    29.247778,    17.774444,    27.720556),  \
  (   17.774444,    27.720556,    17.512222,    26.110556),  \
  (   17.512222,    26.110556,    17.250556,    24.839167),  \
  (   17.250556,    24.839167,    17.244167,    14.390278),  \
  (   17.250556,    24.839167,    17.004722,    30.926389),  \
  (   17.004722,    30.926389,    16.688056,    31.603056),  \
  (   16.688056,    31.603056,    16.503611,    21.489722),  \
  (   16.503611,    21.489722,    16.365278,    19.153056),  \
  (   16.688056,    31.603056,    16.715000,    38.922222),  \
  (   16.715000,    38.922222,    16.568333,    42.436944),  \
  (   16.568333,    42.436944,    16.328889,    46.313333),  \
  (   16.328889,    46.313333,    16.146111,    44.935000),  \
  (   16.146111,    44.935000,    15.878056,    42.451667),  \
  (   16.715000,    38.922222,    17.250833,    36.809167),  \
  (   17.250833,    36.809167,    17.657778,    46.006389),  \
  (   17.250833,    36.809167,    17.394722,    37.145833),  \
  (   17.394722,    37.145833,    17.937500,    37.250556),  \
  (   17.004722,    30.926389,    17.250833,    36.809167),  \
]],                                                          \
'Hor' : [ _("Horologium"), [                                 \
  (    4.233333,   -42.294444,     2.709444,   -50.800278),  \
  (    2.709444,   -50.800278,     2.623333,   -52.543056),  \
  (    2.623333,   -52.543056,     2.694444,   -54.550000),  \
  (    2.677778,   -54.550000,     3.060278,   -59.737778),  \
  (    3.060278,   -59.737778,     2.980000,   -64.071389),  \
]],                                                          \
'Hya' : [ _("Hydra"), [                                      \
  (   14.106111,   -26.682500,    13.315278,   -23.171667),  \
  (   13.315278,   -23.171667,    11.881944,   -33.908056),  \
  (   11.881944,   -33.908056,    11.550000,   -31.857778),  \
  (   11.550000,   -31.857778,    10.827222,   -16.193611),  \
  (   10.827222,   -16.193611,    10.434722,   -16.836389),  \
  (   10.434722,   -16.836389,    10.176389,   -12.354167),  \
  (   10.176389,   -12.354167,     9.858056,   -14.846667),  \
  (    9.858056,   -14.846667,     9.459722,    -8.658611),  \
  (    9.459722,    -8.658611,     9.664167,    -1.142778),  \
  (    9.664167,    -1.142778,     9.239444,     2.314167),  \
  (    9.239444,     2.314167,     8.923333,     5.945556),  \
  (    8.923333,     5.945556,     8.779722,     6.418889),  \
  (    8.779722,     6.418889,     8.627500,     5.703611),  \
  (    8.627500,     5.703611,     8.645833,     3.341389),  \
  (    8.645833,     3.341389,     8.720556,     3.398611),  \
  (    8.720556,     3.398611,     8.923333,     5.945556),  \
]],                                                          \
'Hyi' : [ _("Hydrus"), [                                     \
  (    1.979444,   -61.569722,     3.787222,   -74.238889),  \
  (    3.787222,   -74.238889,     0.429167,   -77.254167),  \
  (    0.429167,   -77.254167,     1.979444,   -61.569722),  \
]],                                                          \
'Ind' : [ _("Indus"), [                                      \
  (   20.626111,   -47.291389,    21.331111,   -53.449722),  \
  (   21.331111,   -53.449722,    20.913611,   -58.454167),  \
  (   21.965278,   -54.992500,    21.331111,   -53.449722),  \
]],                                                          \
'Lac' : [ _("Lacerta"), [                                    \
  (   22.266111,    37.748889,    22.675278,    44.276389),  \
  (   22.675278,    44.276389,    22.350556,    46.536667),  \
  (   22.350556,    46.536667,    22.492222,    47.706944),  \
  (   22.492222,    47.706944,    22.408611,    49.476389),  \
  (   22.408611,    49.476389,    22.521667,    50.282500),  \
  (   22.521667,    50.282500,    22.392778,    52.229167),  \
]],                                                          \
'Leo' : [ _("Leo"), [                                        \
  (    9.764167,    23.774167,     9.879444,    26.006944),  \
  (    9.879444,    26.006944,    10.278056,    23.417222),  \
  (   10.278056,    23.417222,    10.332778,    19.841667),  \
  (   10.332778,    19.841667,    10.122222,    16.762778),  \
  (   10.122222,    16.762778,    10.139444,    11.967222),  \
  (   10.139444,    11.967222,    11.237222,    15.429444),  \
  (   11.237222,    15.429444,    11.817778,    14.571944),  \
  (   11.817778,    14.571944,    11.235278,    20.523611),  \
  (   11.235278,    20.523611,    11.237222,    15.429444),  \
]],                                                          \
'Lmi' : [ _("Leo Minor"), [                                  \
  (   10.888611,    34.215000,    10.464722,    36.707222),  \
  (   10.464722,    36.707222,    10.123889,    35.244722),  \
]],                                                          \
'Lep' : [ _("Lepus"), [                                      \
  (    5.940000,   -14.167778,     5.782500,   -14.821944),  \
  (    5.782500,   -14.821944,     5.545556,   -17.822222),  \
  (    5.545556,   -17.822222,     5.215556,   -16.205556),  \
  (    5.545556,   -17.822222,     5.855278,   -20.879167),  \
  (    5.855278,   -20.879167,     5.741111,   -22.448333),  \
  (    5.741111,   -22.448333,     5.470833,   -20.759444),  \
  (    5.470833,   -20.759444,     5.091111,   -22.371111),  \
  (    5.470833,   -20.759444,     5.545556,   -17.822222),  \
]],                                                          \
'Lib' : [ _("Libra"), [                                      \
  (   15.644167,   -29.777778,    15.617222,   -28.135000),  \
  (   15.617222,   -28.135000,    15.067778,   -25.281944),  \
  (   15.067778,   -25.281944,    14.848056,   -16.041667),  \
  (   14.848056,   -16.041667,    15.283333,    -9.383056),  \
  (   15.283333,    -9.383056,    15.592222,   -14.789444),  \
  (   15.592222,   -14.789444,    15.067778,   -25.281944),  \
]],                                                          \
'Lup' : [ _("Lupus"), [                                      \
  (   14.698889,   -47.388333,    15.204722,   -52.099167),  \
  (   15.204722,   -52.099167,    15.308889,   -47.875000),  \
  (   15.308889,   -47.875000,    15.378056,   -44.689444),  \
  (   15.378056,   -44.689444,    15.585833,   -41.166944),  \
  (   15.585833,   -41.166944,    15.634167,   -42.567500),  \
  (   15.634167,   -42.567500,    15.686389,   -44.661111),  \
  (   15.686389,   -44.661111,    16.110000,   -36.802222),  \
  (   16.110000,   -36.802222,    15.849444,   -33.627222),  \
  (   15.849444,   -33.627222,    15.363333,   -36.261389),  \
  (   15.363333,   -36.261389,    15.356111,   -40.647500),  \
  (   15.356111,   -40.647500,    14.975556,   -43.133889),  \
  (   14.975556,   -43.133889,    14.698889,   -47.388333),  \
]],                                                          \
'Lyn' : [ _("Lynx"), [                                       \
  (    6.326944,    59.010833,     6.954722,    58.422500),  \
  (    6.954722,    58.422500,     7.445278,    49.211389),  \
  (    7.445278,    49.211389,     8.140833,    51.506667),  \
  (    8.140833,    51.506667,     8.380556,    43.188056),  \
  (    8.380556,    43.188056,     9.108889,    38.452222),  \
  (    9.108889,    38.452222,     9.314167,    36.802500),  \
  (    9.314167,    36.802500,     9.350833,    34.392500),  \
]],                                                          \
'Lyr' : [ _("Lyra"), [                                       \
  (   18.738889,    39.670000,    18.615556,    38.783611),  \
  (   18.615556,    38.783611,    18.746111,    37.605000),  \
  (   18.746111,    37.605000,    18.908333,    36.898889),  \
  (   18.908333,    36.898889,    18.982500,    32.689444),  \
  (   18.982500,    32.689444,    18.834722,    33.362778),  \
  (   18.834722,    33.362778,    18.746111,    37.605000),  \
]],                                                          \
'Men' : [ _("Mensa"), [                                      \
  (    5.045278,   -71.314444,     4.919722,   -74.936944),  \
  (    4.919722,   -74.936944,     5.531389,   -76.341111),  \
  (    5.531389,   -76.341111,     6.170556,   -74.753056),  \
]],                                                          \
'Mic' : [ _("Microscopium"), [                               \
  (   21.346111,   -40.809444,    21.298889,   -32.172500),  \
  (   21.298889,   -32.172500,    21.021389,   -32.257778),  \
  (   21.021389,   -32.257778,    20.832778,   -33.779722),  \
]],                                                          \
'Mon' : [ _("Monoceros"), [                                  \
  (    6.247500,    -6.274722,     6.480278,    -7.033056),  \
  (    6.480278,    -7.033056,     7.197778,    -0.492778),  \
  (    7.197778,    -0.492778,     7.687500,    -9.551111),  \
  (    7.687500,    -9.551111,     8.143333,    -2.983889),  \
]],                                                          \
'Mus' : [ _("Musca"), [                                      \
  (   11.760000,   -66.728889,    12.619722,   -69.135556),  \
  (   12.619722,   -69.135556,    12.771389,   -68.108056),  \
  (   12.771389,   -68.108056,    13.037778,   -71.548889),  \
  (   13.037778,   -71.548889,    12.541111,   -72.133056),  \
  (   12.541111,   -72.133056,    12.619722,   -69.135556),  \
]],                                                          \
'Nor' : [ _("Norma"), [                                      \
  (   16.053611,   -49.229722,    16.108056,   -45.173333),  \
  (   16.108056,   -45.173333,    16.453056,   -47.554722),  \
  (   16.453056,   -47.554722,    16.330556,   -50.155556),  \
  (   16.330556,   -50.155556,    16.053611,   -49.229722),  \
]],                                                          \
'Oct' : [ _("Octans"), [                                     \
  (   14.448611,   -83.667778,    21.691389,   -77.390000),  \
  (   21.691389,   -77.390000,    22.767778,   -81.381667),  \
  (   22.767778,   -81.381667,    14.448611,   -83.667778),  \
]],                                                          \
'Oph' : [ _("Ophiuchus"), [                                  \
  (   16.239167,    -3.694444,    16.305278,    -4.692500),  \
  (   16.305278,    -4.692500,    16.619444,   -10.567222),  \
  (   16.619444,   -10.567222,    17.173056,   -15.724722),  \
  (   17.173056,   -15.724722,    17.798333,     2.707222),  \
  (   17.798333,     2.707222,    17.724444,     4.567222),  \
  (   17.724444,     4.567222,    17.582222,    12.560000),  \
  (   17.582222,    12.560000,    16.961111,     9.375000),  \
  (   16.961111,     9.375000,    16.515278,     1.983889),  \
  (   16.515278,     1.983889,    16.239167,    -3.694444),  \
  (   17.798333,     2.707222,    18.010833,     2.931667),  \
  (   18.010833,     2.931667,    18.090833,     2.499444),  \
]],                                                          \
'Ori' : [ _("Orion"), [                                      \
  (    6.065278,    20.138333,     6.198889,    14.208889),  \
  (    6.198889,    14.208889,     6.039722,     9.647500),  \
  (    6.039722,     9.647500,     6.126111,    14.768333),  \
  (    6.126111,    14.768333,     5.906389,    20.276111),  \
  (    6.039722,     9.647500,     5.919444,     7.406944),  \
  (    5.919444,     7.406944,     5.580278,     9.489444),  \
  (    5.580278,     9.489444,     5.418889,     6.349722),  \
  (    5.418889,     6.349722,     4.975833,     1.714167),  \
  (    4.975833,     1.714167,     4.904167,     2.440556),  \
  (    4.904167,     2.440556,     4.853333,     5.605000),  \
  (    4.853333,     5.605000,     4.830556,     6.961389),  \
  (    4.830556,     6.961389,     4.843611,     8.900278),  \
  (    4.843611,     8.900278,     4.875556,    14.250556),  \
  (    5.919444,     7.406944,     5.679444,    -1.942778),  \
  (    5.679444,    -1.942778,     5.795833,    -9.669722),  \
  (    5.795833,    -9.669722,     5.242222,    -8.201667),  \
  (    5.242222,    -8.201667,     5.533333,    -0.299167),  \
  (    5.533333,    -0.299167,     5.418889,     6.349722),  \
]],                                                          \
'Pav' : [ _("Pavo"), [                                       \
  (   21.440833,   -65.366111,    20.749444,   -66.203056),  \
  (   20.749444,   -66.203056,    20.427500,   -56.735000),  \
  (   20.749444,   -66.203056,    20.145556,   -66.181944),  \
  (   20.145556,   -66.181944,    17.762222,   -64.723889),  \
  (   17.762222,   -64.723889,    18.717222,   -71.428056),  \
  (   18.717222,   -71.428056,    20.010000,   -72.910556),  \
  (   20.010000,   -72.910556,    20.749444,   -66.203056),  \
]],                                                          \
'Peg' : [ _("Pegasus"), [                                    \
  (    0.139722,    29.090556,     0.220556,    15.183611),  \
  (    0.220556,    15.183611,    23.079444,    15.205278),  \
  (   23.079444,    15.205278,    23.063056,    28.082778),  \
  (   23.063056,    28.082778,     0.139722,    29.090556),  \
  (   23.079444,    15.205278,    22.778333,    12.172778),  \
  (   22.778333,    12.172778,    22.691111,    10.831389),  \
  (   22.691111,    10.831389,    22.170000,     6.197778),  \
  (   22.170000,     6.197778,    21.736389,     9.875000),  \
  (   22.166389,    33.178333,    22.716667,    30.221389),  \
  (   22.716667,    30.221389,    23.063056,    28.082778),  \
  (   23.063056,    28.082778,    22.833333,    24.601667),  \
  (   22.833333,    24.601667,    22.775556,    23.565556),  \
  (   22.775556,    23.565556,    22.116944,    25.345000),  \
  (   22.116944,    25.345000,    21.744167,    25.645000),  \
]],                                                          \
'Per' : [ _("Perseus"), [                                    \
  (    3.738611,    32.288333,     3.902222,    31.883611),  \
  (    3.902222,    31.883611,     3.982778,    35.791111),  \
  (    3.982778,    35.791111,     3.964167,    40.010278),  \
  (    3.964167,    40.010278,     3.753333,    42.578611),  \
  (    3.753333,    42.578611,     3.715556,    47.787500),  \
  (    3.715556,    47.787500,     4.144444,    47.712500),  \
  (    4.144444,    47.712500,     4.248333,    48.409444),  \
  (    4.248333,    48.409444,     4.109722,    50.351389),  \
  (    3.715556,    47.787500,     3.405278,    49.861111),  \
  (    3.405278,    49.861111,     3.080000,    53.506389),  \
  (    3.080000,    53.506389,     2.845000,    55.895556),  \
  (    2.845000,    55.895556,     2.904444,    52.762500),  \
  (    2.904444,    52.762500,     3.151111,    49.613333),  \
  (    3.151111,    49.613333,     3.158333,    44.857222),  \
  (    3.158333,    44.857222,     3.136111,    40.955556),  \
  (    3.136111,    40.955556,     3.086389,    38.840278),  \
]],                                                          \
'Phe' : [ _("Phoenix"), [                                    \
  (    1.472778,   -43.318333,     1.520833,   -49.072778),  \
  (    1.520833,   -49.072778,     1.101389,   -46.718611),  \
  (    1.101389,   -46.718611,     1.472778,   -43.318333),  \
  (    1.101389,   -46.718611,     1.139722,   -55.245833),  \
  (    1.101389,   -46.718611,     0.438056,   -42.306111),  \
  (    0.438056,   -42.306111,     0.156944,   -45.747500),  \
]],                                                          \
'Pic' : [ _("Pictor"), [                                     \
  (    5.788056,   -51.066389,     5.830556,   -56.166667),  \
  (    5.830556,   -56.166667,     6.803056,   -61.941389),  \
]],                                                          \
'Psc' : [ _("Pisces"), [                                     \
  (    1.194444,    30.089722,     1.324444,    27.264167),  \
  (    1.324444,    27.264167,     1.229167,    24.583611),  \
  (    1.229167,    24.583611,     1.524722,    15.345833),  \
  (    1.524722,    15.345833,     1.756667,     9.157778),  \
  (    1.756667,     9.157778,     2.034167,     2.763611),  \
  (    2.034167,     2.763611,     1.690556,     5.487500),  \
  (    1.690556,     5.487500,     1.503056,     6.143889),  \
  (    1.503056,     6.143889,     1.049167,     7.890000),  \
  (    1.049167,     7.890000,    23.988611,     6.863333),  \
  (   23.988611,     6.863333,    23.665833,     5.626389),  \
  (   23.665833,     5.626389,    23.700833,     1.780000),  \
  (   23.700833,     1.780000,    23.448889,     1.255556),  \
  (   23.448889,     1.255556,    23.286111,     3.282222),  \
  (   23.286111,     3.282222,    23.064722,     3.820000),  \
  (   23.665833,     5.626389,    23.466111,     6.378889),  \
  (   23.466111,     6.378889,    23.286111,     3.282222),  \
]],                                                          \
'Psa' : [ _("Piscis Australis"), [                           \
  (   22.677500,   -27.043611,    22.960833,   -29.622222),  \
  (   22.960833,   -29.622222,    22.932500,   -32.539722),  \
  (   22.932500,   -32.539722,    22.875556,   -32.875556),  \
  (   22.875556,   -32.875556,    22.525000,   -32.346111),  \
  (   22.525000,   -32.346111,    22.139722,   -32.988611),  \
  (   22.139722,   -32.988611,    21.749167,   -33.025833),  \
]],                                                          \
'Pup' : [ _("Puppis"), [                                     \
  (    8.125833,   -24.304167,     7.821667,   -24.859722),  \
  (    7.821667,   -24.859722,     7.725556,   -28.411111),  \
  (    7.725556,   -28.411111,     8.059722,   -40.003333),  \
  (    8.059722,   -40.003333,     7.285833,   -37.097500),  \
  (    7.285833,   -37.097500,     7.487222,   -43.301389),  \
  (    8.059722,   -40.003333,     7.487222,   -43.301389),  \
  (    7.487222,   -43.301389,     7.225556,   -44.639722),  \
  (    7.225556,   -44.639722,     6.629444,   -43.196111),  \
  (    6.629444,   -43.196111,     6.832222,   -50.614722),  \
  (    6.832222,   -50.614722,     7.225556,   -44.639722),  \
]],                                                          \
'Pyx' : [ _("Pyxis"), [                                      \
  (    8.842222,   -27.710000,     8.726667,   -33.186389),  \
  (    8.726667,   -33.186389,     8.668333,   -35.308333),  \
]],                                                          \
'Ret' : [ _("Reticulum"), [                                  \
  (    3.736667,   -64.806944,     4.240556,   -62.473889),  \
  (    4.240556,   -62.473889,     4.274722,   -59.302222),  \
  (    4.274722,   -59.302222,     3.979167,   -61.400278),  \
  (    3.979167,   -61.400278,     4.015000,   -62.159444),  \
  (    4.015000,   -62.159444,     3.736667,   -64.806944),  \
]],                                                          \
'Sge' : [ _("Sagitta"), [                                    \
  (   19.979167,    19.492222,    19.789722,    18.534167),  \
  (   19.789722,    18.534167,    19.668333,    18.013889),  \
  (   19.789722,    18.534167,    19.684167,    17.476111),  \
]],                                                          \
'Sgr' : [ _("Sagittarius"), [                                \
  (   19.377222,   -44.458889,    19.398056,   -40.616111),  \
  (   19.398056,   -40.616111,    19.043611,   -29.880278),  \
  (   19.043611,   -29.880278,    19.115556,   -27.670556),  \
  (   19.115556,   -27.670556,    18.921111,   -26.296667),  \
  (   18.921111,   -26.296667,    18.760833,   -26.990833),  \
  (   18.760833,   -26.990833,    19.043611,   -29.880278),  \
  (   18.921111,   -26.296667,    19.078056,   -21.741667),  \
  (   19.078056,   -21.741667,    18.962222,   -21.106667),  \
  (   19.078056,   -21.741667,    19.162778,   -21.023611),  \
  (   19.162778,   -21.023611,    19.361111,   -17.847222),  \
  (   19.043611,   -29.880278,    18.402778,   -34.384722),  \
  (   18.402778,   -34.384722,    18.350000,   -29.828056),  \
  (   18.350000,   -29.828056,    18.466111,   -25.421667),  \
  (   18.466111,   -25.421667,    18.760833,   -26.990833),  \
  (   18.402778,   -34.384722,    18.096944,   -30.424167),  \
  (   18.096944,   -30.424167,    18.350000,   -29.828056),  \
]],                                                          \
'Scl' : [ _("Sculptor"), [                                   \
  (    0.976667,   -29.357500,    23.815556,   -28.130278),  \
  (   23.815556,   -28.130278,    23.313611,   -32.531944),  \
  (   23.313611,   -32.531944,    23.549444,   -37.818333),  \
]],                                                          \
'Sco' : [ _("Scorpius"), [                                   \
  (   17.512778,   -37.295833,    17.560278,   -37.103889),  \
  (   17.560278,   -37.103889,    17.708056,   -39.030000),  \
  (   17.708056,   -39.030000,    17.793056,   -40.126944),  \
  (   17.793056,   -40.126944,    17.621944,   -42.997778),  \
  (   17.621944,   -42.997778,    17.202500,   -43.239167),  \
  (   17.202500,   -43.239167,    16.909722,   -42.361389),  \
  (   16.909722,   -42.361389,    16.872222,   -38.017500),  \
  (   16.872222,   -38.017500,    16.836111,   -34.293333),  \
  (   16.836111,   -34.293333,    16.598056,   -28.216111),  \
  (   16.598056,   -28.216111,    16.490000,   -26.431944),  \
  (   16.490000,   -26.431944,    16.353056,   -25.592778),  \
  (   16.353056,   -25.592778,    16.005556,   -22.621667),  \
  (   16.005556,   -22.621667,    15.980833,   -26.114167),  \
  (   16.005556,   -22.621667,    16.090556,   -19.805556),  \
]],                                                          \
'Sct' : [ _("Scutum"), [                                     \
  (   18.786389,    -4.747778,    18.586667,    -8.244167),  \
  (   18.586667,    -8.244167,    18.486667,   -14.565833),  \
]],                                                          \
'Ser' : [ _("Serpens"), [                                    \
  (   15.854444,    20.977778,    15.812222,    18.141667),  \
  (   15.812222,    18.141667,    15.940833,    15.661667),  \
  (   15.812222,    18.141667,    15.692500,    19.670278),  \
  (   15.812222,    18.141667,    15.769722,    15.421944),  \
  (   15.769722,    15.421944,    15.580000,    10.539167),  \
  (   15.580000,    10.539167,    15.737778,     6.425556),  \
  (   15.737778,     6.425556,    15.846944,     4.477778),  \
  (   15.846944,     4.477778,    15.838333,     2.196389),  \
  (   15.838333,     2.196389,    15.826944,    -3.430278),  \
  (   15.826944,    -3.430278,    16.239167,    -3.694444),  \
  (   17.173056,   -15.724722,    17.347222,   -12.846944),  \
  (   17.347222,   -12.846944,    17.626389,   -15.398611),  \
  (   17.626389,   -15.398611,    17.690278,   -12.875278),  \
  (   17.690278,   -12.875278,    17.983889,    -9.773611),  \
  (   17.983889,    -9.773611,    18.355278,    -2.898889),  \
  (   18.355278,    -2.898889,    18.936944,     4.203611),  \
]],                                                          \
'Sex' : [ _("Sextans"), [                                    \
  (    9.875000,    -8.105000,    10.491389,    -2.739167),  \
  (   10.491389,    -2.739167,    10.505000,    -0.636944),  \
  (   10.505000,    -0.636944,    10.132222,    -0.371667),  \
  (   10.132222,    -0.371667,     9.875000,    -8.105000),  \
]],                                                          \
'Tau' : [ _("Taurus"), [                                     \
  (    5.438333,    28.607500,     4.704167,    22.956944),  \
  (    4.704167,    22.956944,     4.476944,    19.180278),  \
  (    4.476944,    19.180278,     4.424722,    17.928056),  \
  (    4.424722,    17.928056,     4.382222,    17.542500),  \
  (    4.382222,    17.542500,     4.330000,    15.627500),  \
  (    4.330000,    15.627500,     4.477778,    15.870833),  \
  (    4.477778,    15.870833,     4.598611,    16.509167),  \
  (    4.598611,    16.509167,     5.627500,    21.142500),  \
  (    4.330000,    15.627500,     4.011389,    12.490278),  \
  (    4.011389,    12.490278,     3.452778,     9.732778),  \
  (    3.452778,     9.732778,     3.413611,     9.028889),  \
]],                                                          \
'Tel' : [ _("Telescopium"), [                                \
  (   18.480556,   -49.070833,    18.449444,   -45.968333),  \
  (   18.449444,   -45.968333,    18.187222,   -45.954444),  \
]],                                                          \
'Tri' : [ _("Triangulum"), [                                 \
  (    1.884722,    29.578889,     2.288611,    33.847222),  \
  (    2.288611,    33.847222,     2.159167,    34.987222),  \
  (    2.159167,    34.987222,     1.884722,    29.578889),  \
]],                                                          \
'Tra' : [ _("Triangulum Australis"), [                       \
  (   15.919167,   -63.430556,    15.315278,   -68.679444),  \
  (   15.315278,   -68.679444,    16.811111,   -69.027778),  \
  (   16.811111,   -69.027778,    15.919167,   -63.430556),  \
]],                                                          \
'Tuc' : [ _("Tucana"), [                                     \
  (    0.525833,   -62.958056,    23.290556,   -58.235833),  \
  (   23.290556,   -58.235833,    22.308333,   -60.259722),  \
  (   22.308333,   -60.259722,    22.455556,   -64.966389),  \
  (   22.455556,   -64.966389,     0.334444,   -64.874722),  \
  (    0.334444,   -64.874722,     0.525833,   -62.958056),  \
]],                                                          \
'Uma' : [ _("Ursa Major"), [                                 \
  (   13.792222,    49.313333,    13.398889,    54.925278),  \
  (   13.398889,    54.925278,    12.257222,    57.032500),  \
  (   12.257222,    57.032500,    11.897222,    53.694722),  \
  (   11.897222,    53.694722,    11.767500,    47.779444),  \
  (   11.767500,    47.779444,    11.308056,    33.094167),  \
  (   11.308056,    33.094167,    11.303056,    31.529167),  \
  (   11.767500,    47.779444,    11.161111,    44.498611),  \
  (   11.161111,    44.498611,    10.372222,    41.499444),  \
  (   12.257222,    57.032500,    11.062222,    61.750833),  \
  (   11.062222,    61.750833,     9.525556,    63.061944),  \
  (    9.525556,    63.061944,     8.504444,    60.718056),  \
  (    9.525556,    63.061944,     9.849722,    59.038611),  \
  (    9.849722,    59.038611,     9.868333,    54.064444),  \
  (    9.868333,    54.064444,     9.547500,    51.677222),  \
  (    9.547500,    51.677222,     8.986667,    48.041667),  \
  (   11.062222,    61.750833,    11.030833,    56.382500),  \
  (   11.030833,    56.382500,    11.897222,    53.694722),  \
]],                                                          \
'Umi' : [ _("Ursa Minor"), [                                 \
  (    2.530278,    89.264167,    17.536944,    86.586389),  \
  (   17.536944,    86.586389,    16.766111,    82.037222),  \
  (   16.766111,    82.037222,    15.734444,    77.794444),  \
  (   15.734444,    77.794444,    16.291667,    75.755278),  \
  (   16.291667,    75.755278,    15.345556,    71.834167),  \
  (   15.345556,    71.834167,    14.845000,    74.155556),  \
  (   14.845000,    74.155556,    15.734444,    77.794444),  \
]],                                                          \
'Vel' : [ _("Vela"), [                                       \
  (   10.779444,   -49.420000,     9.947778,   -54.567778),  \
  (    9.947778,   -54.567778,     9.368611,   -55.010833),  \
  (    9.368611,   -55.010833,     8.745000,   -54.708333),  \
  (    8.745000,   -54.708333,     8.158889,   -47.336667),  \
  (    8.158889,   -47.336667,     9.133333,   -43.432500),  \
  (    9.133333,   -43.432500,     9.511667,   -40.466667),  \
  (    9.133333,   -43.432500,     9.368611,   -55.010833),  \
]],                                                          \
'Vir' : [ _("Virgo"), [                                      \
  (   13.578333,    -0.595833,    14.027500,     1.544444),  \
  (   14.027500,     1.544444,    14.770833,     1.892778),  \
  (   14.770833,     1.892778,    14.717778,    -5.658333),  \
  (   14.717778,    -5.658333,    14.266944,    -6.000556),  \
  (   14.266944,    -6.000556,    13.420000,   -11.161389),  \
  (   13.420000,   -11.161389,    12.694444,    -1.449444),  \
  (   12.694444,    -1.449444,    12.331667,    -0.666944),  \
  (   12.331667,    -0.666944,    11.845000,     1.764722),  \
  (   12.694444,    -1.449444,    12.926667,     3.397500),  \
  (   12.926667,     3.397500,    13.036389,    10.959167),  \
]],                                                          \
'Vol' : [ _("Volans"), [                                     \
  (    9.040833,   -66.396111,     8.428889,   -66.136944),  \
  (    8.428889,   -66.136944,     8.132222,   -68.617222),  \
  (    8.132222,   -68.617222,     7.696944,   -72.606111),  \
  (    7.696944,   -72.606111,     7.145833,   -70.498889),  \
  (    7.145833,   -70.498889,     7.280556,   -67.957222),  \
  (    7.280556,   -67.957222,     8.428889,   -66.136944),  \
]],                                                          \
'Vul' : [ _("Vulpecula"), [                                  \
  (   19.891111,    24.079722,    19.478333,    24.665000),  \
  (   19.478333,    24.665000,    19.270278,    21.390278),  \
]] }
