#!/bin/sh
# test we are root
if [ "$USER" != "root" ] ; then
   echo "Run as root please, exiting." 
   exit 1                                                      
fi

export CFLAGS='-flto=auto -Os -pipe -march=armv6zk -mtune=arm1176jzf-s -mfpu=vfp  '
export CXXFLAGS='-flto=auto -Os -pipe -fno-exceptions -fno-rtti -march=armv6zk -mtune=arm1176jzf-s -mfpu=vfp '
export PKG_CONFIG_PATH=/usr/local/lib/pkgconfig:/usr/lib/pkgconfig
echo $CFLAGS && echo $CXXFLAGS

P=atk
V=2.36.0
SRC=$P-$V
USER=`cat /etc/sysconfig/tcuser`
LIST="compiletc squashfs-tools wget meson gobject-introspection-dev gettext"
for Z in $LIST 
    do 
    su -c "tce-load -i $Z" $USER
done

# list may be larger than loaded
cd /usr/local/lib
rm -rf *.la
rm -rf gcc/aarch64-unknown-linux-gnu/12.2.0/plugin/*.la
rm -rf gcc/aarch64-unknown-linux-gnu/12.2.0/*.la
rm -rf gprofng/*.la 
rm -rf python3.8/site-packages/*.la
rm -rf pkcs11/*.la
rm -rf cairo/*.la
rm -rf gtk-2.0/modules/*.la
rm -rf gtk-2.0/2.10.0/printbackends/*.la
rm -rf gtk-2.0/2.10.0/immodules/*.la
rm -rf gtk-2.0/2.10.0/engines/*.la
rm -rf imlib2/loaders/*.la
rm -rf imlib2/filters/*.la
rm -rf gdk-pixbuf-2.0/2.10.0/loaders/*.la
rm -rf gcc/armv7l-unknown-linux-gnueabihf/12.2.0/plugin/libcp1plugin.la
rm -rf gcc/armv7l-unknown-linux-gnueabihf/12.2.0/plugin/libcc1plugin.la
rm -rf gcc/armv7l-unknown-linux-gnueabihf/12.2.0/liblto_plugin.la
rm -rf pulseaudio/libpulsedsp.la
rm -rf pulseaudio/libpulsecore-13.0.la
rm -rf pulseaudio/libpulsecommon-13.0.la
rm -rf libv4l/v4l2convert.la
rm -rf libv4l/v4l1compat.la
rm -rf libv4l/plugins/libv4l-mplane.la
rm -rf vala-0.46/libvalaccodegen.la
cd /tmp
rm -rf /usr/lib/*.la
find / -name *.la

su -c "/usr/local/bin/wget -nc \
https://download.gnome.org/sources/$P/2.36/$SRC.tar.xz " $USER
tar -xvf $SRC*xz
cd $SRC
mkdir build && cd build
meson setup --prefix=/usr/local --localstatedir=/var -Dstrip=true -Ddocs=false  
# localstatedir: /var
# prefix       : /usr/local
# strip        : true
# docs         : false
ninja # 25 sec
DESTDIR=/tmp/$P ninja install
cd /tmp

# dev
#####
mkdir -p $P-dev/usr/local/lib
mv $P/usr/local/include $P-dev/usr/local/
mv $P/usr/local/lib/pkgconfig $P-dev/usr/local/lib

# gir
#####
mkdir -p $P-gir/usr/local/lib
mv $P/usr/local/lib/gir* $P-gir/usr/local/lib
mkdir -p $P-gir/usr/local/share
mv $P/usr/local/share/gir* $P-gir/usr/local/share

# locale
########
mkdir -p $P-locale/usr/local/share
mv $P/usr/local/share/locale $P-locale/usr/local/share

# main 
#####
mkdir -p $P/usr/local/share/doc/$P
echo 'LGPL v2' > $P/usr/local/share/doc/$P/COPYING

# TCZ them
#######
LIST="$P $P-dev $P-gir $P-locale "
for Z in $LIST
do
	mksquashfs $Z $Z.tcz
	md5sum $Z.tcz > $Z.tcz.md5.txt
	cd $Z
	find usr -not -type d > /tmp/$Z.tcz.list
        sed 's|usr|/usr|g' -i /tmp/$Z.tcz.list
	cd /tmp
done

ls -hal

echo 'Title:          atk-dev.tcz
Description:    dev files
Version:        2.36.0
Author:         Alejandro Piñeiro Iglesias
Original-site:  https://download.gnome.org/sources/atk
Copying-policy: LGPL v2
Size:           72K
Extension_by:   aus9
Tags:           accessibility
Comments:       dev files
                
Change-log:     2016/08/13 v 2.20.0 (bmarkus)
                2020/04/16 v 2.34.1 (juanito)
Current:        2023/07/11 v 2.36.0 on 14.x (aus9) '  > $P-dev.tcz.info
echo 'atk.tcz
gobject-introspection-dev.tcz
gettext.tcz                    ' > $P-dev.tcz.dep

echo 'Title:          atk-gir.tcz
Description:    Gir files
Version:        2.36.0
Author:         Alejandro Piñeiro Iglesias
Original-site:  https://download.gnome.org/sources/atk
Copying-policy: LGPL v2
Size:           236K
Extension_by:   aus9
Tags:           accessibility
Comments:       gir files
                
Change-log:     2016/08/13 v 2.20.0 (bmarkus)
                2020/04/16 v 2.34.1 (juanito)
Current:        2023/07/11 v 2.36.0 on 14.x (aus9)  '  > $P-gir.tcz.info
echo 'atk.tcz' > $P-gir.tcz.dep 

echo 'Title:          atk-locale.tcz
Description:    language files
Version:        2.36.0
Author:         Alejandro Piñeiro Iglesias
Original-site:  https://download.gnome.org/sources/atk
Copying-policy: LGPL v2
Size:           388K
Extension_by:   aus9
Tags:           accessibility
Comments:       untested by me
                
Change-log:     2023/07/11 v 2.36.0 on 14.x 
Current:        2023/07/11  '  > $P-locale.tcz.info
echo 'atk.tcz' > $P-locale.tcz.dep 

echo 'Title:          atk.tcz
Description:    Set of accessibility interfaces
Version:        2.36.0
Author:         Alejandro Piñeiro Iglesias
Original-site:  https://download.gnome.org/sources/atk
Copying-policy: LGPL v2
Size:           52K
Extension_by:   aus9
Tags:           accessibility
Comments:       Libs only
                
Change-log:     2016/08/13 v 2.20.0 (bmarkus)
                2020/04/16 v 2.34.1 (juanito)
Current:        2023/07/11 v 2.36.0 on 14.x (aus9) '  > $P.tcz.info

readelf -d $P/usr/local/lib/* | grep 'NEEDED' # none
#[libglib-2.0.so.0][libgobject-2.0.so.0][libglib-2.0.so.0]glib2
echo 'glib2.tcz' > $P.tcz.dep

