/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.sync;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.UnparseableDescriptor;
import org.torproject.descriptor.index.DescriptorIndexCollector;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.sync.ProcessCriterium;
import org.torproject.metrics.collector.sync.SyncPersistence;

public class SyncManager {
    private static final Logger log = LoggerFactory.getLogger(SyncManager.class);
    public static final String SYNCORIGINS = "SyncOrigins";
    private Date collectionDate;

    public void merge(Configuration conf, String marker, Map<String, Class<? extends Descriptor>> mapPathDesc) throws ConfigurationException {
        URL[] sources = conf.getUrlArray(Key.valueOf(marker + SYNCORIGINS));
        this.collectionDate = new Date();
        this.collectFromOtherInstances(sources, mapPathDesc.keySet(), marker, conf);
        this.mergeWithLocalStorage(sources, mapPathDesc, marker, conf);
    }

    private void collectFromOtherInstances(URL[] sources, Set<String> dirs, String marker, Configuration conf) throws ConfigurationException {
        Path basePath = conf.getPath(Key.SyncPath);
        DescriptorIndexCollector descriptorCollector = new DescriptorIndexCollector();
        for (URL source : sources) {
            try {
                File storage = new File(basePath.toFile(), marker + "-" + source.getHost());
                storage.mkdirs();
                log.info("Collecting {} from {} ...", (Object)marker, (Object)source.getHost());
                descriptorCollector.collectDescriptors(source.toString(), dirs.toArray(new String[dirs.size()]), 0L, storage, true);
                log.info("Done collecting {} from {}.", (Object)marker, (Object)source.getHost());
            }
            catch (Throwable th) {
                log.warn("Cannot download {} from {}.", dirs, source, th);
            }
        }
    }

    private void mergeWithLocalStorage(URL[] sources, Map<String, Class<? extends Descriptor>> mapPathDesc, String marker, Configuration conf) throws ConfigurationException {
        Path basePath = conf.getPath(Key.SyncPath);
        SyncPersistence persist = new SyncPersistence(conf);
        ProcessCriterium unparseable = new ProcessCriterium(UnparseableDescriptor.class);
        for (URL source : sources) {
            File base = new File(basePath.toFile(), marker + "-" + source.getHost());
            log.info("Merging {} from {} into storage ...", (Object)marker, (Object)source.getHost());
            for (Map.Entry<String, Class<? extends Descriptor>> entry : mapPathDesc.entrySet()) {
                File descFile = new File(base, entry.getKey());
                DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
                String histFileEnding = entry.getValue().getSimpleName() + (entry.getKey().contains("consensus-microdesc") ? "-micro" : "");
                File historyFile = new File(basePath.toFile(), "sync-history-" + source.getHost() + "-" + marker + "-" + histFileEnding);
                descriptorReader.setHistoryFile(historyFile);
                log.info("Reading {} of type {} ... ", (Object)marker, (Object)histFileEnding);
                Iterator<Descriptor> descriptors = descriptorReader.readDescriptors(descFile).iterator();
                log.info("Done reading {} of type {}.", (Object)marker, (Object)histFileEnding);
                ProcessCriterium crit = new ProcessCriterium(entry.getValue());
                while (descriptors.hasNext()) {
                    Descriptor desc = descriptors.next();
                    if (unparseable.applies(desc)) {
                        DescriptorParseException ex = ((UnparseableDescriptor)desc).getDescriptorParseException();
                        log.warn("Parsing of {} caused Exception(s). Processing anyway.", (Object)desc.getDescriptorFile(), (Object)ex);
                    }
                    if (!crit.applies(desc)) {
                        log.warn("Not processing {} in {}.", (Object)desc.getClass().getName(), (Object)desc.getDescriptorFile());
                        continue;
                    }
                    persist.storeDesc(desc, this.collectionDate.getTime());
                }
                persist.cleanDirectory();
                descriptorReader.saveHistoryFile(historyFile);
            }
            log.info("Done merging {} from {}.", (Object)marker, (Object)source.getHost());
        }
    }
}

