/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.snowflake;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Stack;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorParser;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.SnowflakeStats;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.ConfigurationException;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.cron.CollecTorMain;
import org.torproject.metrics.collector.persist.SnowflakeStatsPersistence;

public class SnowflakeStatsDownloader
extends CollecTorMain {
    private static final Logger logger = LoggerFactory.getLogger(SnowflakeStatsDownloader.class);
    private String recentPathName;

    public SnowflakeStatsDownloader(Configuration config) {
        super(config);
        this.mapPathDescriptors.put("recent/snowflakes", SnowflakeStats.class);
    }

    @Override
    public String module() {
        return "SnowflakeStats";
    }

    @Override
    protected String syncMarker() {
        return "SnowflakeStats";
    }

    @Override
    protected void startProcessing() throws ConfigurationException {
        this.recentPathName = this.config.getPath(Key.RecentPath).toString();
        logger.debug("Downloading snowflake stats...");
        URL url = this.config.getUrl(Key.SnowflakeStatsUrl);
        ByteArrayOutputStream downloadedSnowflakeStats = this.downloadFromHttpServer(url);
        if (null == downloadedSnowflakeStats) {
            return;
        }
        logger.debug("Finished downloading {}.", (Object)url);
        DescriptorParser descriptorParser = DescriptorSourceFactory.createDescriptorParser();
        TreeSet<LocalDateTime> snowflakeStatsEnds = new TreeSet<LocalDateTime>();
        String outputPathName = this.config.getPath(Key.OutputPath).toString();
        for (Descriptor descriptor : descriptorParser.parseDescriptors(downloadedSnowflakeStats.toByteArray(), null, null)) {
            File[] outputFiles;
            if (!(descriptor instanceof SnowflakeStats)) continue;
            SnowflakeStats snowflakeStats = (SnowflakeStats)descriptor;
            LocalDateTime snowflakeStatsEnd = snowflakeStats.snowflakeStatsEnd();
            snowflakeStatsEnds.add(snowflakeStatsEnd);
            SnowflakeStatsPersistence persistence = new SnowflakeStatsPersistence(snowflakeStats);
            File tarballFile = new File(outputPathName + "/" + persistence.getStoragePath());
            if (tarballFile.exists()) continue;
            File rsyncFile = new File(this.recentPathName + "/" + persistence.getRecentPath());
            for (File outputFile : outputFiles = new File[]{tarballFile, rsyncFile}) {
                this.writeToFile(outputFile, Annotation.SnowflakeStats.bytes(), snowflakeStats.getRawDescriptorBytes());
            }
        }
        if (snowflakeStatsEnds.isEmpty()) {
            logger.warn("Could not parse downloaded snowflake stats.");
            return;
        }
        if (((LocalDateTime)snowflakeStatsEnds.last()).isBefore(LocalDateTime.now().minusHours(48L))) {
            logger.warn("The latest snowflake stats are older than 48 hours: {}.", snowflakeStatsEnds.last());
        }
        this.cleanUpRsyncDirectory();
    }

    private ByteArrayOutputStream downloadFromHttpServer(URL url) {
        ByteArrayOutputStream downloadedBytes = new ByteArrayOutputStream();
        try {
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestMethod("GET");
            huc.setReadTimeout(5000);
            huc.connect();
            int response = huc.getResponseCode();
            if (response != 200) {
                logger.warn("Could not download {}. Response code {}", (Object)url, (Object)response);
                return null;
            }
            try (BufferedInputStream in = new BufferedInputStream(huc.getInputStream());){
                int len;
                byte[] data = new byte[1024];
                while ((len = in.read(data, 0, 1024)) >= 0) {
                    downloadedBytes.write(data, 0, len);
                }
            }
        }
        catch (IOException e) {
            logger.warn("Failed downloading {}.", (Object)url, (Object)e);
            return null;
        }
        return downloadedBytes;
    }

    private void writeToFile(File outputFile, byte[] ... bytes) {
        try {
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                logger.warn("Could not create parent directories of {}.", (Object)outputFile);
                return;
            }
            FileOutputStream os = new FileOutputStream(outputFile);
            for (byte[] b : bytes) {
                ((OutputStream)os).write(b);
            }
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            logger.warn("Could not write downloaded snowflake stats to {}", (Object)outputFile.getAbsolutePath(), (Object)e);
        }
    }

    public void cleanUpRsyncDirectory() {
        long cutOffMillis = System.currentTimeMillis() - 259200000L;
        Stack<File> allFiles = new Stack<File>();
        allFiles.add(new File(this.recentPathName));
        while (!allFiles.isEmpty()) {
            File file = (File)allFiles.pop();
            if (file.isDirectory()) {
                allFiles.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (file.lastModified() >= cutOffMillis) continue;
            file.delete();
        }
    }
}

