/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPSymbol;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RFileInputStream;
import org.rosuda.REngine.Rserve.RFileOutputStream;
import org.rosuda.REngine.Rserve.RSession;
import org.rosuda.REngine.Rserve.RserveException;
import org.rosuda.REngine.Rserve.protocol.REXPFactory;
import org.rosuda.REngine.Rserve.protocol.RPacket;
import org.rosuda.REngine.Rserve.protocol.RTalk;
import org.rosuda.REngine.Rserve.protocol.jcrypt;

public class RConnection
extends REngine {
    String lastError = null;
    Socket s;
    boolean connected = false;
    InputStream is;
    OutputStream os;
    boolean authReq = false;
    int authType = 0;
    String Key = null;
    RTalk rt = null;
    String host;
    int port;
    public static String transferCharset = "UTF-8";
    public static final int AT_plain = 0;
    public static final int AT_crypt = 1;
    protected int rsrvVersion;

    public RConnection() throws RserveException {
        this("127.0.0.1", 6311);
    }

    public RConnection(String host) throws RserveException {
        this(host, 6311);
    }

    public RConnection(String host, int port) throws RserveException {
        this(host, port, null);
    }

    RConnection(RSession session) throws RserveException {
        this(null, 0, session);
    }

    RConnection(String host, int port, RSession session) throws RserveException {
        try {
            if (this.connected) {
                this.s.close();
            }
            this.s = null;
        }
        catch (Exception e) {
            throw new RserveException(this, "Cannot close previous connection: " + e.getMessage(), e);
        }
        if (session != null) {
            host = session.host;
            port = session.port;
        }
        this.connected = false;
        this.host = host;
        this.port = port;
        try {
            Socket ss = new Socket(host, port);
            ss.setTcpNoDelay(true);
            this.initWithSocket(ss, session);
        }
        catch (Exception sce) {
            throw new RserveException(this, "Cannot connect: " + sce.getMessage(), sce);
        }
    }

    public RConnection(Socket sock) throws RserveException {
        this.host = null;
        this.port = 0;
        try {
            if (this.connected) {
                this.s.close();
            }
            this.connected = false;
            this.s = null;
        }
        catch (Exception e) {
            throw new RserveException(this, "Cannot close previous connection: " + e.getMessage(), e);
        }
        this.initWithSocket(sock, null);
    }

    private void initWithSocket(Socket sock, RSession session) throws RserveException {
        this.s = sock;
        try {
            this.is = this.s.getInputStream();
            this.os = this.s.getOutputStream();
        }
        catch (Exception gse) {
            throw new RserveException(this, "Cannot get io stream: " + gse.getMessage(), gse);
        }
        this.rt = new RTalk(this.is, this.os);
        if (session == null) {
            byte[] IDs = new byte[32];
            int n = -1;
            try {
                n = this.is.read(IDs);
            }
            catch (Exception sre) {
                throw new RserveException(this, "Error while receiving data: " + sre.getMessage(), sre);
            }
            try {
                if (n != 32) {
                    throw new RserveException(this, "Handshake failed: expected 32 bytes header, got " + n);
                }
                String ids = new String(IDs);
                if (ids.substring(0, 4).compareTo("Rsrv") != 0) {
                    throw new RserveException(this, "Handshake failed: Rsrv signature expected, but received \"" + ids + "\" instead.");
                }
                try {
                    this.rsrvVersion = Integer.parseInt(ids.substring(4, 8));
                }
                catch (Exception px) {
                    // empty catch block
                }
                if (this.rsrvVersion > 103) {
                    throw new RserveException(this, "Handshake failed: The server uses more recent protocol than this client.");
                }
                if (ids.substring(8, 12).compareTo("QAP1") != 0) {
                    throw new RserveException(this, "Handshake failed: unupported transfer protocol (" + ids.substring(8, 12) + "), I talk only QAP1.");
                }
                for (int i = 12; i < 32; i += 4) {
                    String attr = ids.substring(i, i + 4);
                    if (attr.compareTo("ARpt") == 0 && !this.authReq) {
                        this.authReq = true;
                        this.authType = 0;
                    }
                    if (attr.compareTo("ARuc") == 0) {
                        this.authReq = true;
                        this.authType = 1;
                    }
                    if (attr.charAt(0) != 'K') continue;
                    this.Key = attr.substring(1, 3);
                }
            }
            catch (RserveException innerX) {
                try {
                    this.s.close();
                }
                catch (Exception ex01) {
                    // empty catch block
                }
                this.is = null;
                this.os = null;
                this.s = null;
                throw innerX;
            }
        }
        try {
            this.os.write(session.key, 0, 32);
        }
        catch (Exception sre) {
            throw new RserveException(this, "Error while sending session key: " + sre.getMessage(), sre);
        }
        this.rsrvVersion = session.rsrvVersion;
        this.connected = true;
        this.lastError = "OK";
    }

    public void finalize() {
        this.close();
        this.is = null;
        this.os = null;
    }

    public int getServerVersion() {
        return this.rsrvVersion;
    }

    public boolean close() {
        try {
            if (this.s != null) {
                this.s.close();
            }
            this.connected = false;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void voidEval(String cmd) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(2, cmd + "\n");
        if (rp != null && rp.isOk()) {
            return;
        }
        throw new RserveException(this, "voidEval failed", rp);
    }

    public RSession voidEvalDetach(String cmd) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(49, cmd + "\n");
        if (rp == null || !rp.isOk()) {
            throw new RserveException(this, "detached void eval failed", rp);
        }
        RSession s = new RSession(this, rp);
        this.close();
        return s;
    }

    REXP parseEvalResponse(RPacket rp) throws RserveException {
        int rxo = 0;
        byte[] pc = rp.getCont();
        if (this.rsrvVersion > 100) {
            rxo = 4;
            if (pc[0] != 10 && pc[0] != 74) {
                throw new RserveException(this, "Error while processing eval output: SEXP (type 10) expected but found result type " + pc[0] + ".");
            }
            if (pc[0] == 74) {
                rxo = 8;
            }
        }
        if (pc.length > rxo) {
            try {
                REXPFactory rx = new REXPFactory();
                rx.parseREXP(pc, rxo);
                return rx.getREXP();
            }
            catch (REXPMismatchException me) {
                me.printStackTrace();
                throw new RserveException(this, "Error when parsing response: " + me.getMessage(), me);
            }
        }
        return null;
    }

    public REXP eval(String cmd) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(3, cmd + "\n");
        if (rp != null && rp.isOk()) {
            return this.parseEvalResponse(rp);
        }
        throw new RserveException(this, "eval failed", rp);
    }

    public void assign(String sym, String ct) throws RserveException {
        int ic;
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        byte[] symn = sym.getBytes();
        byte[] ctn = ct.getBytes();
        int sl = symn.length + 1;
        int cl = ctn.length + 1;
        if ((sl & 3) > 0) {
            sl = (sl & 0xFFFFFC) + 4;
        }
        if ((cl & 3) > 0) {
            cl = (cl & 0xFFFFFC) + 4;
        }
        byte[] rq = new byte[sl + 4 + cl + 4];
        for (ic = 0; ic < symn.length; ++ic) {
            rq[ic + 4] = symn[ic];
        }
        while (ic < sl) {
            rq[ic + 4] = 0;
            ++ic;
        }
        for (ic = 0; ic < ctn.length; ++ic) {
            rq[ic + sl + 8] = ctn[ic];
        }
        while (ic < cl) {
            rq[ic + sl + 8] = 0;
            ++ic;
        }
        RTalk.setHdr(4, sl, rq, 0);
        RTalk.setHdr(4, cl, rq, sl + 4);
        RPacket rp = this.rt.request(32, rq);
        if (rp != null && rp.isOk()) {
            return;
        }
        throw new RserveException(this, "assign failed", rp);
    }

    public void assign(String sym, REXP rexp) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        try {
            int ic;
            REXPFactory r = new REXPFactory(rexp);
            int rl = r.getBinaryLength();
            byte[] symn = sym.getBytes();
            int sl = symn.length + 1;
            if ((sl & 3) > 0) {
                sl = (sl & 0xFFFFFC) + 4;
            }
            byte[] rq = new byte[sl + rl + (rl > 0xFFFFF0 ? 12 : 8)];
            for (ic = 0; ic < symn.length; ++ic) {
                rq[ic + 4] = symn[ic];
            }
            while (ic < sl) {
                rq[ic + 4] = 0;
                ++ic;
            }
            RTalk.setHdr(4, sl, rq, 0);
            RTalk.setHdr(10, rl, rq, sl + 4);
            r.getBinaryRepresentation(rq, sl + (rl > 0xFFFFF0 ? 12 : 8));
            RPacket rp = this.rt.request(32, rq);
            if (rp != null && rp.isOk()) {
                return;
            }
            throw new RserveException(this, "assign failed", rp);
        }
        catch (REXPMismatchException me) {
            throw new RserveException(this, "Error creating binary representation: " + me.getMessage(), me);
        }
    }

    public RFileInputStream openFile(String fn) throws IOException {
        return new RFileInputStream(this.rt, fn);
    }

    public RFileOutputStream createFile(String fn) throws IOException {
        return new RFileOutputStream(this.rt, fn);
    }

    public void removeFile(String fn) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(21, fn);
        if (rp != null && rp.isOk()) {
            return;
        }
        throw new RserveException(this, "removeFile failed", rp);
    }

    public void shutdown() throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(4);
        if (rp != null && rp.isOk()) {
            return;
        }
        throw new RserveException(this, "shutdown failed", rp);
    }

    public void setSendBufferSize(long sbs) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(129, (int)sbs);
        if (rp != null && rp.isOk()) {
            return;
        }
        throw new RserveException(this, "setSendBufferSize failed", rp);
    }

    public void setStringEncoding(String enc) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(130, enc);
        if (rp != null && rp.isOk()) {
            return;
        }
        throw new RserveException(this, "setStringEncoding failed", rp);
    }

    public void login(String user, String pwd) throws RserveException {
        if (!this.authReq) {
            return;
        }
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        if (this.authType == 1) {
            RPacket rp;
            if (this.Key == null) {
                this.Key = "rs";
            }
            if ((rp = this.rt.request(1, user + "\n" + jcrypt.crypt(this.Key, pwd))) != null && rp.isOk()) {
                return;
            }
            try {
                this.s.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.is = null;
            this.os = null;
            this.s = null;
            this.connected = false;
            throw new RserveException(this, "login failed", rp);
        }
        RPacket rp = this.rt.request(1, user + "\n" + pwd);
        if (rp != null && rp.isOk()) {
            return;
        }
        try {
            this.s.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.is = null;
        this.os = null;
        this.s = null;
        this.connected = false;
        throw new RserveException(this, "login failed", rp);
    }

    public RSession detach() throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(48);
        if (rp == null || !rp.isOk()) {
            throw new RserveException(this, "Cannot detach", rp);
        }
        RSession s = new RSession(this, rp);
        this.close();
        return s;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean needLogin() {
        return this.authReq;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void serverEval(String cmd) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(66, cmd + "\n");
        if (rp != null && rp.isOk()) {
            return;
        }
        throw new RserveException(this, "serverEval failed", rp);
    }

    public void serverSource(String serverFile) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(69, serverFile);
        if (rp != null && rp.isOk()) {
            return;
        }
        throw new RserveException(this, "serverSource failed", rp);
    }

    public void serverShutdown() throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rp = this.rt.request(68);
        if (rp != null && rp.isOk()) {
            return;
        }
        throw new RserveException(this, "serverShutdown failed", rp);
    }

    public REXP parse(String text, boolean resolve) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support separate parsing step.");
    }

    public REXP eval(REXP what, REXP where, boolean resolve) throws REngineException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        if (where != null) {
            throw new REngineException((REngine)this, "Rserve doesn't support environments other than .GlobalEnv");
        }
        try {
            REXPFactory r = new REXPFactory(what);
            int rl = r.getBinaryLength();
            byte[] rq = new byte[rl + (rl > 0xFFFFF0 ? 8 : 4)];
            RTalk.setHdr(10, rl, rq, 0);
            r.getBinaryRepresentation(rq, rl > 0xFFFFF0 ? 8 : 4);
            RPacket rp = this.rt.request(resolve ? 3 : 2, rq);
            if (rp != null && rp.isOk()) {
                return this.parseEvalResponse(rp);
            }
            throw new RserveException(this, "eval failed", rp);
        }
        catch (REXPMismatchException me) {
            throw new RserveException(this, "Error creating binary representation: " + me.getMessage(), me);
        }
    }

    public REXP parseAndEval(String text, REXP where, boolean resolve) throws REngineException {
        if (where != null) {
            throw new REngineException((REngine)this, "Rserve doesn't support environments other than .GlobalEnv");
        }
        try {
            return this.eval(text);
        }
        catch (RserveException re) {
            throw new REngineException((REngine)this, re.getMessage(), (Throwable)((Object)re));
        }
    }

    public void assign(String symbol, REXP value, REXP env) throws REngineException {
        if (env != null) {
            throw new REngineException((REngine)this, "Rserve doesn't support environments other than .GlobalEnv");
        }
        try {
            this.assign(symbol, value);
        }
        catch (RserveException re) {
            throw new REngineException((REngine)this, re.getMessage(), (Throwable)((Object)re));
        }
    }

    public REXP get(String symbol, REXP env, boolean resolve) throws REngineException {
        if (!resolve) {
            throw new REngineException((REngine)this, "Rserve doesn't support references");
        }
        try {
            return this.eval((REXP)new REXPSymbol(symbol), env, true);
        }
        catch (RserveException re) {
            throw new REngineException((REngine)this, re.getMessage());
        }
    }

    public REXP resolveReference(REXP ref) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support references");
    }

    public REXP createReference(REXP ref) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support references");
    }

    public void finalizeReference(REXP ref) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support references");
    }

    public REXP getParentEnvironment(REXP env, boolean resolve) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support environments other than .GlobalEnv");
    }

    public REXP newEnvironment(REXP parent, boolean resolve) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support environments other than .GlobalEnv");
    }
}

