/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;

public final class AstTreeStringPrinter {
    private static final Pattern NEWLINE = Pattern.compile("\n");
    private static final Pattern RETURN = Pattern.compile("\r");
    private static final Pattern TAB = Pattern.compile("\t");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private AstTreeStringPrinter() {
    }

    public static String printFileAst(File file, boolean withComments) throws IOException, CheckstyleException {
        return AstTreeStringPrinter.printTree(AstTreeStringPrinter.parseFile(file, withComments));
    }

    private static String printTree(DetailAST ast) {
        StringBuilder messageBuilder = new StringBuilder();
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            messageBuilder.append(AstTreeStringPrinter.getIndentation(node)).append(TokenUtils.getTokenName(node.getType())).append(" -> ").append(AstTreeStringPrinter.excapeAllControlChars(node.getText())).append(" [").append(node.getLineNo()).append(':').append(node.getColumnNo()).append(']').append(LINE_SEPARATOR).append(AstTreeStringPrinter.printTree(node.getFirstChild()));
        }
        return messageBuilder.toString();
    }

    private static String getIndentation(DetailAST ast) {
        boolean isLastChild = ast.getNextSibling() == null;
        DetailAST node = ast;
        StringBuilder indentation = new StringBuilder();
        while (node.getParent() != null) {
            if ((node = node.getParent()).getParent() == null) {
                if (isLastChild) {
                    indentation.append("`--");
                    continue;
                }
                indentation.append("|--");
                continue;
            }
            if (node.getNextSibling() == null) {
                indentation.insert(0, "    ");
                continue;
            }
            indentation.insert(0, "|   ");
        }
        return indentation.toString();
    }

    private static String excapeAllControlChars(String text) {
        String textWithoutNewlines = NEWLINE.matcher(text).replaceAll("\\\\n");
        String textWithoutReturns = RETURN.matcher(textWithoutNewlines).replaceAll("\\\\r");
        return TAB.matcher(textWithoutReturns).replaceAll("\\\\t");
    }

    private static DetailAST parseFile(File file, boolean withComments) throws IOException, CheckstyleException {
        DetailAST result;
        FileText text = new FileText(file.getAbsoluteFile(), System.getProperty("file.encoding", "UTF-8"));
        FileContents contents = new FileContents(text);
        try {
            result = withComments ? TreeWalker.parseWithComments(contents) : TreeWalker.parse(contents);
        }
        catch (RecognitionException | TokenStreamException ex) {
            String exceptionMsg = String.format(Locale.ROOT, "%s occurred during the analysis of file %s.", ex.getClass().getSimpleName(), file.getPath());
            throw new CheckstyleException(exceptionMsg, ex);
        }
        return result;
    }
}

