/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;

public class IllegalTokenCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.token";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{22};
    }

    @Override
    public int[] getAcceptableTokens() {
        return TokenUtils.getAllTokenIds();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, IllegalTokenCheck.convertToString(ast));
    }

    private static String convertToString(DetailAST ast) {
        String tokenText = ast.getType() == 22 ? ast.getFirstChild().getText() + ast.getText() : ast.getText();
        return tokenText;
    }
}

