/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.Guard;
import java.util.Deque;
import java.util.List;

class PkgControl {
    private final Deque<Guard> guards = Lists.newLinkedList();
    private final List<PkgControl> children = Lists.newArrayList();
    private final PkgControl parent;
    private final String fullPackage;

    PkgControl(String pkgName) {
        this.parent = null;
        this.fullPackage = pkgName;
    }

    PkgControl(PkgControl parent, String subPkg) {
        this.parent = parent;
        this.fullPackage = parent.fullPackage + "." + subPkg;
        parent.children.add(this);
    }

    protected void addGuard(Guard thug) {
        this.guards.addFirst(thug);
    }

    public PkgControl locateFinest(String forPkg) {
        PkgControl finestMatch = null;
        if (forPkg.startsWith(this.fullPackage)) {
            finestMatch = this;
            for (PkgControl child : this.children) {
                PkgControl match = child.locateFinest(forPkg);
                if (match == null) continue;
                finestMatch = match;
                break;
            }
        }
        return finestMatch;
    }

    public AccessResult checkAccess(String forImport, String inPkg) {
        AccessResult returnValue = this.localCheckAccess(forImport, inPkg);
        AccessResult result = returnValue != AccessResult.UNKNOWN ? returnValue : (this.parent == null ? AccessResult.DISALLOWED : this.parent.checkAccess(forImport, inPkg));
        return result;
    }

    private AccessResult localCheckAccess(String forImport, String inPkg) {
        for (Guard g : this.guards) {
            AccessResult result;
            if (g.isLocalOnly() && !this.fullPackage.equals(inPkg) || (result = g.verifyImport(forImport)) == AccessResult.UNKNOWN) continue;
            return result;
        }
        return AccessResult.UNKNOWN;
    }
}

