/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.google.common.base.Optional;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;

public class ParameterNameCheck
extends AbstractNameCheck {
    private boolean ignoreOverridden;

    public ParameterNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    public void setIgnoreOverridden(boolean ignoreOverridden) {
        this.ignoreOverridden = ignoreOverridden;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{21};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    protected boolean mustCheckName(DetailAST ast) {
        boolean checkName = true;
        if (this.ignoreOverridden && ParameterNameCheck.isOverriddenMethod(ast) || ast.getParent().getType() == 96) {
            checkName = false;
        }
        return checkName;
    }

    private static boolean isOverriddenMethod(DetailAST ast) {
        Optional<DetailAST> overrideToken;
        boolean overridden = false;
        DetailAST parent = ast.getParent().getParent();
        Optional<DetailAST> annotation = Optional.fromNullable(parent.getFirstChild().getFirstChild());
        if (annotation.isPresent() && annotation.get().getType() == 159 && (overrideToken = Optional.fromNullable(annotation.get().findFirstToken(58))).isPresent() && "Override".equals(overrideToken.get().getText())) {
            overridden = true;
        }
        return overridden;
    }
}

