/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.index;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.common.EncoderUtil;
import org.tukaani.xz.index.IndexBase;
import org.tukaani.xz.index.IndexRecord;

public class IndexEncoder
extends IndexBase {
    private final ArrayList records = new ArrayList();

    public IndexEncoder() {
        super(new XZIOException("XZ Stream or its Index has grown too big"));
    }

    public void add(long unpaddedSize, long uncompressedSize) throws XZIOException {
        super.add(unpaddedSize, uncompressedSize);
        this.records.add(new IndexRecord(unpaddedSize, uncompressedSize));
    }

    public void encode(OutputStream out) throws IOException {
        CRC32 crc32 = new CRC32();
        CheckedOutputStream outChecked = new CheckedOutputStream(out, crc32);
        outChecked.write(0);
        EncoderUtil.encodeVLI(outChecked, this.recordCount);
        Iterator i = this.records.iterator();
        while (i.hasNext()) {
            IndexRecord record = (IndexRecord)i.next();
            EncoderUtil.encodeVLI(outChecked, record.unpadded);
            EncoderUtil.encodeVLI(outChecked, record.uncompressed);
        }
        for (int i2 = this.getIndexPaddingSize(); i2 > 0; --i2) {
            outChecked.write(0);
        }
        long value = crc32.getValue();
        for (int i3 = 0; i3 < 4; ++i3) {
            out.write((byte)(value >>> i3 * 8));
        }
    }
}

