/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.persist;

import java.nio.file.Paths;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.persist.DescriptorPersistence;
import org.torproject.collector.persist.PersistenceUtils;
import org.torproject.descriptor.BridgeNetworkStatus;

public class StatusPersistence
extends DescriptorPersistence<BridgeNetworkStatus> {
    private static final String STATUSES = "statuses";

    public StatusPersistence(BridgeNetworkStatus desc, String authId, long received) {
        super(desc, Annotation.Status.bytes());
        this.calculatePaths(authId, received);
    }

    private void calculatePaths(String authId, long received) {
        String[] partsOut = PersistenceUtils.dateTimeParts(((BridgeNetworkStatus)this.desc).getPublishedMillis());
        String fileOut = partsOut[0] + partsOut[1] + partsOut[2] + "-" + partsOut[3] + partsOut[4] + partsOut[5] + "-" + authId;
        this.recentPath = Paths.get("bridge-descriptors", STATUSES, fileOut).toString();
        this.storagePath = Paths.get("bridge-descriptors", partsOut[0], partsOut[1], STATUSES, partsOut[2], fileOut).toString();
    }
}

