/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.TimeZone;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.NetworkStatusImpl;
import org.torproject.descriptor.impl.ParseHelper;

public class BridgeNetworkStatusImpl
extends NetworkStatusImpl
implements BridgeNetworkStatus {
    private long publishedMillis;
    private long stableUptime;
    private long stableMtbf;
    private long fastBandwidth;
    private double guardWfu;
    private long guardTk;
    private long guardBandwidthIncludingExits;
    private long guardBandwidthExcludingExits;
    private int enoughMtbfInfo;
    private int ignoringAdvertisedBws;

    protected BridgeNetworkStatusImpl(byte[] rawDescriptorBytes, int[] offsetAndLength, File descriptorFile, String fileName) throws DescriptorParseException {
        super(rawDescriptorBytes, offsetAndLength, descriptorFile, false, false);
        this.setPublishedMillisFromFileName(fileName);
    }

    private void setPublishedMillisFromFileName(String fileName) throws DescriptorParseException {
        if (this.publishedMillis != 0L) {
            return;
        }
        if (fileName.length() == "20000101-000000-4A0CCD2DDC7995083D73F5D667100C8A5831F16D".length()) {
            String publishedString = fileName.substring(0, "yyyyMMdd-HHmmss".length());
            try {
                SimpleDateFormat fileNameFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
                fileNameFormat.setLenient(false);
                fileNameFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                this.publishedMillis = fileNameFormat.parse(publishedString).getTime();
            }
            catch (ParseException e) {
                throw new DescriptorParseException("Cannot parse published time for status file name '" + fileName + "'.", e);
            }
        }
        if (this.publishedMillis == 0L) {
            throw new DescriptorParseException("Unrecognized bridge network status file name '" + fileName + "'.");
        }
    }

    @Override
    protected void parseHeader(int offset, int length) throws DescriptorParseException {
        this.stableUptime = -1L;
        this.stableMtbf = -1L;
        this.fastBandwidth = -1L;
        this.guardWfu = -1.0;
        this.guardTk = -1L;
        this.guardBandwidthIncludingExits = -1L;
        this.guardBandwidthExcludingExits = -1L;
        this.enoughMtbfInfo = -1;
        this.ignoringAdvertisedBws = -1;
        Scanner scanner = this.newScanner(offset, length).useDelimiter("\n");
        block4: while (scanner.hasNext()) {
            String line = scanner.next();
            String[] parts = line.split("[ \t]+");
            Key key = Key.get(parts[0]);
            switch (key) {
                case PUBLISHED: {
                    this.parsePublishedLine(line, parts);
                    continue block4;
                }
                case FLAG_THRESHOLDS: {
                    this.parseFlagThresholdsLine(line, parts);
                    continue block4;
                }
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parsePublishedLine(String line, String[] parts) throws DescriptorParseException {
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseFlagThresholdsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("No flag thresholds in line '" + line + "'.");
        }
        SortedMap<String, String> flagThresholds = ParseHelper.parseKeyValueStringPairs(line, parts, 1);
        try {
            for (Map.Entry<String, String> e : flagThresholds.entrySet()) {
                switch (e.getKey()) {
                    case "stable-uptime": {
                        this.stableUptime = Long.parseLong(e.getValue());
                        break;
                    }
                    case "stable-mtbf": {
                        this.stableMtbf = Long.parseLong(e.getValue());
                        break;
                    }
                    case "fast-speed": {
                        this.fastBandwidth = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-wfu": {
                        this.guardWfu = Double.parseDouble(e.getValue().replaceAll("%", ""));
                        break;
                    }
                    case "guard-tk": {
                        this.guardTk = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-bw-inc-exits": {
                        this.guardBandwidthIncludingExits = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-bw-exc-exits": {
                        this.guardBandwidthExcludingExits = Long.parseLong(e.getValue());
                        break;
                    }
                    case "enough-mtbf": {
                        this.enoughMtbfInfo = Integer.parseInt(e.getValue());
                        break;
                    }
                    case "ignoring-advertised-bws": {
                        this.ignoringAdvertisedBws = Integer.parseInt(e.getValue());
                        break;
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new DescriptorParseException("Illegal value in line '" + line + "'.", ex);
        }
    }

    @Override
    protected void parseDirSource(int offset, int length) throws DescriptorParseException {
        throw new DescriptorParseException("No directory source expected in bridge network status.");
    }

    @Override
    protected void parseFooter(int offset, int length) throws DescriptorParseException {
        throw new DescriptorParseException("No directory footer expected in bridge network status.");
    }

    @Override
    protected void parseDirectorySignature(int offset, int length) throws DescriptorParseException {
        throw new DescriptorParseException("No directory signature expected in bridge network status.");
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public long getStableUptime() {
        return this.stableUptime;
    }

    @Override
    public long getStableMtbf() {
        return this.stableMtbf;
    }

    @Override
    public long getFastBandwidth() {
        return this.fastBandwidth;
    }

    @Override
    public double getGuardWfu() {
        return this.guardWfu;
    }

    @Override
    public long getGuardTk() {
        return this.guardTk;
    }

    @Override
    public long getGuardBandwidthIncludingExits() {
        return this.guardBandwidthIncludingExits;
    }

    @Override
    public long getGuardBandwidthExcludingExits() {
        return this.guardBandwidthExcludingExits;
    }

    @Override
    public int getEnoughMtbfInfo() {
        return this.enoughMtbfInfo;
    }

    @Override
    public int getIgnoringAdvertisedBws() {
        return this.ignoringAdvertisedBws;
    }
}

