/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.conf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.EnumSet;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.conf.ConfigurationException;
import org.torproject.collector.conf.Key;
import org.torproject.collector.conf.SourceType;

public class Configuration
extends Observable
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    public static final String FIELDSEP = ",";
    public static final String ARRAYSEP = ";";
    private final Properties props = new Properties();
    private Path configurationFile;
    private FileTime ft;

    public void setWatchableSourceAndLoad(final Path confPath) throws ConfigurationException {
        this.configurationFile = confPath;
        try {
            this.ft = Files.getLastModifiedTime(confPath, new LinkOption[0]);
            this.reload();
            this.anythingActivated();
        }
        catch (IOException e) {
            throw new ConfigurationException("Cannot watch configuration file. Reason: " + e.getMessage(), e);
        }
        if (this.getBool(Key.RunOnce)) {
            return;
        }
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                logger.trace("Check configuration file.");
                try {
                    FileTime ftNow = Files.getLastModifiedTime(confPath, new LinkOption[0]);
                    if (Configuration.this.ft.compareTo(ftNow) < 0) {
                        logger.info("Configuration file was changed.");
                        Configuration.this.reload();
                        Configuration.this.setChanged();
                        Configuration.this.notifyObservers(null);
                    }
                    Configuration.this.ft = ftNow;
                }
                catch (Throwable th) {
                    logger.error("Cannot reload configuration file.", th);
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private final void reload() throws IOException {
        this.props.clear();
        try (FileInputStream fis = new FileInputStream(this.configurationFile.toFile());){
            this.props.load(fis);
        }
    }

    private void anythingActivated() throws ConfigurationException {
        if (!(this.getBool(Key.RelaydescsActivated) || this.getBool(Key.BridgedescsActivated) || this.getBool(Key.ExitlistsActivated) || this.getBool(Key.UpdateindexActivated) || this.getBool(Key.OnionPerfActivated))) {
            throw new ConfigurationException("Nothing is activated!\nPlease edit collector.properties. Exiting.");
        }
    }

    public Properties getPropertiesCopy() {
        return (Properties)this.props.clone();
    }

    public void load(InputStream fis) throws IOException {
        this.props.load(fis);
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getProperty(String key, String def) {
        return this.props.getProperty(key, def);
    }

    public void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    public void clear() {
        this.props.clear();
    }

    public void putAll(Properties allProps) {
        this.props.putAll((Map<?, ?>)allProps);
    }

    public int size() {
        return this.props.size();
    }

    public String[][] getStringArrayArray(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, String[][].class);
            String[] interim = this.props.getProperty(key.name()).split(ARRAYSEP);
            String[][] res = new String[interim.length][];
            for (int i = 0; i < interim.length; ++i) {
                res[i] = interim[i].trim().split(FIELDSEP);
                for (int j = 0; j < res[i].length; ++j) {
                    res[i][j] = res[i][j].trim();
                }
            }
            return res;
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public String[] getStringArray(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, String[].class);
            String[] res = this.props.getProperty(key.name()).split(FIELDSEP);
            for (int i = 0; i < res.length; ++i) {
                res[i] = res[i].trim();
            }
            return res;
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    private void checkClass(Key key, Class clazz) {
        if (!key.keyClass().getSimpleName().equals(clazz.getSimpleName())) {
            throw new RuntimeException("Wrong type wanted! My class is " + key.keyClass().getSimpleName());
        }
    }

    public boolean getBool(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Boolean.class);
            return Boolean.parseBoolean(this.props.getProperty(key.name()));
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public int getInt(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Integer.class);
            String prop = this.props.getProperty(key.name());
            if ("inf".equals(prop)) {
                return Integer.MAX_VALUE;
            }
            return Integer.parseInt(prop);
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public long getLong(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Long.class);
            String prop = this.props.getProperty(key.name());
            return Long.parseLong(prop);
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public Path getPath(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, Path.class);
            return Paths.get(this.props.getProperty(key.name()), new String[0]);
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public Set<SourceType> getSourceTypeSet(Key key) throws ConfigurationException {
        EnumSet<SourceType> res = null;
        try {
            this.checkClass(key, SourceType[].class);
            String[] interim = this.props.getProperty(key.name()).split(FIELDSEP);
            for (int i = 0; i < interim.length; ++i) {
                SourceType st = SourceType.valueOf(interim[i].trim());
                if (null == res) {
                    res = EnumSet.of(st);
                    continue;
                }
                res.add(st);
            }
            return res;
        }
        catch (RuntimeException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }

    public URL getUrl(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, URL.class);
            return new URL(this.props.getProperty(key.name()));
        }
        catch (RuntimeException | MalformedURLException mue) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + mue.getMessage(), mue);
        }
    }

    public URL[] getUrlArray(Key key) throws ConfigurationException {
        try {
            this.checkClass(key, URL[].class);
            String[] interim = this.props.getProperty(key.name()).split(FIELDSEP);
            URL[] res = new URL[interim.length];
            for (int i = 0; i < interim.length; ++i) {
                res[i] = new URL(interim[i].trim());
            }
            return res;
        }
        catch (RuntimeException | MalformedURLException re) {
            throw new ConfigurationException("Corrupt property: " + (Object)((Object)key) + " reason: " + re.getMessage(), re);
        }
    }
}

