/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.persist;

import java.nio.file.Paths;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.persist.DescriptorPersistence;
import org.torproject.collector.persist.PersistenceUtils;
import org.torproject.descriptor.BridgeServerDescriptor;

public class BridgeServerDescriptorPersistence
extends DescriptorPersistence<BridgeServerDescriptor> {
    public BridgeServerDescriptorPersistence(BridgeServerDescriptor desc, long received) {
        super(desc, Annotation.BridgeServer.bytes());
        this.calculatePaths(received);
    }

    private void calculatePaths(long received) {
        String file = PersistenceUtils.dateTime(received);
        String[] parts = PersistenceUtils.dateTimeParts(((BridgeServerDescriptor)this.desc).getPublishedMillis());
        this.recentPath = Paths.get("bridge-descriptors", "server-descriptors", file + "-" + "server-descriptors").toString();
        String digest = ((BridgeServerDescriptor)this.desc).getDigestSha1Hex().toLowerCase();
        this.storagePath = Paths.get("bridge-descriptors", parts[0], parts[1], "server-descriptors", digest.substring(0, 1), digest.substring(1, 2), digest).toString();
    }
}

