/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.persist;

import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.torproject.collector.conf.Annotation;
import org.torproject.collector.persist.DescriptorPersistence;
import org.torproject.collector.persist.PersistenceUtils;
import org.torproject.descriptor.TorperfResult;

public class OnionPerfPersistence
extends DescriptorPersistence<TorperfResult> {
    private static final String ONIONPERF = "torperf";

    public OnionPerfPersistence(TorperfResult desc) {
        super(desc, Annotation.OnionPerf.bytes());
        this.calculatePaths();
    }

    private void calculatePaths() {
        String[] parts = PersistenceUtils.dateTimeParts(((TorperfResult)this.desc).getStartMillis());
        String name = ((TorperfResult)this.desc).getSource() + "-" + ((TorperfResult)this.desc).getFileSize() + "-" + parts[0] + "-" + parts[1] + "-" + parts[2] + ".tpf";
        this.recentPath = Paths.get(ONIONPERF, name).toString();
        this.storagePath = Paths.get(ONIONPERF, parts[0], parts[1], parts[2], name).toString();
    }

    @Override
    public boolean storeOut(String outRoot) {
        return super.storeOut(outRoot, StandardOpenOption.APPEND);
    }

    @Override
    public boolean storeAll(String recentRoot, String outRoot) {
        return super.storeAll(recentRoot, outRoot, StandardOpenOption.APPEND, StandardOpenOption.APPEND);
    }
}

