/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.collector.relaydescs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.collector.relaydescs.RelayDescriptorParser;

public class ArchiveReader {
    private static final Logger logger = LoggerFactory.getLogger(ArchiveReader.class);
    private Map<String, Set<String>> microdescriptorValidAfterTimes = new HashMap<String, Set<String>>();

    /*
     * WARNING - void declaration
     */
    public ArchiveReader(RelayDescriptorParser rdp, File archivesDirectory, File statsDirectory, boolean keepImportHistory) {
        if (rdp == null || archivesDirectory == null || statsDirectory == null) {
            throw new IllegalArgumentException();
        }
        rdp.setArchiveReader(this);
        int parsedFiles = 0;
        int ignoredFiles = 0;
        TreeSet<String> archivesImportHistory = new TreeSet<String>();
        File archivesImportHistoryFile = new File(statsDirectory, "archives-import-history");
        if (keepImportHistory && archivesImportHistoryFile.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(archivesImportHistoryFile));
                String line = null;
                while ((line = br.readLine()) != null) {
                    archivesImportHistory.add(line);
                }
                br.close();
            }
            catch (IOException e) {
                logger.warn("Could not read in archives import history file. Skipping.", e);
            }
        }
        if (archivesDirectory.exists()) {
            logger.debug("Importing files in directory " + archivesDirectory + "/...");
            Stack<File> filesInInputDir = new Stack<File>();
            filesInInputDir.add(archivesDirectory);
            ArrayList<Object> problems = new ArrayList<Object>();
            HashSet<Object> filesToRetry = new HashSet<Object>();
            while (!filesInInputDir.isEmpty()) {
                File pop = (File)filesInInputDir.pop();
                if (pop.isDirectory()) {
                    for (File f : pop.listFiles()) {
                        filesInInputDir.add(f);
                    }
                    continue;
                }
                if (rdp == null) continue;
                try {
                    void var13_20;
                    int n;
                    FileInputStream fis;
                    Object var13_17 = null;
                    if (keepImportHistory && archivesImportHistory.contains(pop.getName())) {
                        ++ignoredFiles;
                        continue;
                    }
                    if (pop.getName().endsWith(".tar.bz2")) {
                        logger.warn("Cannot parse compressed tarball " + pop.getAbsolutePath() + ". Skipping.");
                        continue;
                    }
                    if (pop.getName().endsWith(".bz2")) {
                        fis = new FileInputStream(pop);
                        BZip2CompressorInputStream bZip2CompressorInputStream = new BZip2CompressorInputStream(fis);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(bZip2CompressorInputStream);
                    } else {
                        fis = new FileInputStream(pop);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fis);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] data = new byte[1024];
                    while ((n = var13_20.read(data, 0, 1024)) >= 0) {
                        baos.write(data, 0, n);
                    }
                    var13_20.close();
                    byte[] allData = baos.toByteArray();
                    boolean stored = rdp.parse(allData);
                    if (!stored) {
                        filesToRetry.add(pop);
                        continue;
                    }
                    if (keepImportHistory) {
                        archivesImportHistory.add(pop.getName());
                    }
                    ++parsedFiles;
                }
                catch (IOException iOException) {
                    problems.add(pop);
                    if (problems.size() <= 3) continue;
                    break;
                }
            }
            for (File file : filesToRetry) {
                if (rdp == null) continue;
                try {
                    String line;
                    int len;
                    BufferedInputStream bis = null;
                    if (file.getName().endsWith(".bz2")) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BZip2CompressorInputStream bcis = new BZip2CompressorInputStream(fileInputStream);
                        bis = new BufferedInputStream(bcis);
                    } else {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        bis = new BufferedInputStream(fileInputStream);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] data = new byte[1024];
                    while ((len = bis.read(data, 0, 1024)) >= 0) {
                        byteArrayOutputStream.write(data, 0, len);
                    }
                    bis.close();
                    byte[] allData = byteArrayOutputStream.toByteArray();
                    BufferedReader br = new BufferedReader(new StringReader(new String(allData, "US-ASCII")));
                    while ((line = br.readLine()) != null && line.startsWith("@")) {
                    }
                    br.close();
                    if (line == null) {
                        logger.debug("We were given an empty descriptor for parsing. Ignoring.");
                        continue;
                    }
                    if (!line.equals("onion-key")) {
                        logger.debug("Skipping non-recognized descriptor.");
                        continue;
                    }
                    SimpleDateFormat parseFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    parseFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    String ascii = null;
                    try {
                        ascii = new String(allData, "US-ASCII");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    int start = -1;
                    int end = -1;
                    String startToken = "onion-key\n";
                    while (end < ascii.length() && (start = ascii.indexOf(startToken, end)) >= 0 && ((end = ascii.indexOf(startToken, start + 1)) >= 0 || (end = ascii.length()) > start)) {
                        byte[] descBytes = new byte[end - start];
                        System.arraycopy(allData, start, descBytes, 0, end - start);
                        String digest256Base64 = Base64.encodeBase64String(DigestUtils.sha256(descBytes)).replaceAll("=", "");
                        String digest256Hex = DigestUtils.sha256Hex(descBytes);
                        if (!this.microdescriptorValidAfterTimes.containsKey(digest256Hex)) {
                            logger.debug("Could not store microdescriptor '" + digest256Hex + "', which was not contained in a microdesc consensus.");
                            continue;
                        }
                        for (String validAfterTime : this.microdescriptorValidAfterTimes.get(digest256Hex)) {
                            try {
                                long validAfter = parseFormat.parse(validAfterTime).getTime();
                                rdp.storeMicrodescriptor(descBytes, digest256Hex, digest256Base64, validAfter);
                            }
                            catch (ParseException e) {
                                logger.warn("Could not parse valid-after time '" + validAfterTime + "'. Not storing microdescriptor.", e);
                            }
                        }
                    }
                    if (keepImportHistory) {
                        archivesImportHistory.add(file.getName());
                    }
                    ++parsedFiles;
                }
                catch (IOException e) {
                    problems.add(file);
                    if (problems.size() <= 3) continue;
                    break;
                }
            }
            if (problems.isEmpty()) {
                logger.debug("Finished importing files in directory " + archivesDirectory + "/.");
            } else {
                StringBuilder sb = new StringBuilder("Failed importing files in directory " + archivesDirectory + "/:");
                boolean bl = false;
                for (File file : problems) {
                    void var13_25;
                    sb.append("\n  " + file.getAbsolutePath());
                    if (++var13_25 < 3) continue;
                    sb.append("\n  ... more");
                    break;
                }
            }
        }
        if (keepImportHistory) {
            try {
                archivesImportHistoryFile.getParentFile().mkdirs();
                BufferedWriter bw = new BufferedWriter(new FileWriter(archivesImportHistoryFile));
                for (String line : archivesImportHistory) {
                    bw.write(line + "\n");
                }
                bw.close();
            }
            catch (IOException e) {
                logger.warn("Could not write archives import history file.");
            }
        }
        logger.info("Finished importing relay descriptors from local directory:\nParsed " + parsedFiles + ", ignored " + ignoredFiles + " files.");
    }

    public void haveParsedMicrodescConsensus(String validAfterTime, SortedSet<String> microdescriptorDigests) {
        for (String microdescriptor : microdescriptorDigests) {
            if (!this.microdescriptorValidAfterTimes.containsKey(microdescriptor)) {
                this.microdescriptorValidAfterTimes.put(microdescriptor, new HashSet());
            }
            this.microdescriptorValidAfterTimes.get(microdescriptor).add(validAfterTime);
        }
    }
}

