/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PackageNamesLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID = "-//Puppy Crawl//DTD Package Names 1.0//EN";
    private static final String DTD_RESOURCE_NAME = "com/puppycrawl/tools/checkstyle/packages_1_0.dtd";
    private static final String CHECKSTYLE_PACKAGES = "checkstyle_packages.xml";
    private static final String PACKAGE_ELEMENT_NAME = "package";
    private final Deque<String> packageStack = new ArrayDeque<String>();
    private final Set<String> packageNames = Sets.newLinkedHashSet();

    private PackageNamesLoader() throws ParserConfigurationException, SAXException {
        super(DTD_PUBLIC_ID, DTD_RESOURCE_NAME);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (PACKAGE_ELEMENT_NAME.equals(qName)) {
            String name = attributes.getValue("name");
            this.packageStack.push(name);
        }
    }

    private String getPackageName() {
        StringBuilder buf = new StringBuilder();
        Iterator<String> iterator = this.packageStack.descendingIterator();
        while (iterator.hasNext()) {
            String subPackage = iterator.next();
            buf.append(subPackage);
            if (CommonUtils.endsWithChar(subPackage, '.')) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (PACKAGE_ELEMENT_NAME.equals(qName)) {
            this.packageNames.add(this.getPackageName());
            this.packageStack.pop();
        }
    }

    public static Set<String> getPackageNames(ClassLoader classLoader) throws CheckstyleException {
        Set<String> result;
        try {
            PackageNamesLoader namesLoader = new PackageNamesLoader();
            Enumeration<URL> packageFiles = classLoader.getResources(CHECKSTYLE_PACKAGES);
            while (packageFiles.hasMoreElements()) {
                URL packageFile = packageFiles.nextElement();
                BufferedInputStream stream = null;
                try {
                    stream = new BufferedInputStream(packageFile.openStream());
                    InputSource source = new InputSource(stream);
                    namesLoader.parseInputSource(source);
                }
                catch (IOException ex) {
                    try {
                        throw new CheckstyleException("unable to open " + packageFile, ex);
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(stream);
                        throw throwable;
                    }
                }
                Closeables.closeQuietly(stream);
            }
            result = namesLoader.packageNames;
        }
        catch (IOException ex) {
            throw new CheckstyleException("unable to get package file resources", ex);
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new CheckstyleException("unable to open one of package files", ex);
        }
        return result;
    }
}

