/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import org.torproject.descriptor.BridgeExtraInfoDescriptor;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class BridgeExtraInfoPersistence
extends DescriptorPersistence<BridgeExtraInfoDescriptor> {
    public BridgeExtraInfoPersistence(BridgeExtraInfoDescriptor desc, long received) {
        super(desc, Annotation.BridgeExtraInfo.bytes());
        this.calculatePaths(received);
    }

    private void calculatePaths(long received) {
        String file = PersistenceUtils.dateTime(received);
        String[] parts = PersistenceUtils.dateTimeParts(((BridgeExtraInfoDescriptor)this.desc).getPublishedMillis());
        this.recentPath = Paths.get("bridge-descriptors", "extra-infos", file + "-" + "extra-infos").toString();
        String digest = ((BridgeExtraInfoDescriptor)this.desc).getDigestSha1Hex().toLowerCase();
        this.storagePath = Paths.get("bridge-descriptors", parts[0], parts[1], "extra-infos", digest.substring(0, 1), digest.substring(1, 2), digest).toString();
    }
}

