/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import org.torproject.descriptor.RelayExtraInfoDescriptor;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class ExtraInfoPersistence
extends DescriptorPersistence<RelayExtraInfoDescriptor> {
    public ExtraInfoPersistence(RelayExtraInfoDescriptor desc, long received) {
        super(desc, Annotation.ExtraInfo.bytes());
        this.calculatePaths(received);
    }

    private void calculatePaths(long received) {
        String file = PersistenceUtils.dateTime(received);
        String[] parts = PersistenceUtils.dateTimeParts(((RelayExtraInfoDescriptor)this.desc).getPublishedMillis());
        this.recentPath = Paths.get("relay-descriptors", "extra-infos", file + "-" + "extra-infos").toString();
        String digest = ((RelayExtraInfoDescriptor)this.desc).getDigestSha1Hex();
        this.storagePath = Paths.get("relay-descriptors", "extra-info", parts[0], parts[1], digest.substring(0, 1), digest.substring(1, 2), digest).toString();
    }
}

