/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class MicroConsensusPersistence
extends DescriptorPersistence<RelayNetworkStatusConsensus> {
    private static final String CONSENSUS_MICRODESC = "consensus-microdesc";
    private static final String MICRODESC = "microdesc";

    public MicroConsensusPersistence(RelayNetworkStatusConsensus desc, long received) {
        super(desc, Annotation.MicroConsensus.bytes());
        this.calculatePaths(received);
    }

    private void calculatePaths(long received) {
        String fileRecent = PersistenceUtils.dateTime(((RelayNetworkStatusConsensus)this.desc).getValidAfterMillis());
        String fileOut = PersistenceUtils.dateTime(((RelayNetworkStatusConsensus)this.desc).getValidAfterMillis());
        String[] parts = fileOut.split("-");
        this.recentPath = Paths.get("relay-descriptors", "microdescs", CONSENSUS_MICRODESC, fileRecent + "-" + CONSENSUS_MICRODESC).toString();
        this.storagePath = Paths.get("relay-descriptors", MICRODESC, parts[0], parts[1], CONSENSUS_MICRODESC, parts[2], fileOut + "-" + CONSENSUS_MICRODESC).toString();
    }
}

