/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.index;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNode
implements Comparable<FileNode> {
    private static Logger log = LoggerFactory.getLogger(FileNode.class);
    public final String path;
    public final long size;
    public final String lastModified;
    @JsonIgnore
    private long lastModifiedMillis;

    private FileNode() {
        this.path = null;
        this.size = 0L;
        this.lastModified = null;
    }

    public FileNode(String path, long size, String lastModified) {
        this.path = path;
        this.size = size;
        this.lastModified = lastModified;
    }

    @Override
    public int compareTo(FileNode other) {
        return this.path.compareTo(other.path);
    }

    public long lastModifiedMillis() {
        if (this.lastModifiedMillis == 0L) {
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.US);
            dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                this.lastModifiedMillis = dateTimeFormat.parse(this.lastModified).getTime();
            }
            catch (ParseException ex) {
                log.warn("Cannot parse last-modified time {} of remote file entry {}.  Fetching remote file regardless of configured last-modified time.  The following error message provides more details.", this.lastModified, this.path, ex);
                this.lastModifiedMillis = -1L;
            }
        }
        return this.lastModifiedMillis;
    }

    public String toString() {
        return "Fn: " + this.path;
    }
}

