/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.persist;

import java.nio.file.Paths;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.metrics.collector.conf.Annotation;
import org.torproject.metrics.collector.persist.DescriptorPersistence;
import org.torproject.metrics.collector.persist.PersistenceUtils;

public class ConsensusPersistence
extends DescriptorPersistence<RelayNetworkStatusConsensus> {
    private static final String CONSENSUS = "consensus";

    public ConsensusPersistence(RelayNetworkStatusConsensus desc, long received) {
        super(desc, Annotation.Consensus.bytes());
        this.calculatePaths(received);
    }

    private void calculatePaths(long received) {
        String fileRecent = PersistenceUtils.dateTime(((RelayNetworkStatusConsensus)this.desc).getValidAfterMillis());
        String fileOut = PersistenceUtils.dateTime(((RelayNetworkStatusConsensus)this.desc).getValidAfterMillis());
        String[] parts = fileOut.split("-");
        this.recentPath = Paths.get("relay-descriptors", "consensuses", fileRecent + "-" + CONSENSUS).toString();
        this.storagePath = Paths.get("relay-descriptors", CONSENSUS, parts[0], parts[1], parts[2], fileOut + "-" + CONSENSUS).toString();
    }
}

