/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.webstats;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.Method;
import org.torproject.descriptor.WebServerAccessLog;
import org.torproject.descriptor.internal.FileType;
import org.torproject.descriptor.log.WebServerAccessLogImpl;
import org.torproject.descriptor.log.WebServerAccessLogLine;
import org.torproject.metrics.collector.conf.Configuration;
import org.torproject.metrics.collector.conf.Key;
import org.torproject.metrics.collector.conf.SourceType;
import org.torproject.metrics.collector.cron.CollecTorMain;
import org.torproject.metrics.collector.persist.PersistenceUtils;
import org.torproject.metrics.collector.persist.WebServerAccessLogPersistence;
import org.torproject.metrics.collector.webstats.LogFileMap;
import org.torproject.metrics.collector.webstats.LogMetadata;

public class SanitizeWeblogs
extends CollecTorMain {
    private static final Logger log = LoggerFactory.getLogger(SanitizeWeblogs.class);
    private static final int LIMIT = 2;
    private static final String WEBSTATS = "webstats";
    private String outputPathName;
    private String recentPathName;
    private boolean limits;
    private static final int BATCH = 100000;
    private static final int LISTLIMIT = 0x3FFFFFFF;

    public SanitizeWeblogs(Configuration conf) {
        super(conf);
        this.mapPathDescriptors.put("recent/webstats", WebServerAccessLog.class);
    }

    @Override
    public String module() {
        return WEBSTATS;
    }

    @Override
    protected String syncMarker() {
        return "Webstats";
    }

    @Override
    protected void startProcessing() {
        try {
            Files.createDirectories(this.config.getPath(Key.OutputPath), new FileAttribute[0]);
            Files.createDirectories(this.config.getPath(Key.RecentPath), new FileAttribute[0]);
            this.outputPathName = this.config.getPath(Key.OutputPath).toString();
            this.recentPathName = this.config.getPath(Key.RecentPath).toString();
            this.limits = this.config.getBool(Key.WebstatsLimits);
            Set<SourceType> sources = this.config.getSourceTypeSet(Key.WebstatsSources);
            if (sources.contains((Object)SourceType.Local)) {
                log.info("Processing logs using batch value {}.", (Object)100000);
                this.findCleanWrite(this.config.getPath(Key.WebstatsLocalOrigins));
                long cutOffMillis = System.currentTimeMillis() - 259200000L;
                PersistenceUtils.cleanDirectory(this.config.getPath(Key.RecentPath), cutOffMillis);
            }
        }
        catch (Exception e) {
            log.error("Cannot sanitize web-logs: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void findCleanWrite(Path dir) {
        LogFileMap fileMapIn = new LogFileMap(dir);
        log.info("Found log files for {} virtual hosts.", (Object)fileMapIn.size());
        for (Map.Entry virtualEntry : fileMapIn.entrySet()) {
            String virtualHost = (String)virtualEntry.getKey();
            for (Map.Entry physicalEntry : ((TreeMap)virtualEntry.getValue()).entrySet()) {
                String physicalHost = (String)physicalEntry.getKey();
                log.info("Processing logs for {} on {}.", (Object)virtualHost, (Object)physicalHost);
                Map<LocalDate, Map> linesByDate = ((Stream)((TreeMap)physicalEntry.getValue()).values().stream().parallel()).flatMap(metadata -> this.sanitzedLineStream((LogMetadata)metadata).entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.reducing(Collections.emptyMap(), Map.Entry::getValue, (e1, e2) -> Stream.concat(e1.entrySet().stream(), e2.entrySet().stream()).collect(Collectors.groupingByConcurrent(Map.Entry::getKey, Collectors.summingLong(Map.Entry::getValue))))));
                LocalDate[] interval = this.determineInterval(linesByDate.keySet());
                ((Stream)linesByDate.entrySet().stream().filter(entry -> ((LocalDate)entry.getKey()).isAfter(interval[0]) && ((LocalDate)entry.getKey()).isBefore(interval[1])).parallel()).forEach(entry -> this.storeSortedAndForget(virtualHost, physicalHost, (LocalDate)entry.getKey(), (Map)entry.getValue()));
            }
        }
    }

    private void storeSortedAndForget(String virtualHost, String physicalHost, LocalDate date, Map<String, Long> lineCounts) {
        String name = new StringJoiner("_").add(virtualHost).add(physicalHost).add("access.log").add(date.format(DateTimeFormatter.BASIC_ISO_DATE)).toString() + "." + FileType.XZ.name().toLowerCase();
        log.debug("Storing {}.", (Object)name);
        TreeMap<String, Long> retainedLines = new TreeMap<String, Long>(lineCounts);
        lineCounts.clear();
        try {
            WebServerAccessLogPersistence walp = new WebServerAccessLogPersistence(new WebServerAccessLogImpl(SanitizeWeblogs.toCompressedBytes(retainedLines), new File(name), name, false));
            log.debug("Storing {}.", (Object)name);
            walp.storeOut(this.outputPathName);
            walp.storeRecent(this.recentPathName);
        }
        catch (DescriptorParseException dpe) {
            log.error("Cannot store log desriptor {}.", (Object)name, (Object)dpe);
        }
        catch (Throwable th) {
            log.error("Serious problem.  Cannot store log desriptor {}.", (Object)name, (Object)th);
        }
    }

    /*
     * Exception decompiling
     */
    static byte[] toCompressedBytes(Map<String, Long> lines) throws DescriptorParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] bytesFor(String line, long times) {
        return Stream.iterate(line, UnaryOperator.identity()).limit(times).collect(Collectors.joining("\n", "", "\n")).getBytes();
    }

    static Optional<WebServerAccessLogLine> sanitize(WebServerAccessLogLine logLine) {
        int queryStart;
        if (!logLine.isValid() || Method.GET != logLine.getMethod() && Method.HEAD != logLine.getMethod() || !logLine.getProtocol().startsWith("HTTP") || 400 == logLine.getResponse() || 404 == logLine.getResponse()) {
            return Optional.empty();
        }
        if (!logLine.getIp().startsWith("0.0.0.")) {
            logLine.setIp("0.0.0.0");
        }
        if ((queryStart = logLine.getRequest().indexOf("?")) > 0) {
            logLine.setRequest(logLine.getRequest().substring(0, queryStart));
        }
        return Optional.of(logLine);
    }

    LocalDate[] determineInterval(Set<LocalDate> dates) {
        if (dates.isEmpty()) {
            return new LocalDate[]{LocalDate.MAX, LocalDate.MIN};
        }
        TreeSet<LocalDate> sorted = new TreeSet<LocalDate>(dates);
        if (this.limits) {
            for (int i = 0; i < 1; ++i) {
                sorted.remove(sorted.last());
            }
        }
        if (sorted.isEmpty()) {
            return new LocalDate[]{LocalDate.MAX, LocalDate.MIN};
        }
        if (!this.limits) {
            sorted.add(((LocalDate)sorted.first()).minusDays(1L));
            sorted.add(((LocalDate)sorted.last()).plusDays(1L));
        }
        return new LocalDate[]{(LocalDate)sorted.first(), (LocalDate)sorted.last()};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<LocalDate, Map<String, Long>> sanitzedLineStream(LogMetadata metadata) {
        log.debug("Processing file {}.", (Object)metadata.path);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(metadata.fileType.decompress(Files.newInputStream(metadata.path, new OpenOption[0]))));){
            ArrayList lists = new ArrayList();
            ArrayList<WebServerAccessLogLine> currentList = new ArrayList<WebServerAccessLogLine>();
            lists.add(currentList);
            String lineStr = br.readLine();
            int count = 0;
            while (null != lineStr) {
                WebServerAccessLogLine wsal = WebServerAccessLogLine.makeLine(lineStr);
                if (wsal.isValid()) {
                    currentList.add(wsal);
                    ++count;
                }
                if (count >= 0x3FFFFFFF) {
                    currentList = new ArrayList();
                    lists.add(currentList);
                    count = 0;
                }
                lineStr = br.readLine();
            }
            br.close();
            Map map2 = ((Stream)lists.parallelStream().map(list -> list.stream().map(SanitizeWeblogs::sanitize).filter(Optional::isPresent).map(Optional::get).collect(Collectors.groupingBy(WebServerAccessLogLine::getDate, Collectors.groupingBy(WebServerAccessLogLine::toLogString, Collectors.counting())))).flatMap(map -> map.entrySet().stream()).parallel()).collect(Collectors.groupingByConcurrent(Map.Entry::getKey, Collectors.reducing(Collections.emptyMap(), Map.Entry::getValue, (e1, e2) -> ((Stream)Stream.concat(e1.entrySet().stream(), e2.entrySet().stream()).parallel()).collect(Collectors.groupingByConcurrent(Map.Entry::getKey, Collectors.summingLong(Map.Entry::getValue))))));
            return map2;
        }
        catch (Exception ex) {
            log.debug("Skipping log-file {}.", (Object)metadata.path, (Object)ex);
            return Collections.emptyMap();
        }
    }
}

