/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.collector.relaydescs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.collector.relaydescs.ArchiveReader;
import org.torproject.metrics.collector.relaydescs.ArchiveWriter;
import org.torproject.metrics.collector.relaydescs.RelayDescriptorDownloader;

public class RelayDescriptorParser {
    private ArchiveWriter aw;
    private ArchiveReader ar;
    private RelayDescriptorDownloader rdd;
    private static final Logger logger = LoggerFactory.getLogger(RelayDescriptorParser.class);
    private SimpleDateFormat dateTimeFormat;

    public RelayDescriptorParser(ArchiveWriter aw) {
        this.aw = aw;
        this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void setRelayDescriptorDownloader(RelayDescriptorDownloader rdd) {
        this.rdd = rdd;
    }

    public void setArchiveReader(ArchiveReader ar) {
        this.ar = ar;
    }

    public boolean parse(byte[] data) {
        boolean stored = false;
        try {
            BufferedReader br;
            block64: {
                SimpleDateFormat parseFormat;
                String line;
                block63: {
                    br = new BufferedReader(new StringReader(new String(data, "US-ASCII")));
                    while ((line = br.readLine()) != null && line.startsWith("@")) {
                    }
                    if (line == null) {
                        logger.debug("We were given an empty descriptor for parsing. Ignoring.");
                        return false;
                    }
                    parseFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    parseFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    if (!line.startsWith("network-status-version 3")) break block63;
                    String statusType = "consensus";
                    if (line.equals("network-status-version 3 microdesc")) {
                        statusType = "consensus-microdesc";
                    }
                    String validAfterTime = null;
                    String fingerprint = null;
                    String dirSource = null;
                    long validAfter = -1L;
                    long dirKeyPublished = -1L;
                    TreeSet<String> dirSources = new TreeSet<String>();
                    TreeSet<String> serverDescriptors = new TreeSet<String>();
                    TreeSet<String> serverDescriptorDigests = new TreeSet<String>();
                    TreeSet<String> microdescriptorKeys = new TreeSet<String>();
                    TreeSet<String> microdescriptorDigests = new TreeSet<String>();
                    StringBuilder certificateStringBuilder = null;
                    String certificateString = null;
                    String lastRelayIdentity = null;
                    while ((line = br.readLine()) != null) {
                        String[] parts;
                        if (certificateStringBuilder != null) {
                            if (line.startsWith("r ")) {
                                certificateString = certificateStringBuilder.toString();
                                certificateStringBuilder = null;
                            } else {
                                certificateStringBuilder.append(line).append("\n");
                            }
                        }
                        if (line.equals("vote-status vote")) {
                            statusType = "vote";
                            continue;
                        }
                        if (line.startsWith("valid-after ")) {
                            validAfterTime = line.substring("valid-after ".length());
                            validAfter = parseFormat.parse(validAfterTime).getTime();
                            continue;
                        }
                        if (line.startsWith("dir-source ")) {
                            dirSource = line.split(" ")[2];
                            continue;
                        }
                        if (line.startsWith("vote-digest ")) {
                            dirSources.add(dirSource);
                            continue;
                        }
                        if (line.startsWith("dir-key-certificate-version ")) {
                            certificateStringBuilder = new StringBuilder();
                            certificateStringBuilder.append(line).append("\n");
                            continue;
                        }
                        if (line.startsWith("fingerprint ")) {
                            fingerprint = line.split(" ")[1];
                            continue;
                        }
                        if (line.startsWith("dir-key-published ")) {
                            String dirKeyPublishedTime = line.substring("dir-key-published ".length());
                            dirKeyPublished = parseFormat.parse(dirKeyPublishedTime).getTime();
                            continue;
                        }
                        if (line.startsWith("r ")) {
                            parts = line.split(" ");
                            if (parts.length == 8) {
                                lastRelayIdentity = Hex.encodeHexString((byte[])Base64.decodeBase64((String)(parts[2] + "="))).toLowerCase();
                                continue;
                            }
                            if (parts.length == 9) {
                                lastRelayIdentity = Hex.encodeHexString((byte[])Base64.decodeBase64((String)(parts[2] + "="))).toLowerCase();
                                String serverDesc = Hex.encodeHexString((byte[])Base64.decodeBase64((String)(parts[3] + "="))).toLowerCase();
                                String publishedTime = parts[4] + " " + parts[5];
                                serverDescriptors.add(publishedTime + "," + lastRelayIdentity + "," + serverDesc);
                                serverDescriptorDigests.add(serverDesc);
                                continue;
                            }
                            logger.warn("Could not parse r line '{}' in descriptor. Skipping.", (Object)line);
                            break;
                        }
                        if (!line.startsWith("m ")) continue;
                        parts = line.split(" ");
                        if (parts.length == 2 && parts[1].length() == 43) {
                            String digest256Base64 = parts[1];
                            microdescriptorKeys.add(validAfterTime + "," + lastRelayIdentity + "," + digest256Base64);
                            String digest256Hex = Hex.encodeHexString((byte[])Base64.decodeBase64((String)(digest256Base64 + "="))).toLowerCase();
                            microdescriptorDigests.add(digest256Hex);
                            continue;
                        }
                        if (parts.length == 3 && parts[2].startsWith("sha256=") && parts[2].length() == 50) continue;
                        logger.warn("Could not parse m line '{}' in descriptor. Skipping.", (Object)line);
                        break;
                    }
                    switch (statusType) {
                        case "consensus": {
                            if (this.rdd != null) {
                                this.rdd.haveParsedConsensus(validAfterTime, dirSources, serverDescriptors);
                            }
                            if (this.aw != null) {
                                this.aw.storeConsensus(data, validAfter, dirSources, serverDescriptorDigests);
                                stored = true;
                                break;
                            }
                            break block64;
                        }
                        case "consensus-microdesc": {
                            if (this.rdd != null) {
                                this.rdd.haveParsedMicrodescConsensus(validAfterTime, microdescriptorKeys);
                            }
                            if (this.ar != null) {
                                this.ar.haveParsedMicrodescConsensus(validAfterTime, microdescriptorDigests);
                            }
                            if (this.aw != null) {
                                this.aw.storeMicrodescConsensus(data, validAfter, microdescriptorDigests);
                                stored = true;
                                break;
                            }
                            break block64;
                        }
                        default: {
                            if (this.aw != null || this.rdd != null) {
                                String ascii = new String(data, "US-ASCII");
                                String startToken = "network-status-version ";
                                String sigToken = "directory-signature ";
                                int start = ascii.indexOf(startToken);
                                int sig = ascii.indexOf(sigToken);
                                if (start >= 0 && sig >= 0 && sig > start) {
                                    byte[] forDigest = new byte[(sig += sigToken.length()) - start];
                                    System.arraycopy(data, start, forDigest, 0, sig - start);
                                    String digest = DigestUtils.sha1Hex((byte[])forDigest).toUpperCase();
                                    if (this.aw != null) {
                                        this.aw.storeVote(data, validAfter, dirSource, digest, serverDescriptorDigests);
                                        stored = true;
                                    }
                                    if (this.rdd != null) {
                                        this.rdd.haveParsedVote(validAfterTime, fingerprint, serverDescriptors);
                                    }
                                }
                                if (certificateString != null && this.aw != null) {
                                    this.aw.storeCertificate(certificateString.getBytes(), dirSource, dirKeyPublished);
                                    stored = true;
                                    break;
                                }
                            }
                            break block64;
                        }
                    }
                    break block64;
                }
                if (line.startsWith("router ")) {
                    String publishedTime = null;
                    String extraInfoDigest = null;
                    String relayIdentifier = null;
                    long published = -1L;
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("published ")) {
                            publishedTime = line.substring("published ".length());
                            published = parseFormat.parse(publishedTime).getTime();
                            continue;
                        }
                        if (line.startsWith("opt fingerprint") || line.startsWith("fingerprint")) {
                            relayIdentifier = line.substring(line.startsWith("opt ") ? "opt fingerprint".length() : "fingerprint".length()).replaceAll(" ", "").toLowerCase();
                            continue;
                        }
                        if (!line.startsWith("opt extra-info-digest ") && !line.startsWith("extra-info-digest ")) continue;
                        extraInfoDigest = line.startsWith("opt ") ? line.split(" ")[2].toLowerCase() : line.split(" ")[1].toLowerCase();
                    }
                    String ascii = new String(data, "US-ASCII");
                    String startToken = "router ";
                    String sigToken = "\nrouter-signature\n";
                    int start = ascii.indexOf(startToken);
                    int sig = ascii.indexOf(sigToken) + sigToken.length();
                    String digest = null;
                    if (start >= 0 || sig >= 0 || sig > start) {
                        byte[] forDigest = new byte[sig - start];
                        System.arraycopy(data, start, forDigest, 0, sig - start);
                        digest = DigestUtils.sha1Hex((byte[])forDigest);
                    }
                    if (this.aw != null && digest != null) {
                        this.aw.storeServerDescriptor(data, digest, published, extraInfoDigest);
                        stored = true;
                    }
                    if (this.rdd != null && digest != null) {
                        this.rdd.haveParsedServerDescriptor(publishedTime, relayIdentifier, digest, extraInfoDigest);
                    }
                } else if (line.startsWith("extra-info ")) {
                    String publishedTime = null;
                    String relayIdentifier = line.split(" ")[2];
                    long published = -1L;
                    while ((line = br.readLine()) != null) {
                        if (!line.startsWith("published ")) continue;
                        publishedTime = line.substring("published ".length());
                        published = parseFormat.parse(publishedTime).getTime();
                    }
                    String ascii = new String(data, "US-ASCII");
                    String startToken = "extra-info ";
                    String sigToken = "\nrouter-signature\n";
                    String digest = null;
                    int start = ascii.indexOf(startToken);
                    if (start > 0 && (start = ascii.indexOf("\n" + startToken)) > 0) {
                        ++start;
                    }
                    int sig = ascii.indexOf(sigToken) + sigToken.length();
                    if (start >= 0 && sig >= 0 && sig > start) {
                        byte[] forDigest = new byte[sig - start];
                        System.arraycopy(data, start, forDigest, 0, sig - start);
                        digest = DigestUtils.sha1Hex((byte[])forDigest);
                    }
                    if (this.aw != null && digest != null) {
                        this.aw.storeExtraInfoDescriptor(data, digest, published);
                        stored = true;
                    }
                    if (this.rdd != null && digest != null) {
                        this.rdd.haveParsedExtraInfoDescriptor(publishedTime, relayIdentifier.toLowerCase(), digest);
                    }
                } else if (!line.equals("onion-key") && line.matches("[0-9]{10}")) {
                    String timestampLine = line;
                    LocalDateTime fileCreatedOrTimestamp = null;
                    try {
                        while ((line = br.readLine()) != null) {
                            if (line.startsWith("file_created=")) {
                                fileCreatedOrTimestamp = LocalDateTime.parse(line.substring("file_created=".length()));
                            } else if (!line.startsWith("bw=") && !line.contains(" bw=") && !"====".equals(line) && !"=====".equals(line)) continue;
                            break;
                        }
                    }
                    catch (IOException | DateTimeParseException published) {
                        // empty catch block
                    }
                    if (null == fileCreatedOrTimestamp) {
                        try {
                            fileCreatedOrTimestamp = LocalDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(timestampLine)), ZoneOffset.UTC);
                        }
                        catch (NumberFormatException | DateTimeParseException e) {
                            logger.warn("Could not parse timestamp or file_created time from bandwidth file. Storing with timestamp 2000-01-01 00:00:00");
                            fileCreatedOrTimestamp = LocalDateTime.of(2000, 1, 1, 0, 0, 0);
                        }
                    }
                    this.aw.storeBandwidthFile(data, fileCreatedOrTimestamp, DigestUtils.sha256Hex((byte[])data).toUpperCase());
                    stored = true;
                }
            }
            br.close();
        }
        catch (IOException | ParseException e) {
            logger.warn("Could not parse descriptor. Skipping.", (Throwable)e);
        }
        return stored;
    }

    public void storeMicrodescriptor(byte[] data, String digest256Hex, String digest256Base64, long validAfter) {
        if (this.aw != null) {
            this.aw.storeMicrodescriptor(data, digest256Hex, validAfter);
        }
        if (this.rdd != null) {
            this.rdd.haveParsedMicrodescriptor(digest256Base64);
        }
    }
}

