/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DirectorySignature;
import org.torproject.descriptor.impl.ParseHelper;

public class DirectorySignatureImpl
implements DirectorySignature {
    private byte[] directorySignatureBytes;
    private boolean failUnrecognizedDescriptorLines;
    private List<String> unrecognizedLines;
    private String algorithm = "sha1";
    private String identity;
    private String signingKeyDigest;
    private String signature;

    public byte[] getDirectorySignatureBytes() {
        return this.directorySignatureBytes;
    }

    protected List<String> getAndClearUnrecognizedLines() {
        List<String> lines = this.unrecognizedLines;
        this.unrecognizedLines = null;
        return lines;
    }

    protected DirectorySignatureImpl(byte[] directorySignatureBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        this.directorySignatureBytes = directorySignatureBytes;
        this.failUnrecognizedDescriptorLines = failUnrecognizedDescriptorLines;
        this.parseDirectorySignatureBytes();
    }

    private void parseDirectorySignatureBytes() throws DescriptorParseException {
        Scanner s = new Scanner(new String(this.directorySignatureBytes)).useDelimiter("\n");
        StringBuilder crypto = null;
        while (s.hasNext()) {
            String line = s.next();
            if (line.startsWith("directory-signature ")) {
                String[] parts = line.split(" ", -1);
                int algorithmOffset = 0;
                if (parts.length == 4) {
                    this.algorithm = parts[1];
                    algorithmOffset = 1;
                } else if (parts.length != 3) {
                    throw new DescriptorParseException("Illegal line '" + line + "'.");
                }
                this.identity = ParseHelper.parseTwentyByteHexString(line, parts[1 + algorithmOffset]);
                this.signingKeyDigest = ParseHelper.parseTwentyByteHexString(line, parts[2 + algorithmOffset]);
                continue;
            }
            if (line.startsWith("-----BEGIN")) {
                crypto = new StringBuilder();
                crypto.append(line + "\n");
                continue;
            }
            if (line.startsWith("-----END")) {
                crypto.append(line + "\n");
                String cryptoString = crypto.toString();
                crypto = null;
                this.signature = cryptoString;
                continue;
            }
            if (crypto != null) {
                crypto.append(line + "\n");
                continue;
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in dir-source entry.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList<String>();
            }
            this.unrecognizedLines.add(line);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public String getSigningKeyDigest() {
        return this.signingKeyDigest;
    }

    @Override
    public String getSignature() {
        return this.signature;
    }
}

