/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.ExitListEntry;
import org.torproject.descriptor.impl.ExitListImpl;

public class ExitListImplTest {
    private static final String tordnselAnnotation = "@type tordnsel 1.0\n";
    private static final String fileName = "2015-09-01-00-02-02";
    private static final String[] insufficientInput = new String[]{"Downloaded 2015-09-01 00:02:02\nExitNode 0011BD2485AD45D984EC4159C88FC066E5E3300E\nPublished 2015-08-31 16:17:30\nLastStatus 2015-08-31 17:03:18\n", "Downloaded 2015-09-01 00:02:02\nExitNode 0011BD2485AD45D984EC4159C88FC066E5E3300E\nLastStatus 2015-08-31 17:03:18\nExitAddress 81.7.17.172 2015-08-31 18:10:52\n"};
    private static final String multiExitAddressInput = "Downloaded 2015-09-01 00:02:02\nExitNode 0011BD2485AD45D984EC4159C88FC066E5E3300E\nPublished 2015-08-31 16:17:30\nLastStatus 2015-08-31 17:03:18\nExitAddress 81.7.17.171 2015-08-31 18:09:52\nExitAddress 81.7.17.172 2015-08-31 18:10:52\nExitAddress 81.7.17.173 2015-08-31 18:11:52\n";
    private static final String input = "Downloaded 2015-09-01 00:02:02\nExitNode 0011BD2485AD45D984EC4159C88FC066E5E3300E\nPublished 2015-08-31 16:17:30\nLastStatus 2015-08-31 17:03:18\nExitAddress 162.247.72.201 2015-08-31 17:09:23\nExitNode 0098C475875ABC4AA864738B1D1079F711C38287\nPublished 2015-08-31 13:59:24\nLastStatus 2015-08-31 15:03:20\nExitAddress 162.248.160.151 2015-08-31 15:07:27\nExitNode 00C4B4731658D3B4987132A3F77100CFCB190D97\nPublished 2015-08-31 17:47:52\nLastStatus 2015-08-31 18:03:17\nExitAddress 81.7.17.171 2015-08-31 18:09:52\nExitAddress 81.7.17.172 2015-08-31 18:10:52\nExitAddress 81.7.17.173 2015-08-31 18:11:52\nExitNode 00F2D93EBAF2F51D6EE4DCB0F37D91D72F824B16\nPublished 2015-08-31 14:39:05\nLastStatus 2015-08-31 16:02:18\nExitAddress 23.239.18.57 2015-08-31 16:06:07\nExitNode 011B1D1E876B2C835D01FB9D407F2E00B28077F6\nPublished 2015-08-31 05:14:35\nLastStatus 2015-08-31 06:03:29\nExitAddress 104.131.51.150 2015-08-31 06:04:07\n";

    @Test
    public void testAnnotatedInput() throws Exception {
        ExitListImpl result = new ExitListImpl("@type tordnsel 1.0\nDownloaded 2015-09-01 00:02:02\nExitNode 0011BD2485AD45D984EC4159C88FC066E5E3300E\nPublished 2015-08-31 16:17:30\nLastStatus 2015-08-31 17:03:18\nExitAddress 162.247.72.201 2015-08-31 17:09:23\nExitNode 0098C475875ABC4AA864738B1D1079F711C38287\nPublished 2015-08-31 13:59:24\nLastStatus 2015-08-31 15:03:20\nExitAddress 162.248.160.151 2015-08-31 15:07:27\nExitNode 00C4B4731658D3B4987132A3F77100CFCB190D97\nPublished 2015-08-31 17:47:52\nLastStatus 2015-08-31 18:03:17\nExitAddress 81.7.17.171 2015-08-31 18:09:52\nExitAddress 81.7.17.172 2015-08-31 18:10:52\nExitAddress 81.7.17.173 2015-08-31 18:11:52\nExitNode 00F2D93EBAF2F51D6EE4DCB0F37D91D72F824B16\nPublished 2015-08-31 14:39:05\nLastStatus 2015-08-31 16:02:18\nExitAddress 23.239.18.57 2015-08-31 16:06:07\nExitNode 011B1D1E876B2C835D01FB9D407F2E00B28077F6\nPublished 2015-08-31 05:14:35\nLastStatus 2015-08-31 06:03:29\nExitAddress 104.131.51.150 2015-08-31 06:04:07\n".getBytes("US-ASCII"), fileName, false);
        Assert.assertEquals((String)"Expected one annotation.", (long)1L, (long)result.getAnnotations().size());
        Assert.assertEquals((Object)tordnselAnnotation.substring(0, 18), (Object)result.getAnnotations().get(0));
        Assert.assertEquals((long)1441065722000L, (long)result.getDownloadedMillis());
        Assert.assertTrue((String)("Unrecognized lines: " + result.getUnrecognizedLines()), (boolean)result.getUnrecognizedLines().isEmpty());
        Assert.assertEquals((String)("Found: " + result.getExitListEntries()), (long)7L, (long)result.getExitListEntries().size());
        Assert.assertEquals((String)("Found: " + result.getEntries()), (long)5L, (long)result.getEntries().size());
    }

    @Test
    public void testMultipleOldExitAddresses() throws Exception {
        ExitListImpl result = new ExitListImpl("@type tordnsel 1.0\nDownloaded 2015-09-01 00:02:02\nExitNode 0011BD2485AD45D984EC4159C88FC066E5E3300E\nPublished 2015-08-31 16:17:30\nLastStatus 2015-08-31 17:03:18\nExitAddress 81.7.17.171 2015-08-31 18:09:52\nExitAddress 81.7.17.172 2015-08-31 18:10:52\nExitAddress 81.7.17.173 2015-08-31 18:11:52\n".getBytes("US-ASCII"), fileName, false);
        Assert.assertTrue((String)("Unrecognized lines: " + result.getUnrecognizedLines()), (boolean)result.getUnrecognizedLines().isEmpty());
        Assert.assertEquals((String)("Found: " + result.getExitListEntries()), (long)3L, (long)result.getExitListEntries().size());
        HashMap<String, Long> testMap = new HashMap<String, Long>();
        testMap.put("81.7.17.171", 1441044592000L);
        testMap.put("81.7.17.172", 1441044652000L);
        testMap.put("81.7.17.173", 1441044712000L);
        for (ExitListEntry ele : result.getExitListEntries()) {
            Map<String, Long> map = ele.getExitAddresses();
            Assert.assertEquals((String)("Found: " + map), (long)1L, (long)map.size());
            Map.Entry<String, Long> ea = map.entrySet().iterator().next();
            Assert.assertTrue((String)("Map: " + testMap), (boolean)testMap.keySet().contains(ea.getKey()));
            Assert.assertTrue((String)("Map: " + testMap + " exitaddress: " + ea), (boolean)testMap.values().contains(ea.getValue()));
            testMap.remove(ea.getKey());
        }
        Assert.assertTrue((String)("Map: " + testMap), (boolean)testMap.isEmpty());
    }

    @Test
    public void testMultipleExitAddresses() throws Exception {
        ExitListImpl result = new ExitListImpl("@type tordnsel 1.0\nDownloaded 2015-09-01 00:02:02\nExitNode 0011BD2485AD45D984EC4159C88FC066E5E3300E\nPublished 2015-08-31 16:17:30\nLastStatus 2015-08-31 17:03:18\nExitAddress 81.7.17.171 2015-08-31 18:09:52\nExitAddress 81.7.17.172 2015-08-31 18:10:52\nExitAddress 81.7.17.173 2015-08-31 18:11:52\n".getBytes("US-ASCII"), fileName, false);
        Assert.assertTrue((String)("Unrecognized lines: " + result.getUnrecognizedLines()), (boolean)result.getUnrecognizedLines().isEmpty());
        Map<String, Long> map = result.getEntries().iterator().next().getExitAddresses();
        Assert.assertEquals((String)("Found: " + map), (long)3L, (long)map.size());
        Assert.assertTrue((String)("Map: " + map), (boolean)map.containsKey("81.7.17.171"));
        Assert.assertTrue((String)("Map: " + map), (boolean)map.containsKey("81.7.17.172"));
        Assert.assertTrue((String)("Map: " + map), (boolean)map.containsKey("81.7.17.173"));
    }

    @Test(expected=DescriptorParseException.class)
    public void testInsufficientInput0() throws Exception {
        new ExitListImpl((tordnselAnnotation + insufficientInput[0]).getBytes("US-ASCII"), fileName, false);
    }

    @Test(expected=DescriptorParseException.class)
    public void testInsufficientInput1() throws Exception {
        new ExitListImpl((tordnselAnnotation + insufficientInput[1]).getBytes("US-ASCII"), fileName, false);
    }
}

