/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.RelayNetworkStatusVote;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.NetworkStatusImpl;
import org.torproject.descriptor.impl.ParseHelper;

public class RelayNetworkStatusVoteImpl
extends NetworkStatusImpl
implements RelayNetworkStatusVote {
    private String nickname;
    private String identity;
    private String address;
    private int dirPort;
    private int orPort;
    private String contactLine;
    private int dirKeyCertificateVersion;
    private String legacyDirKey;
    private long dirKeyPublishedMillis;
    private long dirKeyExpiresMillis;
    private String signingKeyDigest;
    private int networkStatusVersion;
    private Integer[] consensusMethods;
    private long publishedMillis;
    private long validAfterMillis;
    private long freshUntilMillis;
    private long validUntilMillis;
    private long voteSeconds;
    private long distSeconds;
    private String[] recommendedClientVersions;
    private String[] recommendedServerVersions;
    private String[] knownFlags;
    private long stableUptime;
    private long stableMtbf;
    private long fastBandwidth;
    private double guardWfu;
    private long guardTk;
    private long guardBandwidthIncludingExits;
    private long guardBandwidthExcludingExits;
    private int enoughMtbfInfo;
    private int ignoringAdvertisedBws;
    private SortedMap<String, Integer> consensusParams;

    protected static List<RelayNetworkStatusVote> parseVotes(byte[] votesBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        ArrayList<RelayNetworkStatusVote> parsedVotes = new ArrayList<RelayNetworkStatusVote>();
        List<byte[]> splitVotesBytes = DescriptorImpl.splitRawDescriptorBytes(votesBytes, "network-status-version 3");
        for (byte[] voteBytes : splitVotesBytes) {
            RelayNetworkStatusVoteImpl parsedVote = new RelayNetworkStatusVoteImpl(voteBytes, failUnrecognizedDescriptorLines);
            parsedVotes.add(parsedVote);
        }
        return parsedVotes;
    }

    protected RelayNetworkStatusVoteImpl(byte[] voteBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        super(voteBytes, failUnrecognizedDescriptorLines, false, false);
        HashSet<String> exactlyOnceKeywords = new HashSet<String>(Arrays.asList("vote-status,consensus-methods,published,valid-after,fresh-until,valid-until,voting-delay,known-flags,dir-source,dir-key-certificate-version,fingerprint,dir-key-published,dir-key-expires,dir-identity-key,dir-signing-key,dir-key-certification,directory-signature".split(",")));
        this.checkExactlyOnceKeywords(exactlyOnceKeywords);
        HashSet<String> atMostOnceKeywords = new HashSet<String>(Arrays.asList("client-versions,server-versions,flag-thresholds,params,contact,legacy-key,dir-key-crosscert,dir-address,directory-footer".split(",")));
        this.checkAtMostOnceKeywords(atMostOnceKeywords);
        this.checkFirstKeyword("network-status-version");
        this.clearParsedKeywords();
    }

    @Override
    protected void parseHeader(byte[] headerBytes) throws DescriptorParseException {
        this.stableUptime = -1L;
        this.stableMtbf = -1L;
        this.fastBandwidth = -1L;
        this.guardWfu = -1.0;
        this.guardTk = -1L;
        this.guardBandwidthIncludingExits = -1L;
        this.guardBandwidthExcludingExits = -1L;
        this.enoughMtbfInfo = -1;
        this.ignoringAdvertisedBws = -1;
        Scanner s = new Scanner(new String(headerBytes)).useDelimiter("\n");
        boolean skipCrypto = false;
        block55: while (s.hasNext()) {
            String keyword;
            String line = s.next();
            String[] parts = line.split("[ \t]+");
            switch (keyword = parts[0]) {
                case "network-status-version": {
                    this.parseNetworkStatusVersionLine(line, parts);
                    continue block55;
                }
                case "vote-status": {
                    this.parseVoteStatusLine(line, parts);
                    continue block55;
                }
                case "consensus-methods": {
                    this.parseConsensusMethodsLine(line, parts);
                    continue block55;
                }
                case "published": {
                    this.parsePublishedLine(line, parts);
                    continue block55;
                }
                case "valid-after": {
                    this.parseValidAfterLine(line, parts);
                    continue block55;
                }
                case "fresh-until": {
                    this.parseFreshUntilLine(line, parts);
                    continue block55;
                }
                case "valid-until": {
                    this.parseValidUntilLine(line, parts);
                    continue block55;
                }
                case "voting-delay": {
                    this.parseVotingDelayLine(line, parts);
                    continue block55;
                }
                case "client-versions": {
                    this.parseClientVersionsLine(line, parts);
                    continue block55;
                }
                case "server-versions": {
                    this.parseServerVersionsLine(line, parts);
                    continue block55;
                }
                case "known-flags": {
                    this.parseKnownFlagsLine(line, parts);
                    continue block55;
                }
                case "flag-thresholds": {
                    this.parseFlagThresholdsLine(line, parts);
                    continue block55;
                }
                case "params": {
                    this.parseParamsLine(line, parts);
                    continue block55;
                }
                case "dir-source": {
                    this.parseDirSourceLine(line, parts);
                    continue block55;
                }
                case "contact": {
                    this.parseContactLine(line, parts);
                    continue block55;
                }
                case "dir-key-certificate-version": {
                    this.parseDirKeyCertificateVersionLine(line, parts);
                    continue block55;
                }
                case "dir-address": {
                    this.parseDirAddressLine(line, parts);
                    continue block55;
                }
                case "fingerprint": {
                    this.parseFingerprintLine(line, parts);
                    continue block55;
                }
                case "legacy-dir-key": {
                    this.parseLegacyDirKeyLine(line, parts);
                    continue block55;
                }
                case "dir-key-published": {
                    this.parseDirKeyPublished(line, parts);
                    continue block55;
                }
                case "dir-key-expires": {
                    this.parseDirKeyExpiresLine(line, parts);
                    continue block55;
                }
                case "dir-identity-key": 
                case "dir-signing-key": 
                case "dir-key-crosscert": 
                case "dir-key-certification": {
                    continue block55;
                }
                case "-----BEGIN": {
                    skipCrypto = true;
                    continue block55;
                }
                case "-----END": {
                    skipCrypto = false;
                    continue block55;
                }
            }
            if (skipCrypto) continue;
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in vote.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseNetworkStatusVersionLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals("network-status-version 3")) {
            throw new DescriptorParseException("Illegal network status version number in line '" + line + "'.");
        }
        this.networkStatusVersion = 3;
    }

    private void parseVoteStatusLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2 || !parts[1].equals("vote")) {
            throw new DescriptorParseException("Line '" + line + "' indicates " + "that this is not a vote.");
        }
    }

    private void parseConsensusMethodsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        Integer[] consensusMethods = new Integer[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            int consensusMethod = -1;
            try {
                consensusMethod = Integer.parseInt(parts[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (consensusMethod < 1) {
                throw new DescriptorParseException("Illegal consensus method number in line '" + line + "'.");
            }
            consensusMethods[i - 1] = consensusMethod;
        }
        this.consensusMethods = consensusMethods;
    }

    private void parsePublishedLine(String line, String[] parts) throws DescriptorParseException {
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseValidAfterLine(String line, String[] parts) throws DescriptorParseException {
        this.validAfterMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseFreshUntilLine(String line, String[] parts) throws DescriptorParseException {
        this.freshUntilMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseValidUntilLine(String line, String[] parts) throws DescriptorParseException {
        this.validUntilMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseVotingDelayLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        try {
            this.voteSeconds = Long.parseLong(parts[1]);
            this.distSeconds = Long.parseLong(parts[2]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal values in line '" + line + "'.");
        }
    }

    private void parseClientVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedClientVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseServerVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedServerVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseKnownFlagsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("No known flags in line '" + line + "'.");
        }
        String[] knownFlags = new String[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            knownFlags[i - 1] = parts[i];
        }
        this.knownFlags = knownFlags;
    }

    private void parseFlagThresholdsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("No flag thresholds in line '" + line + "'.");
        }
        SortedMap<String, String> flagThresholds = ParseHelper.parseKeyValueStringPairs(line, parts, 1, "=");
        try {
            for (Map.Entry<String, String> e : flagThresholds.entrySet()) {
                switch (e.getKey()) {
                    case "stable-uptime": {
                        this.stableUptime = Long.parseLong(e.getValue());
                        break;
                    }
                    case "stable-mtbf": {
                        this.stableMtbf = Long.parseLong(e.getValue());
                        break;
                    }
                    case "fast-speed": {
                        this.fastBandwidth = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-wfu": {
                        this.guardWfu = Double.parseDouble(e.getValue().replaceAll("%", ""));
                        break;
                    }
                    case "guard-tk": {
                        this.guardTk = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-bw-inc-exits": {
                        this.guardBandwidthIncludingExits = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-bw-exc-exits": {
                        this.guardBandwidthExcludingExits = Long.parseLong(e.getValue());
                        break;
                    }
                    case "enough-mtbf": {
                        this.enoughMtbfInfo = Integer.parseInt(e.getValue());
                        break;
                    }
                    case "ignoring-advertised-bws": {
                        this.ignoringAdvertisedBws = Integer.parseInt(e.getValue());
                        break;
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new DescriptorParseException("Illegal value in line '" + line + "'.");
        }
    }

    private void parseParamsLine(String line, String[] parts) throws DescriptorParseException {
        this.consensusParams = ParseHelper.parseKeyValueIntegerPairs(line, parts, 1, "=");
    }

    private void parseDirSourceLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 7) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.nickname = ParseHelper.parseNickname(line, parts[1]);
        this.identity = ParseHelper.parseTwentyByteHexString(line, parts[2]);
        if (parts[3].length() < 1) {
            throw new DescriptorParseException("Illegal hostname in '" + line + "'.");
        }
        this.address = ParseHelper.parseIpv4Address(line, parts[4]);
        this.dirPort = ParseHelper.parsePort(line, parts[5]);
        this.orPort = ParseHelper.parsePort(line, parts[6]);
    }

    private void parseContactLine(String line, String[] parts) throws DescriptorParseException {
        this.contactLine = line.length() > "contact ".length() ? line.substring("contact ".length()) : "";
    }

    private void parseDirKeyCertificateVersionLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        try {
            this.dirKeyCertificateVersion = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal dir key certificate version in line '" + line + "'.");
        }
        if (this.dirKeyCertificateVersion < 1) {
            throw new DescriptorParseException("Illegal dir key certificate version in line '" + line + "'.");
        }
    }

    private void parseDirAddressLine(String line, String[] parts) {
    }

    private void parseFingerprintLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parseLegacyDirKeyLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.legacyDirKey = ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parseDirKeyPublished(String line, String[] parts) throws DescriptorParseException {
        this.dirKeyPublishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseDirKeyExpiresLine(String line, String[] parts) throws DescriptorParseException {
        this.dirKeyExpiresMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    @Override
    protected void parseFooter(byte[] footerBytes) throws DescriptorParseException {
        Scanner s = new Scanner(new String(footerBytes)).useDelimiter("\n");
        while (s.hasNext()) {
            String line = s.next();
            if (line.equals("directory-footer")) continue;
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in vote.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getDirport() {
        return this.dirPort;
    }

    @Override
    public int getOrport() {
        return this.orPort;
    }

    @Override
    public String getContactLine() {
        return this.contactLine;
    }

    @Override
    public int getDirKeyCertificateVersion() {
        return this.dirKeyCertificateVersion;
    }

    @Override
    public String getLegacyDirKey() {
        return this.legacyDirKey;
    }

    @Override
    public long getDirKeyPublishedMillis() {
        return this.dirKeyPublishedMillis;
    }

    @Override
    public long getDirKeyExpiresMillis() {
        return this.dirKeyExpiresMillis;
    }

    @Override
    public String getSigningKeyDigest() {
        return this.signingKeyDigest;
    }

    @Override
    public int getNetworkStatusVersion() {
        return this.networkStatusVersion;
    }

    @Override
    public List<Integer> getConsensusMethods() {
        return Arrays.asList(this.consensusMethods);
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public long getValidAfterMillis() {
        return this.validAfterMillis;
    }

    @Override
    public long getFreshUntilMillis() {
        return this.freshUntilMillis;
    }

    @Override
    public long getValidUntilMillis() {
        return this.validUntilMillis;
    }

    @Override
    public long getVoteSeconds() {
        return this.voteSeconds;
    }

    @Override
    public long getDistSeconds() {
        return this.distSeconds;
    }

    @Override
    public List<String> getRecommendedClientVersions() {
        return this.recommendedClientVersions == null ? null : Arrays.asList(this.recommendedClientVersions);
    }

    @Override
    public List<String> getRecommendedServerVersions() {
        return this.recommendedServerVersions == null ? null : Arrays.asList(this.recommendedServerVersions);
    }

    @Override
    public SortedSet<String> getKnownFlags() {
        return new TreeSet<String>(Arrays.asList(this.knownFlags));
    }

    @Override
    public long getStableUptime() {
        return this.stableUptime;
    }

    @Override
    public long getStableMtbf() {
        return this.stableMtbf;
    }

    @Override
    public long getFastBandwidth() {
        return this.fastBandwidth;
    }

    @Override
    public double getGuardWfu() {
        return this.guardWfu;
    }

    @Override
    public long getGuardTk() {
        return this.guardTk;
    }

    @Override
    public long getGuardBandwidthIncludingExits() {
        return this.guardBandwidthIncludingExits;
    }

    @Override
    public long getGuardBandwidthExcludingExits() {
        return this.guardBandwidthExcludingExits;
    }

    @Override
    public int getEnoughMtbfInfo() {
        return this.enoughMtbfInfo;
    }

    @Override
    public int getIgnoringAdvertisedBws() {
        return this.ignoringAdvertisedBws;
    }

    @Override
    public SortedMap<String, Integer> getConsensusParams() {
        return this.consensusParams == null ? null : new TreeMap<String, Integer>(this.consensusParams);
    }
}

