/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.impl.DescriptorImpl;
import org.torproject.descriptor.impl.NetworkStatusEntryImpl;
import org.torproject.descriptor.impl.NetworkStatusImpl;
import org.torproject.descriptor.impl.ParseHelper;

public class RelayNetworkStatusConsensusImpl
extends NetworkStatusImpl
implements RelayNetworkStatusConsensus {
    private boolean microdescConsensus = false;
    private String consensusDigest;
    private int networkStatusVersion;
    private String consensusFlavor;
    private int consensusMethod;
    private long validAfterMillis;
    private long freshUntilMillis;
    private long validUntilMillis;
    private long voteSeconds;
    private long distSeconds;
    private String[] recommendedClientVersions;
    private String[] recommendedServerVersions;
    private String[] knownFlags;
    private SortedMap<String, Integer> consensusParams;
    private SortedMap<String, Integer> bandwidthWeights;

    protected static List<RelayNetworkStatusConsensus> parseConsensuses(byte[] consensusesBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        ArrayList<RelayNetworkStatusConsensus> parsedConsensuses = new ArrayList<RelayNetworkStatusConsensus>();
        List<byte[]> splitConsensusBytes = DescriptorImpl.splitRawDescriptorBytes(consensusesBytes, "network-status-version 3");
        for (byte[] consensusBytes : splitConsensusBytes) {
            RelayNetworkStatusConsensusImpl parsedConsensus = new RelayNetworkStatusConsensusImpl(consensusBytes, failUnrecognizedDescriptorLines);
            parsedConsensuses.add(parsedConsensus);
        }
        return parsedConsensuses;
    }

    protected RelayNetworkStatusConsensusImpl(byte[] consensusBytes, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        super(consensusBytes, failUnrecognizedDescriptorLines, true, false);
        HashSet<String> exactlyOnceKeywords = new HashSet<String>(Arrays.asList("vote-status,consensus-method,valid-after,fresh-until,valid-until,voting-delay,known-flags".split(",")));
        this.checkExactlyOnceKeywords(exactlyOnceKeywords);
        HashSet<String> atMostOnceKeywords = new HashSet<String>(Arrays.asList("client-versions,server-versions,params,directory-footer,bandwidth-weights".split(",")));
        this.checkAtMostOnceKeywords(atMostOnceKeywords);
        this.checkFirstKeyword("network-status-version");
        this.clearParsedKeywords();
        this.calculateDigest();
    }

    private void calculateDigest() throws DescriptorParseException {
        try {
            String ascii = new String(this.getRawDescriptorBytes(), "US-ASCII");
            String startToken = "network-status-version ";
            String sigToken = "\ndirectory-signature ";
            if (!ascii.contains(sigToken)) {
                return;
            }
            int start = ascii.indexOf(startToken);
            int sig = ascii.indexOf(sigToken) + sigToken.length();
            if (start >= 0 && sig >= 0 && sig > start) {
                byte[] forDigest = new byte[sig - start];
                System.arraycopy(this.getRawDescriptorBytes(), start, forDigest, 0, sig - start);
                this.consensusDigest = DatatypeConverter.printHexBinary((byte[])MessageDigest.getInstance("SHA-1").digest(forDigest)).toLowerCase();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (this.consensusDigest == null) {
            throw new DescriptorParseException("Could not calculate consensus digest.");
        }
    }

    @Override
    protected void parseHeader(byte[] headerBytes) throws DescriptorParseException {
        Scanner s = new Scanner(new String(headerBytes)).useDelimiter("\n");
        block26: while (s.hasNext()) {
            String keyword;
            String line = s.next();
            String[] parts = line.split("[ \t]+");
            switch (keyword = parts[0]) {
                case "network-status-version": {
                    this.parseNetworkStatusVersionLine(line, parts);
                    continue block26;
                }
                case "vote-status": {
                    this.parseVoteStatusLine(line, parts);
                    continue block26;
                }
                case "consensus-method": {
                    this.parseConsensusMethodLine(line, parts);
                    continue block26;
                }
                case "valid-after": {
                    this.parseValidAfterLine(line, parts);
                    continue block26;
                }
                case "fresh-until": {
                    this.parseFreshUntilLine(line, parts);
                    continue block26;
                }
                case "valid-until": {
                    this.parseValidUntilLine(line, parts);
                    continue block26;
                }
                case "voting-delay": {
                    this.parseVotingDelayLine(line, parts);
                    continue block26;
                }
                case "client-versions": {
                    this.parseClientVersionsLine(line, parts);
                    continue block26;
                }
                case "server-versions": {
                    this.parseServerVersionsLine(line, parts);
                    continue block26;
                }
                case "known-flags": {
                    this.parseKnownFlagsLine(line, parts);
                    continue block26;
                }
                case "params": {
                    this.parseParamsLine(line, parts);
                    continue block26;
                }
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in consensus.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    @Override
    protected void parseStatusEntry(byte[] statusEntryBytes) throws DescriptorParseException {
        NetworkStatusEntryImpl statusEntry = new NetworkStatusEntryImpl(statusEntryBytes, this.microdescConsensus, this.failUnrecognizedDescriptorLines);
        this.statusEntries.put(statusEntry.getFingerprint(), statusEntry);
        List<String> unrecognizedStatusEntryLines = statusEntry.getAndClearUnrecognizedLines();
        if (unrecognizedStatusEntryLines != null) {
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.addAll(unrecognizedStatusEntryLines);
        }
    }

    @Override
    protected void parseFooter(byte[] footerBytes) throws DescriptorParseException {
        Scanner s = new Scanner(new String(footerBytes)).useDelimiter("\n");
        block8: while (s.hasNext()) {
            String keyword;
            String line = s.next();
            String[] parts = line.split("[ \t]+");
            switch (keyword = parts[0]) {
                case "directory-footer": {
                    continue block8;
                }
                case "bandwidth-weights": {
                    this.parseBandwidthWeightsLine(line, parts);
                    continue block8;
                }
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in consensus.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseNetworkStatusVersionLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.startsWith("network-status-version 3")) {
            throw new DescriptorParseException("Illegal network status version number in line '" + line + "'.");
        }
        this.networkStatusVersion = 3;
        if (parts.length == 3) {
            this.consensusFlavor = parts[2];
            if (this.consensusFlavor.equals("microdesc")) {
                this.microdescConsensus = true;
            }
        } else if (parts.length != 2) {
            throw new DescriptorParseException("Illegal network status version line '" + line + "'.");
        }
    }

    private void parseVoteStatusLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2 || !parts[1].equals("consensus")) {
            throw new DescriptorParseException("Line '" + line + "' indicates " + "that this is not a consensus.");
        }
    }

    private void parseConsensusMethodLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in consensus.");
        }
        try {
            this.consensusMethod = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal consensus method number in line '" + line + "'.");
        }
        if (this.consensusMethod < 1) {
            throw new DescriptorParseException("Illegal consensus method number in line '" + line + "'.");
        }
    }

    private void parseValidAfterLine(String line, String[] parts) throws DescriptorParseException {
        this.validAfterMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseFreshUntilLine(String line, String[] parts) throws DescriptorParseException {
        this.freshUntilMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseValidUntilLine(String line, String[] parts) throws DescriptorParseException {
        this.validUntilMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseVotingDelayLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        try {
            this.voteSeconds = Long.parseLong(parts[1]);
            this.distSeconds = Long.parseLong(parts[2]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal values in line '" + line + "'.");
        }
    }

    private void parseClientVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedClientVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseServerVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedServerVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseKnownFlagsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("No known flags in line '" + line + "'.");
        }
        String[] knownFlags = new String[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            knownFlags[i - 1] = parts[i];
        }
        this.knownFlags = knownFlags;
    }

    private void parseParamsLine(String line, String[] parts) throws DescriptorParseException {
        this.consensusParams = ParseHelper.parseKeyValueIntegerPairs(line, parts, 1, "=");
    }

    private void parseBandwidthWeightsLine(String line, String[] parts) throws DescriptorParseException {
        this.bandwidthWeights = ParseHelper.parseKeyValueIntegerPairs(line, parts, 1, "=");
    }

    @Override
    public String getConsensusDigest() {
        return this.consensusDigest;
    }

    @Override
    public int getNetworkStatusVersion() {
        return this.networkStatusVersion;
    }

    @Override
    public String getConsensusFlavor() {
        return this.consensusFlavor;
    }

    @Override
    public int getConsensusMethod() {
        return this.consensusMethod;
    }

    @Override
    public long getValidAfterMillis() {
        return this.validAfterMillis;
    }

    @Override
    public long getFreshUntilMillis() {
        return this.freshUntilMillis;
    }

    @Override
    public long getValidUntilMillis() {
        return this.validUntilMillis;
    }

    @Override
    public long getVoteSeconds() {
        return this.voteSeconds;
    }

    @Override
    public long getDistSeconds() {
        return this.distSeconds;
    }

    @Override
    public List<String> getRecommendedClientVersions() {
        return this.recommendedClientVersions == null ? null : Arrays.asList(this.recommendedClientVersions);
    }

    @Override
    public List<String> getRecommendedServerVersions() {
        return this.recommendedServerVersions == null ? null : Arrays.asList(this.recommendedServerVersions);
    }

    @Override
    public SortedSet<String> getKnownFlags() {
        return new TreeSet<String>(Arrays.asList(this.knownFlags));
    }

    @Override
    public SortedMap<String, Integer> getConsensusParams() {
        return this.consensusParams == null ? null : new TreeMap<String, Integer>(this.consensusParams);
    }

    @Override
    public SortedMap<String, Integer> getBandwidthWeights() {
        return this.bandwidthWeights == null ? null : new TreeMap<String, Integer>(this.bandwidthWeights);
    }
}

