/*
 * Decompiled with CFR 0.152.
 */
package groovy.json.internal;

import groovy.json.internal.ArrayUtils;
import groovy.json.internal.CharScanner;
import groovy.json.internal.CharacterSource;
import groovy.json.internal.Chr;
import groovy.json.internal.Exceptions;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class ReaderCharacterSource
implements CharacterSource {
    private static final int MAX_TOKEN_SIZE = 5;
    private final Reader reader;
    private int readAheadSize;
    private int ch = -2;
    private boolean foundEscape;
    private char[] readBuf;
    private int index;
    private int length;
    boolean more = true;
    private boolean done = false;
    private final char[] EMPTY_CHARS = new char[0];

    public ReaderCharacterSource(Reader reader, int readAheadSize) {
        this.reader = reader;
        this.readBuf = new char[readAheadSize + 5];
        this.readAheadSize = readAheadSize;
    }

    public ReaderCharacterSource(Reader reader) {
        this.reader = reader;
        this.readAheadSize = 10000;
        this.readBuf = new char[this.readAheadSize + 5];
    }

    public ReaderCharacterSource(String string) {
        this(new StringReader(string));
    }

    private void readForToken() {
        try {
            this.length += this.reader.read(this.readBuf, this.readBuf.length - 5, 5);
        }
        catch (IOException e) {
            Exceptions.handle(e);
        }
    }

    private void ensureBuffer() {
        try {
            if (this.index >= this.length && !this.done) {
                this.readNextBuffer();
            } else {
                this.more = !this.done || this.index < this.length;
            }
        }
        catch (Exception ex) {
            String str = CharScanner.errorDetails("ensureBuffer issue", this.readBuf, this.index, this.ch);
            Exceptions.handle(str, (Throwable)ex);
        }
    }

    private void readNextBuffer() throws IOException {
        this.length = this.reader.read(this.readBuf, 0, this.readAheadSize);
        this.index = 0;
        if (this.length == -1) {
            this.ch = -1;
            this.length = 0;
            this.more = false;
            this.done = true;
        } else {
            this.more = true;
        }
    }

    @Override
    public final int nextChar() {
        this.ensureBuffer();
        this.ch = this.readBuf[this.index++];
        return this.ch;
    }

    @Override
    public final int currentChar() {
        this.ensureBuffer();
        return this.readBuf[this.index];
    }

    @Override
    public final boolean hasChar() {
        this.ensureBuffer();
        return this.more;
    }

    @Override
    public final boolean consumeIfMatch(char[] match) {
        try {
            char[] _chars = this.readBuf;
            int i = 0;
            int idx = this.index;
            boolean ok = true;
            if (idx + match.length > this.length) {
                this.readForToken();
            }
            while (i < match.length && (ok &= match[i] == _chars[idx])) {
                ++i;
                ++idx;
            }
            if (ok) {
                this.index = idx;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            String str = CharScanner.errorDetails("consumeIfMatch issue", this.readBuf, this.index, this.ch);
            return Exceptions.handle(Boolean.TYPE, str, ex);
        }
    }

    @Override
    public final int location() {
        return this.index;
    }

    @Override
    public final int safeNextChar() {
        try {
            this.ensureBuffer();
            return this.index + 1 < this.readBuf.length ? this.readBuf[this.index++] : -1;
        }
        catch (Exception ex) {
            String str = CharScanner.errorDetails("safeNextChar issue", this.readBuf, this.index, this.ch);
            return Exceptions.handle(Integer.TYPE, str, ex);
        }
    }

    @Override
    public char[] findNextChar(int match, int esc) {
        try {
            this.ensureBuffer();
            int idx = this.index;
            char[] _chars = this.readBuf;
            int ch = this.ch;
            if (ch != 34 && idx < this.length - 1 && (ch = _chars[idx]) == 34) {
                ++idx;
            }
            if (idx < this.length) {
                ch = _chars[idx];
            }
            if (ch == 34) {
                this.index = idx;
                ++this.index;
                return this.EMPTY_CHARS;
            }
            int start = idx;
            this.foundEscape = false;
            boolean foundEnd = false;
            while (idx < this.length) {
                ch = _chars[idx];
                if (ch == match || ch == esc) {
                    if (ch == match) {
                        foundEnd = true;
                        break;
                    }
                    if (ch == esc) {
                        this.foundEscape = true;
                        if (idx + 1 < this.length) {
                            ++idx;
                        }
                    }
                }
                ++idx;
            }
            char[] results = idx == 0 ? this.EMPTY_CHARS : ArrayUtils.copyRange(_chars, start, idx);
            this.index = idx;
            if (foundEnd) {
                ++this.index;
                if (this.index < this.length) {
                    this.ch = ch = _chars[this.index];
                }
                return results;
            }
            if (this.index >= this.length && !this.done) {
                this.ensureBuffer();
                char[] results2 = this.findNextChar(match, esc);
                return Chr.add(results, results2);
            }
            return Exceptions.die(char[].class, "Unable to find close char " + (char)match + " " + new String(results));
        }
        catch (Exception ex) {
            String str = CharScanner.errorDetails("findNextChar issue", this.readBuf, this.index, this.ch);
            return Exceptions.handle(char[].class, str, ex);
        }
    }

    @Override
    public boolean hadEscape() {
        return this.foundEscape;
    }

    @Override
    public void skipWhiteSpace() {
        try {
            this.index = CharScanner.skipWhiteSpace(this.readBuf, this.index, this.length);
            if (this.index >= this.length && this.more) {
                this.ensureBuffer();
                this.skipWhiteSpace();
            }
        }
        catch (Exception ex) {
            String str = CharScanner.errorDetails("skipWhiteSpace issue", this.readBuf, this.index, this.ch);
            Exceptions.handle(str, (Throwable)ex);
        }
    }

    @Override
    public char[] readNumber() {
        try {
            this.ensureBuffer();
            char[] results = CharScanner.readNumber(this.readBuf, this.index, this.length);
            this.index += results.length;
            if (this.index >= this.length && this.more) {
                this.ensureBuffer();
                if (this.length != 0) {
                    char[] results2 = this.readNumber();
                    return Chr.add(results, results2);
                }
                return results;
            }
            return results;
        }
        catch (Exception ex) {
            String str = CharScanner.errorDetails("readNumber issue", this.readBuf, this.index, this.ch);
            return Exceptions.handle(char[].class, str, ex);
        }
    }

    @Override
    public String errorDetails(String message) {
        return CharScanner.errorDetails(message, this.readBuf, this.index, this.ch);
    }
}

