/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingSupport;

public class CastExpressionOptimizer {
    private final StaticCompilationTransformer transformer;

    public CastExpressionOptimizer(StaticCompilationTransformer staticCompilationTransformer) {
        this.transformer = staticCompilationTransformer;
    }

    public Expression transformCastExpression(CastExpression cast) {
        if (cast.isCoerce()) {
            Expression expression = cast.getExpression();
            ClassNode exprInferredType = this.transformer.getTypeChooser().resolveType(expression, this.transformer.getClassNode());
            ClassNode castType = cast.getType();
            if (castType.isArray() && expression instanceof ListExpression) {
                ArrayExpression arrayExpression = new ArrayExpression(castType.getComponentType(), ((ListExpression)expression).getExpressions());
                arrayExpression.setSourcePosition(cast);
                return this.transformer.transform(arrayExpression);
            }
            if (this.isOptimizable(exprInferredType, castType)) {
                CastExpression trn = new CastExpression(castType, this.transformer.transform(expression));
                trn.setSourcePosition(cast);
                trn.copyNodeMetaData(cast);
                return trn;
            }
        }
        return this.transformer.superTransform(cast);
    }

    private boolean isOptimizable(ClassNode exprInferredType, ClassNode castType) {
        if (StaticTypeCheckingSupport.implementsInterfaceOrIsSubclassOf(exprInferredType, castType)) {
            return true;
        }
        return ClassHelper.isPrimitiveType(exprInferredType) && ClassHelper.isPrimitiveType(castType);
    }
}

