/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.lang.annotation.Annotation;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.annotation.MultipartConfig;
import org.eclipse.jetty.annotations.AnnotationIntrospector;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class MultiPartConfigAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    protected WebAppContext _context;

    public MultiPartConfigAnnotationHandler(WebAppContext context) {
        super(false);
        this._context = context;
    }

    public void doHandle(Class clazz) {
        Descriptor d;
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        MultipartConfig multi = clazz.getAnnotation(MultipartConfig.class);
        if (multi == null) {
            return;
        }
        MetaData metaData = this._context.getMetaData();
        ServletHolder holder = this.getServletHolderForClass(clazz);
        if (holder != null && (d = metaData.getOriginDescriptor(holder.getName() + ".servlet.multipart-config")) == null) {
            metaData.setOrigin(holder.getName() + ".servlet.multipart-config", (Annotation)multi, clazz);
            holder.getRegistration().setMultipartConfig(new MultipartConfigElement(multi));
        }
    }

    private ServletHolder getServletHolderForClass(Class clazz) {
        ServletHolder holder = null;
        ServletHolder[] holders = this._context.getServletHandler().getServlets();
        if (holders != null) {
            for (ServletHolder h : holders) {
                if (h.getClassName() == null || !h.getClassName().equals(clazz.getName())) continue;
                holder = h;
            }
        }
        return holder;
    }
}

