/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.exonerator;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.io.Reader;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResponse {
    private static final Logger logger = LoggerFactory.getLogger(QueryResponse.class);
    private static final String VERSION = "1.0";
    private static final String FIRSTRECOGNIZEDVERSION = "1.0";
    private static final String FIRSTUNRECOGNIZEDVERSION = "2.0";
    private static ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    String version = "1.0";
    String queryAddress;
    String queryDate;
    String firstDateInDatabase;
    String lastDateInDatabase;
    Boolean relevantStatuses;
    Match[] matches;
    String[] nearbyAddresses;

    public QueryResponse() {
    }

    QueryResponse(String version, String queryAddress, String queryDate, String firstDateInDatabase, String lastDateInDatabase, Boolean relevantStatuses, Match[] matches, String[] nearbyAddresses) {
        this.version = version;
        this.queryAddress = queryAddress;
        this.queryDate = queryDate;
        this.firstDateInDatabase = firstDateInDatabase;
        this.lastDateInDatabase = lastDateInDatabase;
        this.relevantStatuses = relevantStatuses;
        this.matches = matches;
        this.nearbyAddresses = nearbyAddresses;
    }

    public static String toJson(QueryResponse response) throws IOException {
        return objectMapper.writeValueAsString((Object)response);
    }

    public static QueryResponse fromJson(Reader reader) {
        try {
            QueryResponse response = (QueryResponse)objectMapper.readValue(reader, QueryResponse.class);
            if (null == response || null == response.version) {
                logger.warn("Response is either empty or does not contain version information.");
                return null;
            }
            if (response.version.compareTo("1.0") < 0 || response.version.compareTo(FIRSTUNRECOGNIZEDVERSION) >= 0) {
                logger.error("Response has version {}, which is not in the range of versions we can handle: {} <= x < {}).", new Object[]{response.version, "1.0", FIRSTUNRECOGNIZEDVERSION});
                return null;
            }
            return response;
        }
        catch (IOException | RuntimeException e) {
            logger.error("JSON decoding failed.", (Throwable)e);
            return null;
        }
    }

    static class Match {
        String timestamp;
        SortedSet<String> addresses;
        String fingerprint;
        String nickname;
        Boolean exit;

        public Match() {
        }

        Match(String timestamp, SortedSet<String> addresses, String fingerprint, String nickname, Boolean exit) {
            this.timestamp = timestamp;
            this.addresses = addresses;
            this.fingerprint = fingerprint;
            this.nickname = nickname;
            this.exit = exit;
        }
    }
}

