/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.exonerator;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

class ExoneraTorDate {
    public static final ExoneraTorDate INVALID = new ExoneraTorDate("");
    private static final int DATELENGTH = "yyyy-mm-dd".length();
    final boolean empty;
    final boolean valid;
    final String asString;
    final LocalDate date;
    final String asRequested;
    final boolean tooRecent;

    ExoneraTorDate(String parameter) {
        this.asRequested = parameter;
        this.empty = null == parameter || parameter.trim().isEmpty();
        this.date = this.empty ? null : ExoneraTorDate.parseDatestamp(parameter);
        this.valid = null != this.date;
        this.asString = this.valid ? this.date.format(DateTimeFormatter.ISO_LOCAL_DATE) : "";
        this.tooRecent = this.valid && this.date.isAfter(LocalDate.now(ZoneOffset.UTC).minusDays(2L));
    }

    private static LocalDate parseDatestamp(String datestamp) {
        String trimmedDatestamp = datestamp.replaceAll("\\s", "");
        if (trimmedDatestamp.length() >= DATELENGTH) {
            try {
                return LocalDate.parse(trimmedDatestamp.substring(0, DATELENGTH), DateTimeFormatter.ISO_LOCAL_DATE);
            }
            catch (DateTimeParseException e) {
                return null;
            }
        }
        return null;
    }
}

