/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.LineSet;

public class MethodCallHandler
extends AbstractExpressionHandler {
    public MethodCallHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "method call", ast, parent);
    }

    @Override
    protected IndentLevel getIndentImpl() {
        IndentLevel indentLevel;
        if (this.getParent() instanceof MethodCallHandler) {
            MethodCallHandler container = (MethodCallHandler)this.getParent();
            indentLevel = MethodCallHandler.areOnSameLine(container.getMainAst(), this.getMainAst()) || this.isChainedMethodCallWrapped() ? container.getIndent() : new IndentLevel(container.getIndent(), this.getBasicOffset());
        } else {
            LineSet lines = new LineSet();
            this.findSubtreeLines(lines, this.getMainAst().getFirstChild(), true);
            int firstCol = lines.firstLineCol();
            int lineStart = this.getLineStart(MethodCallHandler.getFirstAst(this.getMainAst()));
            indentLevel = lineStart == firstCol ? super.getIndentImpl() : new IndentLevel(lineStart);
        }
        return indentLevel;
    }

    private boolean isChainedMethodCallWrapped() {
        boolean result = false;
        DetailAST main = this.getMainAst();
        DetailAST dot = main.getFirstChild();
        DetailAST target = dot.getFirstChild();
        DetailAST dot1 = target.getFirstChild();
        DetailAST target1 = dot1.getFirstChild();
        if (dot1.getType() == 59 && target1.getType() == 27) {
            result = true;
        }
        return result;
    }

    private static DetailAST getFirstAst(DetailAST ast) {
        DetailAST astNode = ast.getFirstChild();
        while (astNode.getType() == 59) {
            astNode = astNode.getFirstChild();
        }
        return astNode;
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        DetailAST rparen;
        DetailAST first = this.getMainAst().getFirstChild();
        IndentLevel suggestedLevel = new IndentLevel(this.getLineStart(first));
        if (!MethodCallHandler.areOnSameLine(child.getMainAst().getFirstChild(), this.getMainAst().getFirstChild())) {
            suggestedLevel = new IndentLevel(suggestedLevel, this.getBasicOffset(), this.getIndentCheck().getLineWrappingIndentation());
        }
        if (this.getLineStart(rparen = this.getMainAst().findFirstToken(77)) == rparen.getColumnNo()) {
            suggestedLevel.addAcceptedIndent(new IndentLevel(this.getParent().getSuggestedChildIndent(this), this.getIndentCheck().getLineWrappingIndentation()));
        }
        return suggestedLevel;
    }

    @Override
    public void checkIndentation() {
        DetailAST exprNode = this.getMainAst().getParent();
        if (exprNode.getParent().getType() != 7) {
            return;
        }
        DetailAST methodName = this.getMainAst().getFirstChild();
        this.checkExpressionSubtree(methodName, this.getIndent(), false, false);
        DetailAST lparen = this.getMainAst();
        DetailAST rparen = this.getMainAst().findFirstToken(77);
        this.checkLParen(lparen);
        if (rparen.getLineNo() == lparen.getLineNo()) {
            return;
        }
        this.checkExpressionSubtree(this.getMainAst().findFirstToken(34), new IndentLevel(this.getIndent(), this.getBasicOffset()), false, true);
        this.checkRParen(lparen, rparen);
        this.checkWrappingIndentation(this.getMainAst(), MethodCallHandler.getMethodCallLastNode(this.getMainAst()));
    }

    @Override
    protected boolean shouldIncreaseIndent() {
        return false;
    }

    private static DetailAST getMethodCallLastNode(DetailAST firstNode) {
        return firstNode.getLastChild();
    }
}

