/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.AbstractParenPadCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Arrays;

public class ParenPadCheck
extends AbstractParenPadCheck {
    private final int[] acceptableTokens = ParenPadCheck.makeAcceptableTokens();

    public ParenPadCheck() {
        Arrays.sort(this.acceptableTokens);
    }

    @Override
    public int[] getDefaultTokens() {
        return ParenPadCheck.makeAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return ParenPadCheck.makeAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 27: {
                this.processLeft(ast);
                this.processRight(ast.findFirstToken(77));
                this.processExpression(ast);
                break;
            }
            case 28: 
            case 109: {
                this.processExpression(ast);
                break;
            }
            case 91: {
                this.visitLiteralFor(ast);
                break;
            }
            case 67: 
            case 136: 
            case 155: 
            case 159: {
                this.visitNewEnumConstDefAnnotationSync(ast);
                break;
            }
            default: {
                this.processLeft(ast.findFirstToken(76));
                this.processRight(ast.findFirstToken(77));
            }
        }
    }

    private void visitNewEnumConstDefAnnotationSync(DetailAST ast) {
        DetailAST parenAst = ast.findFirstToken(76);
        if (parenAst != null) {
            this.processLeft(parenAst);
            this.processRight(ast.findFirstToken(77));
        }
    }

    private void visitLiteralFor(DetailAST ast) {
        DetailAST rparen;
        DetailAST lparen = ast.findFirstToken(76);
        if (!ParenPadCheck.isPrecedingEmptyForInit(lparen)) {
            this.processLeft(lparen);
        }
        if (!ParenPadCheck.isFollowsEmptyForIterator(rparen = ast.findFirstToken(77))) {
            this.processRight(rparen);
        }
    }

    private void processExpression(DetailAST ast) {
        if (ast.branchContains(76)) {
            for (DetailAST childAst = ast.getFirstChild(); childAst != null; childAst = childAst.getNextSibling()) {
                if (childAst.getType() == 76) {
                    this.processLeft(childAst);
                    this.processExpression(childAst);
                    continue;
                }
                if (childAst.getType() == 77 && !ParenPadCheck.isInTypecast(childAst)) {
                    this.processRight(childAst);
                    continue;
                }
                if (this.isAcceptableToken(childAst)) continue;
                this.processExpression(childAst);
            }
        }
    }

    private boolean isAcceptableToken(DetailAST ast) {
        boolean result = false;
        if (Arrays.binarySearch(this.acceptableTokens, ast.getType()) >= 0) {
            result = true;
        }
        return result;
    }

    private static int[] makeAcceptableTokens() {
        return new int[]{159, 161, 43, 8, 155, 28, 96, 85, 91, 83, 136, 89, 67, 84, 27, 9, 109, 176, 42};
    }

    private static boolean isInTypecast(DetailAST ast) {
        DetailAST firstRparen;
        boolean result = false;
        if (ast.getParent().getType() == 23 && (firstRparen = ast.getParent().findFirstToken(77)).getLineNo() == ast.getLineNo() && firstRparen.getColumnNo() == ast.getColumnNo()) {
            result = true;
        }
        return result;
    }

    private static boolean isFollowsEmptyForIterator(DetailAST ast) {
        boolean result = false;
        DetailAST parent = ast.getParent();
        if (parent.findFirstToken(156) == null) {
            DetailAST forIterator = parent.findFirstToken(37);
            result = forIterator.getChildCount() == 0;
        }
        return result;
    }

    private static boolean isPrecedingEmptyForInit(DetailAST ast) {
        boolean result = false;
        DetailAST parent = ast.getParent();
        if (parent.findFirstToken(156) == null) {
            DetailAST forIterator = parent.findFirstToken(35);
            result = forIterator.getChildCount() == 0;
        }
        return result;
    }
}

