/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.impl.TorperfResultImpl;

public class TorperfResultImplTest {
    private static long[] deciles = new long[]{1441065602980L, 1441065603030L, 1441065603090L, 1441065603120L, 1441065603230L, 1441065603250L, 1441065603310L, 1441065603370L, 1441065603370L};
    private static final String torperfAnnotation = "@type torperf 1.0\n";
    private static final String input = "BUILDTIMES=0.872834920883,1.09103679657,1.49180984497 CIRC_ID=1228 CONNECT=1441065601.86 DATACOMPLETE=1441065603.39 DATAPERC10=1441065602.98 DATAPERC20=1441065603.03 DATAPERC30=1441065603.09 DATAPERC40=1441065603.12 DATAPERC50=1441065603.23 DATAPERC60=1441065603.25 DATAPERC70=1441065603.31 DATAPERC80=1441065603.37 DATAPERC90=1441065603.37 DATAREQUEST=1441065602.38 DATARESPONSE=1441065602.84 DIDTIMEOUT=0 FILESIZE=51200 LAUNCH=1441065361.30 NEGOTIATE=1441065601.86 PATH=$C4C9C332D25B3546BEF4E1250CF410E97EF996E6,$C43FA6474A9F071E9120DF63ED6EB8FDBA105234,$7C0AA4E3B73E407E9F5FEB1912F8BE26D8AA124D QUANTILE=0.800000 READBYTES=51416 REQUEST=1441065601.86 RESPONSE=1441065602.38 SOCKET=1441065601.86 SOURCE=moria START=1441065601.86 TIMEOUT=1500 USED_AT=1441065603.40 USED_BY=2475 WRITEBYTES=75\n";

    @Test
    public void testAnnotatedInput() throws Exception {
        TorperfResultImpl result = (TorperfResultImpl)TorperfResultImpl.parseTorperfResults("@type torperf 1.0\nBUILDTIMES=0.872834920883,1.09103679657,1.49180984497 CIRC_ID=1228 CONNECT=1441065601.86 DATACOMPLETE=1441065603.39 DATAPERC10=1441065602.98 DATAPERC20=1441065603.03 DATAPERC30=1441065603.09 DATAPERC40=1441065603.12 DATAPERC50=1441065603.23 DATAPERC60=1441065603.25 DATAPERC70=1441065603.31 DATAPERC80=1441065603.37 DATAPERC90=1441065603.37 DATAREQUEST=1441065602.38 DATARESPONSE=1441065602.84 DIDTIMEOUT=0 FILESIZE=51200 LAUNCH=1441065361.30 NEGOTIATE=1441065601.86 PATH=$C4C9C332D25B3546BEF4E1250CF410E97EF996E6,$C43FA6474A9F071E9120DF63ED6EB8FDBA105234,$7C0AA4E3B73E407E9F5FEB1912F8BE26D8AA124D QUANTILE=0.800000 READBYTES=51416 REQUEST=1441065601.86 RESPONSE=1441065602.38 SOCKET=1441065601.86 SOURCE=moria START=1441065601.86 TIMEOUT=1500 USED_AT=1441065603.40 USED_BY=2475 WRITEBYTES=75\n".getBytes("US-ASCII"), false).get(0);
        Assert.assertEquals((String)"Expected one annotation.", (long)1L, (long)result.getAnnotations().size());
        Assert.assertEquals((Object)torperfAnnotation.substring(0, 17), (Object)result.getAnnotations().get(0));
        int count = 0;
        for (Long l : result.getDataPercentiles().values()) {
            Assert.assertNotNull((Object)l);
            Assert.assertEquals((long)l, (long)deciles[count++]);
        }
    }

    @Test
    public void testPartiallyAnnotatedInput() throws Exception {
        byte[] asciiBytes = "@type torperf 1.0\nBUILDTIMES=0.872834920883,1.09103679657,1.49180984497 CIRC_ID=1228 CONNECT=1441065601.86 DATACOMPLETE=1441065603.39 DATAPERC10=1441065602.98 DATAPERC20=1441065603.03 DATAPERC30=1441065603.09 DATAPERC40=1441065603.12 DATAPERC50=1441065603.23 DATAPERC60=1441065603.25 DATAPERC70=1441065603.31 DATAPERC80=1441065603.37 DATAPERC90=1441065603.37 DATAREQUEST=1441065602.38 DATARESPONSE=1441065602.84 DIDTIMEOUT=0 FILESIZE=51200 LAUNCH=1441065361.30 NEGOTIATE=1441065601.86 PATH=$C4C9C332D25B3546BEF4E1250CF410E97EF996E6,$C43FA6474A9F071E9120DF63ED6EB8FDBA105234,$7C0AA4E3B73E407E9F5FEB1912F8BE26D8AA124D QUANTILE=0.800000 READBYTES=51416 REQUEST=1441065601.86 RESPONSE=1441065602.38 SOCKET=1441065601.86 SOURCE=moria START=1441065601.86 TIMEOUT=1500 USED_AT=1441065603.40 USED_BY=2475 WRITEBYTES=75\nBUILDTIMES=0.872834920883,1.09103679657,1.49180984497 CIRC_ID=1228 CONNECT=1441065601.86 DATACOMPLETE=1441065603.39 DATAPERC10=1441065602.98 DATAPERC20=1441065603.03 DATAPERC30=1441065603.09 DATAPERC40=1441065603.12 DATAPERC50=1441065603.23 DATAPERC60=1441065603.25 DATAPERC70=1441065603.31 DATAPERC80=1441065603.37 DATAPERC90=1441065603.37 DATAREQUEST=1441065602.38 DATARESPONSE=1441065602.84 DIDTIMEOUT=0 FILESIZE=51200 LAUNCH=1441065361.30 NEGOTIATE=1441065601.86 PATH=$C4C9C332D25B3546BEF4E1250CF410E97EF996E6,$C43FA6474A9F071E9120DF63ED6EB8FDBA105234,$7C0AA4E3B73E407E9F5FEB1912F8BE26D8AA124D QUANTILE=0.800000 READBYTES=51416 REQUEST=1441065601.86 RESPONSE=1441065602.38 SOCKET=1441065601.86 SOURCE=moria START=1441065601.86 TIMEOUT=1500 USED_AT=1441065603.40 USED_BY=2475 WRITEBYTES=75\nBUILDTIMES=0.872834920883,1.09103679657,1.49180984497 CIRC_ID=1228 CONNECT=1441065601.86 DATACOMPLETE=1441065603.39 DATAPERC10=1441065602.98 DATAPERC20=1441065603.03 DATAPERC30=1441065603.09 DATAPERC40=1441065603.12 DATAPERC50=1441065603.23 DATAPERC60=1441065603.25 DATAPERC70=1441065603.31 DATAPERC80=1441065603.37 DATAPERC90=1441065603.37 DATAREQUEST=1441065602.38 DATARESPONSE=1441065602.84 DIDTIMEOUT=0 FILESIZE=51200 LAUNCH=1441065361.30 NEGOTIATE=1441065601.86 PATH=$C4C9C332D25B3546BEF4E1250CF410E97EF996E6,$C43FA6474A9F071E9120DF63ED6EB8FDBA105234,$7C0AA4E3B73E407E9F5FEB1912F8BE26D8AA124D QUANTILE=0.800000 READBYTES=51416 REQUEST=1441065601.86 RESPONSE=1441065602.38 SOCKET=1441065601.86 SOURCE=moria START=1441065601.86 TIMEOUT=1500 USED_AT=1441065603.40 USED_BY=2475 WRITEBYTES=75\n".getBytes("US-ASCII");
        List<Descriptor> result = TorperfResultImpl.parseTorperfResults(asciiBytes, false);
        Assert.assertEquals((String)"Expected one annotation.", (long)1L, (long)((TorperfResultImpl)result.get(0)).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((String)"Expected zero annotations.", (long)0L, (long)((TorperfResultImpl)result.get(1)).getAnnotations().size());
        Assert.assertEquals((String)"Expected zero annotations.", (long)0L, (long)((TorperfResultImpl)result.get(2)).getAnnotations().size());
    }

    @Test
    public void testAllAnnotatedInput() throws Exception {
        byte[] asciiBytes = "@type torperf 1.0\nBUILDTIMES=0.872834920883,1.09103679657,1.49180984497 CIRC_ID=1228 CONNECT=1441065601.86 DATACOMPLETE=1441065603.39 DATAPERC10=1441065602.98 DATAPERC20=1441065603.03 DATAPERC30=1441065603.09 DATAPERC40=1441065603.12 DATAPERC50=1441065603.23 DATAPERC60=1441065603.25 DATAPERC70=1441065603.31 DATAPERC80=1441065603.37 DATAPERC90=1441065603.37 DATAREQUEST=1441065602.38 DATARESPONSE=1441065602.84 DIDTIMEOUT=0 FILESIZE=51200 LAUNCH=1441065361.30 NEGOTIATE=1441065601.86 PATH=$C4C9C332D25B3546BEF4E1250CF410E97EF996E6,$C43FA6474A9F071E9120DF63ED6EB8FDBA105234,$7C0AA4E3B73E407E9F5FEB1912F8BE26D8AA124D QUANTILE=0.800000 READBYTES=51416 REQUEST=1441065601.86 RESPONSE=1441065602.38 SOCKET=1441065601.86 SOURCE=moria START=1441065601.86 TIMEOUT=1500 USED_AT=1441065603.40 USED_BY=2475 WRITEBYTES=75\n@type torperf 1.0\nBUILDTIMES=0.872834920883,1.09103679657,1.49180984497 CIRC_ID=1228 CONNECT=1441065601.86 DATACOMPLETE=1441065603.39 DATAPERC10=1441065602.98 DATAPERC20=1441065603.03 DATAPERC30=1441065603.09 DATAPERC40=1441065603.12 DATAPERC50=1441065603.23 DATAPERC60=1441065603.25 DATAPERC70=1441065603.31 DATAPERC80=1441065603.37 DATAPERC90=1441065603.37 DATAREQUEST=1441065602.38 DATARESPONSE=1441065602.84 DIDTIMEOUT=0 FILESIZE=51200 LAUNCH=1441065361.30 NEGOTIATE=1441065601.86 PATH=$C4C9C332D25B3546BEF4E1250CF410E97EF996E6,$C43FA6474A9F071E9120DF63ED6EB8FDBA105234,$7C0AA4E3B73E407E9F5FEB1912F8BE26D8AA124D QUANTILE=0.800000 READBYTES=51416 REQUEST=1441065601.86 RESPONSE=1441065602.38 SOCKET=1441065601.86 SOURCE=moria START=1441065601.86 TIMEOUT=1500 USED_AT=1441065603.40 USED_BY=2475 WRITEBYTES=75\n@type torperf 1.0\nBUILDTIMES=0.872834920883,1.09103679657,1.49180984497 CIRC_ID=1228 CONNECT=1441065601.86 DATACOMPLETE=1441065603.39 DATAPERC10=1441065602.98 DATAPERC20=1441065603.03 DATAPERC30=1441065603.09 DATAPERC40=1441065603.12 DATAPERC50=1441065603.23 DATAPERC60=1441065603.25 DATAPERC70=1441065603.31 DATAPERC80=1441065603.37 DATAPERC90=1441065603.37 DATAREQUEST=1441065602.38 DATARESPONSE=1441065602.84 DIDTIMEOUT=0 FILESIZE=51200 LAUNCH=1441065361.30 NEGOTIATE=1441065601.86 PATH=$C4C9C332D25B3546BEF4E1250CF410E97EF996E6,$C43FA6474A9F071E9120DF63ED6EB8FDBA105234,$7C0AA4E3B73E407E9F5FEB1912F8BE26D8AA124D QUANTILE=0.800000 READBYTES=51416 REQUEST=1441065601.86 RESPONSE=1441065602.38 SOCKET=1441065601.86 SOURCE=moria START=1441065601.86 TIMEOUT=1500 USED_AT=1441065603.40 USED_BY=2475 WRITEBYTES=75\n".getBytes("US-ASCII");
        List<Descriptor> result = TorperfResultImpl.parseTorperfResults(asciiBytes, false);
        Assert.assertEquals((String)"Expected one annotation.", (long)1L, (long)((TorperfResultImpl)result.get(0)).getAnnotations().size());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((String)"Expected one annotation.", (long)1L, (long)((TorperfResultImpl)result.get(1)).getAnnotations().size());
        Assert.assertEquals((String)"Expected one annotation.", (long)1L, (long)((TorperfResultImpl)result.get(2)).getAnnotations().size());
    }
}

