/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.index;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNode
implements Comparable<FileNode> {
    private static Logger log = LoggerFactory.getLogger(FileNode.class);
    @Expose
    public final String path;
    @Expose
    public final long size;
    @Expose
    @SerializedName(value="last_modified")
    public final String lastModified;
    private long lastModifiedMillis;

    public FileNode(String path, long size, String lastModified) {
        this.path = path;
        this.size = size;
        this.lastModified = lastModified;
    }

    @Override
    public int compareTo(FileNode other) {
        return this.path.compareTo(other.path);
    }

    public long lastModifiedMillis() {
        if (this.lastModifiedMillis == 0L) {
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.US);
            dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                this.lastModifiedMillis = dateTimeFormat.parse(this.lastModified).getTime();
            }
            catch (ParseException ex) {
                log.warn("Cannot parse date-time. Setting lastModifiedMillis to -1L.", (Throwable)ex);
                this.lastModifiedMillis = -1L;
            }
        }
        return this.lastModifiedMillis;
    }

    public String toString() {
        return "Fn: " + this.path;
    }
}

