/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.torproject.descriptor.DescriptorParseException;
import org.torproject.descriptor.DirectorySignature;
import org.torproject.descriptor.RelayNetworkStatusVote;
import org.torproject.descriptor.impl.Key;
import org.torproject.descriptor.impl.NetworkStatusImpl;
import org.torproject.descriptor.impl.ParseHelper;

public class RelayNetworkStatusVoteImpl
extends NetworkStatusImpl
implements RelayNetworkStatusVote {
    private String nickname;
    private String identity;
    private String hostname;
    private String address;
    private int dirPort;
    private int orPort;
    private String contactLine;
    private boolean sharedRandParticipate = false;
    private List<String> sharedRandCommitLines = null;
    private int sharedRandPreviousNumReveals = -1;
    private String sharedRandPreviousValue = null;
    private int sharedRandCurrentNumReveals = -1;
    private String sharedRandCurrentValue = null;
    private int dirKeyCertificateVersion;
    private String legacyDirKey;
    private long dirKeyPublishedMillis;
    private long dirKeyExpiresMillis;
    private String dirIdentityKey;
    private String dirSigningKey;
    private String dirKeyCrosscert;
    private String dirKeyCertification;
    private int networkStatusVersion;
    private Integer[] consensusMethods;
    private long publishedMillis;
    private long validAfterMillis;
    private long freshUntilMillis;
    private long validUntilMillis;
    private long voteSeconds;
    private long distSeconds;
    private String[] recommendedClientVersions;
    private String[] recommendedServerVersions;
    private SortedMap<String, SortedSet<Long>> recommendedClientProtocols;
    private SortedMap<String, SortedSet<Long>> recommendedRelayProtocols;
    private SortedMap<String, SortedSet<Long>> requiredClientProtocols;
    private SortedMap<String, SortedSet<Long>> requiredRelayProtocols;
    private List<String> packageLines;
    private String[] knownFlags;
    private long stableUptime;
    private long stableMtbf;
    private long fastBandwidth;
    private double guardWfu;
    private long guardTk;
    private long guardBandwidthIncludingExits;
    private long guardBandwidthExcludingExits;
    private int enoughMtbfInfo;
    private int ignoringAdvertisedBws;
    private SortedMap<String, Integer> consensusParams;

    protected RelayNetworkStatusVoteImpl(byte[] voteBytes, int[] offsetAndLength, boolean failUnrecognizedDescriptorLines) throws DescriptorParseException {
        super(voteBytes, offsetAndLength, failUnrecognizedDescriptorLines, false, false);
        EnumSet<Key[]> exactlyOnceKeys = EnumSet.of(Key.VOTE_STATUS, new Key[]{Key.PUBLISHED, Key.VALID_AFTER, Key.FRESH_UNTIL, Key.VALID_UNTIL, Key.VOTING_DELAY, Key.KNOWN_FLAGS, Key.DIR_SOURCE, Key.DIR_KEY_CERTIFICATE_VERSION, Key.FINGERPRINT, Key.DIR_KEY_PUBLISHED, Key.DIR_KEY_EXPIRES, Key.DIR_IDENTITY_KEY, Key.DIR_SIGNING_KEY, Key.DIR_KEY_CERTIFICATION});
        this.checkExactlyOnceKeys(exactlyOnceKeys);
        EnumSet<Key[]> atMostOnceKeys = EnumSet.of(Key.CONSENSUS_METHODS, new Key[]{Key.CLIENT_VERSIONS, Key.SERVER_VERSIONS, Key.RECOMMENDED_CLIENT_PROTOCOLS, Key.RECOMMENDED_RELAY_PROTOCOLS, Key.REQUIRED_CLIENT_PROTOCOLS, Key.REQUIRED_RELAY_PROTOCOLS, Key.FLAG_THRESHOLDS, Key.PARAMS, Key.CONTACT, Key.SHARED_RAND_PARTICIPATE, Key.SHARED_RAND_PREVIOUS_VALUE, Key.SHARED_RAND_CURRENT_VALUE, Key.LEGACY_KEY, Key.DIR_KEY_CROSSCERT, Key.DIR_ADDRESS, Key.DIRECTORY_FOOTER});
        this.checkAtMostOnceKeys(atMostOnceKeys);
        this.checkAtLeastOnceKeys(EnumSet.of(Key.DIRECTORY_SIGNATURE));
        this.checkFirstKey(Key.NETWORK_STATUS_VERSION);
        this.clearParsedKeys();
        this.calculateDigestSha1Hex(Key.NETWORK_STATUS_VERSION.keyword + " ", "\n" + Key.DIRECTORY_SIGNATURE.keyword + " ");
    }

    @Override
    protected void parseHeader(int offset, int length) throws DescriptorParseException {
        this.stableUptime = -1L;
        this.stableMtbf = -1L;
        this.fastBandwidth = -1L;
        this.guardWfu = -1.0;
        this.guardTk = -1L;
        this.guardBandwidthIncludingExits = -1L;
        this.guardBandwidthExcludingExits = -1L;
        this.enoughMtbfInfo = -1;
        this.ignoringAdvertisedBws = -1;
        Scanner scanner = this.newScanner(offset, length).useDelimiter("\n");
        Key nextCrypto = Key.EMPTY;
        StringBuilder crypto = null;
        block44: while (scanner.hasNext()) {
            String line = scanner.next();
            String[] parts = line.split("[ \t]+");
            Key key = Key.get(parts[0]);
            switch (key) {
                case NETWORK_STATUS_VERSION: {
                    this.parseNetworkStatusVersionLine(line, parts);
                    continue block44;
                }
                case VOTE_STATUS: {
                    this.parseVoteStatusLine(line, parts);
                    continue block44;
                }
                case CONSENSUS_METHODS: {
                    this.parseConsensusMethodsLine(line, parts);
                    continue block44;
                }
                case PUBLISHED: {
                    this.parsePublishedLine(line, parts);
                    continue block44;
                }
                case VALID_AFTER: {
                    this.parseValidAfterLine(line, parts);
                    continue block44;
                }
                case FRESH_UNTIL: {
                    this.parseFreshUntilLine(line, parts);
                    continue block44;
                }
                case VALID_UNTIL: {
                    this.parseValidUntilLine(line, parts);
                    continue block44;
                }
                case VOTING_DELAY: {
                    this.parseVotingDelayLine(line, parts);
                    continue block44;
                }
                case CLIENT_VERSIONS: {
                    this.parseClientVersionsLine(line, parts);
                    continue block44;
                }
                case SERVER_VERSIONS: {
                    this.parseServerVersionsLine(line, parts);
                    continue block44;
                }
                case RECOMMENDED_CLIENT_PROTOCOLS: {
                    this.parseRecommendedClientProtocolsLine(line, parts);
                    continue block44;
                }
                case RECOMMENDED_RELAY_PROTOCOLS: {
                    this.parseRecommendedRelayProtocolsLine(line, parts);
                    continue block44;
                }
                case REQUIRED_CLIENT_PROTOCOLS: {
                    this.parseRequiredClientProtocolsLine(line, parts);
                    continue block44;
                }
                case REQUIRED_RELAY_PROTOCOLS: {
                    this.parseRequiredRelayProtocolsLine(line, parts);
                    continue block44;
                }
                case PACKAGE: {
                    this.parsePackageLine(line, parts);
                    continue block44;
                }
                case KNOWN_FLAGS: {
                    this.parseKnownFlagsLine(line, parts);
                    continue block44;
                }
                case FLAG_THRESHOLDS: {
                    this.parseFlagThresholdsLine(line, parts);
                    continue block44;
                }
                case PARAMS: {
                    this.parseParamsLine(line, parts);
                    continue block44;
                }
                case DIR_SOURCE: {
                    this.parseDirSourceLine(line, parts);
                    continue block44;
                }
                case CONTACT: {
                    this.parseContactLine(line, parts);
                    continue block44;
                }
                case SHARED_RAND_PARTICIPATE: {
                    this.parseSharedRandParticipateLine(line, parts);
                    continue block44;
                }
                case SHARED_RAND_COMMIT: {
                    this.parseSharedRandCommitLine(line, parts);
                    continue block44;
                }
                case SHARED_RAND_PREVIOUS_VALUE: {
                    this.parseSharedRandPreviousValueLine(line, parts);
                    continue block44;
                }
                case SHARED_RAND_CURRENT_VALUE: {
                    this.parseSharedRandCurrentValueLine(line, parts);
                    continue block44;
                }
                case DIR_KEY_CERTIFICATE_VERSION: {
                    this.parseDirKeyCertificateVersionLine(line, parts);
                    continue block44;
                }
                case DIR_ADDRESS: {
                    this.parseDirAddressLine(line, parts);
                    continue block44;
                }
                case FINGERPRINT: {
                    this.parseFingerprintLine(line, parts);
                    continue block44;
                }
                case LEGACY_DIR_KEY: {
                    this.parseLegacyDirKeyLine(line, parts);
                    continue block44;
                }
                case DIR_KEY_PUBLISHED: {
                    this.parseDirKeyPublished(line, parts);
                    continue block44;
                }
                case DIR_KEY_EXPIRES: {
                    this.parseDirKeyExpiresLine(line, parts);
                    continue block44;
                }
                case DIR_IDENTITY_KEY: {
                    this.parseDirIdentityKeyLine(line, parts);
                    nextCrypto = key;
                    continue block44;
                }
                case DIR_SIGNING_KEY: {
                    this.parseDirSigningKeyLine(line, parts);
                    nextCrypto = key;
                    continue block44;
                }
                case DIR_KEY_CROSSCERT: {
                    this.parseDirKeyCrosscertLine(line, parts);
                    nextCrypto = key;
                    continue block44;
                }
                case DIR_KEY_CERTIFICATION: {
                    this.parseDirKeyCertificationLine(line, parts);
                    nextCrypto = key;
                    continue block44;
                }
                case CRYPTO_BEGIN: {
                    crypto = new StringBuilder();
                    crypto.append(line).append("\n");
                    continue block44;
                }
                case CRYPTO_END: {
                    crypto.append(line).append("\n");
                    String cryptoString = crypto.toString();
                    crypto = null;
                    switch (nextCrypto) {
                        case DIR_IDENTITY_KEY: {
                            this.dirIdentityKey = cryptoString;
                            break;
                        }
                        case DIR_SIGNING_KEY: {
                            this.dirSigningKey = cryptoString;
                            break;
                        }
                        case DIR_KEY_CROSSCERT: {
                            this.dirKeyCrosscert = cryptoString;
                            break;
                        }
                        case DIR_KEY_CERTIFICATION: {
                            this.dirKeyCertification = cryptoString;
                            break;
                        }
                        default: {
                            throw new DescriptorParseException("Unrecognized crypto block in vote.");
                        }
                    }
                    nextCrypto = Key.EMPTY;
                    continue block44;
                }
            }
            if (crypto != null) {
                crypto.append(line).append("\n");
                continue;
            }
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in vote.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    private void parseNetworkStatusVersionLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals(Key.NETWORK_STATUS_VERSION.keyword + " " + "3")) {
            throw new DescriptorParseException("Illegal network status version number in line '" + line + "'.");
        }
        this.networkStatusVersion = 3;
    }

    private void parseVoteStatusLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2 || !parts[1].equals("vote")) {
            throw new DescriptorParseException("Line '" + line + "' indicates that this is not a vote.");
        }
    }

    private void parseConsensusMethodsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        Integer[] consensusMethods = new Integer[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            int consensusMethod = -1;
            try {
                consensusMethod = Integer.parseInt(parts[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (consensusMethod < 1) {
                throw new DescriptorParseException("Illegal consensus method number in line '" + line + "'.");
            }
            consensusMethods[i - 1] = consensusMethod;
        }
        this.consensusMethods = consensusMethods;
    }

    private void parsePublishedLine(String line, String[] parts) throws DescriptorParseException {
        this.publishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseValidAfterLine(String line, String[] parts) throws DescriptorParseException {
        this.validAfterMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseFreshUntilLine(String line, String[] parts) throws DescriptorParseException {
        this.freshUntilMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseValidUntilLine(String line, String[] parts) throws DescriptorParseException {
        this.validUntilMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseVotingDelayLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        try {
            this.voteSeconds = Long.parseLong(parts[1]);
            this.distSeconds = Long.parseLong(parts[2]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal values in line '" + line + "'.");
        }
    }

    private void parseClientVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedClientVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseServerVersionsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedServerVersions = this.parseClientOrServerVersions(line, parts);
    }

    private void parseRecommendedClientProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedClientProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parseRecommendedRelayProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.recommendedRelayProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parseRequiredClientProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.requiredClientProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parseRequiredRelayProtocolsLine(String line, String[] parts) throws DescriptorParseException {
        this.requiredRelayProtocols = ParseHelper.parseProtocolVersions(line, line, parts);
    }

    private void parsePackageLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 5) {
            throw new DescriptorParseException("Wrong number of values in line '" + line + "'.");
        }
        if (this.packageLines == null) {
            this.packageLines = new ArrayList<String>();
        }
        this.packageLines.add(line.substring(Key.PACKAGE.keyword.length() + 1));
    }

    private void parseKnownFlagsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("No known flags in line '" + line + "'.");
        }
        String[] knownFlags = new String[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            knownFlags[i - 1] = parts[i];
        }
        this.knownFlags = knownFlags;
    }

    private void parseFlagThresholdsLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length < 2) {
            throw new DescriptorParseException("No flag thresholds in line '" + line + "'.");
        }
        SortedMap<String, String> flagThresholds = ParseHelper.parseKeyValueStringPairs(line, parts, 1);
        try {
            for (Map.Entry<String, String> e : flagThresholds.entrySet()) {
                switch (e.getKey()) {
                    case "stable-uptime": {
                        this.stableUptime = Long.parseLong(e.getValue());
                        break;
                    }
                    case "stable-mtbf": {
                        this.stableMtbf = Long.parseLong(e.getValue());
                        break;
                    }
                    case "fast-speed": {
                        this.fastBandwidth = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-wfu": {
                        this.guardWfu = Double.parseDouble(e.getValue().replaceAll("%", ""));
                        break;
                    }
                    case "guard-tk": {
                        this.guardTk = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-bw-inc-exits": {
                        this.guardBandwidthIncludingExits = Long.parseLong(e.getValue());
                        break;
                    }
                    case "guard-bw-exc-exits": {
                        this.guardBandwidthExcludingExits = Long.parseLong(e.getValue());
                        break;
                    }
                    case "enough-mtbf": {
                        this.enoughMtbfInfo = Integer.parseInt(e.getValue());
                        break;
                    }
                    case "ignoring-advertised-bws": {
                        this.ignoringAdvertisedBws = Integer.parseInt(e.getValue());
                        break;
                    }
                }
            }
        }
        catch (NumberFormatException ex) {
            throw new DescriptorParseException("Illegal value in line '" + line + "'.");
        }
    }

    private void parseParamsLine(String line, String[] parts) throws DescriptorParseException {
        this.consensusParams = ParseHelper.parseKeyValueIntegerPairs(line, parts, 1);
    }

    private void parseDirSourceLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 7) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.nickname = ParseHelper.parseNickname(line, parts[1]);
        this.identity = ParseHelper.parseTwentyByteHexString(line, parts[2]);
        if (parts[3].length() < 1) {
            throw new DescriptorParseException("Illegal hostname in '" + line + "'.");
        }
        this.hostname = parts[3];
        this.address = ParseHelper.parseIpv4Address(line, parts[4]);
        this.dirPort = ParseHelper.parsePort(line, parts[5]);
        this.orPort = ParseHelper.parsePort(line, parts[6]);
    }

    private void parseContactLine(String line, String[] parts) throws DescriptorParseException {
        this.contactLine = line.length() > Key.CONTACT.keyword.length() + 1 ? line.substring(Key.CONTACT.keyword.length() + 1) : "";
    }

    private void parseSharedRandParticipateLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 1) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.sharedRandParticipate = true;
    }

    private void parseSharedRandCommitLine(String line, String[] parts) throws DescriptorParseException {
        if (this.sharedRandCommitLines == null) {
            this.sharedRandCommitLines = new ArrayList<String>();
        }
        this.sharedRandCommitLines.add(line);
    }

    private void parseSharedRandPreviousValueLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        try {
            this.sharedRandPreviousNumReveals = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.sharedRandPreviousValue = parts[2];
    }

    private void parseSharedRandCurrentValueLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 3) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        try {
            this.sharedRandCurrentNumReveals = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        this.sharedRandCurrentValue = parts[2];
    }

    private void parseDirKeyCertificateVersionLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        try {
            this.dirKeyCertificateVersion = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new DescriptorParseException("Illegal dir key certificate version in line '" + line + "'.");
        }
        if (this.dirKeyCertificateVersion < 1) {
            throw new DescriptorParseException("Illegal dir key certificate version in line '" + line + "'.");
        }
    }

    private void parseDirAddressLine(String line, String[] parts) {
    }

    private void parseFingerprintLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "' in vote.");
        }
        ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parseLegacyDirKeyLine(String line, String[] parts) throws DescriptorParseException {
        if (parts.length != 2) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
        this.legacyDirKey = ParseHelper.parseTwentyByteHexString(line, parts[1]);
    }

    private void parseDirKeyPublished(String line, String[] parts) throws DescriptorParseException {
        this.dirKeyPublishedMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseDirKeyExpiresLine(String line, String[] parts) throws DescriptorParseException {
        this.dirKeyExpiresMillis = ParseHelper.parseTimestampAtIndex(line, parts, 1, 2);
    }

    private void parseDirIdentityKeyLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals(Key.DIR_IDENTITY_KEY.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseDirSigningKeyLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals(Key.DIR_SIGNING_KEY.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseDirKeyCrosscertLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals(Key.DIR_KEY_CROSSCERT.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    private void parseDirKeyCertificationLine(String line, String[] parts) throws DescriptorParseException {
        if (!line.equals(Key.DIR_KEY_CERTIFICATION.keyword)) {
            throw new DescriptorParseException("Illegal line '" + line + "'.");
        }
    }

    @Override
    protected void parseFooter(int offset, int length) throws DescriptorParseException {
        Scanner scanner = this.newScanner(offset, length).useDelimiter("\n");
        while (scanner.hasNext()) {
            String line = scanner.next();
            if (line.equals(Key.DIRECTORY_FOOTER.keyword)) continue;
            if (this.failUnrecognizedDescriptorLines) {
                throw new DescriptorParseException("Unrecognized line '" + line + "' in vote.");
            }
            if (this.unrecognizedLines == null) {
                this.unrecognizedLines = new ArrayList();
            }
            this.unrecognizedLines.add(line);
        }
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getDirport() {
        return this.dirPort;
    }

    @Override
    public int getOrport() {
        return this.orPort;
    }

    @Override
    public String getContactLine() {
        return this.contactLine;
    }

    @Override
    public boolean isSharedRandParticipate() {
        return this.sharedRandParticipate;
    }

    @Override
    public List<String> getSharedRandCommitLines() {
        return this.sharedRandCommitLines;
    }

    @Override
    public int getSharedRandPreviousNumReveals() {
        return this.sharedRandPreviousNumReveals;
    }

    @Override
    public String getSharedRandPreviousValue() {
        return this.sharedRandPreviousValue;
    }

    @Override
    public int getSharedRandCurrentNumReveals() {
        return this.sharedRandCurrentNumReveals;
    }

    @Override
    public String getSharedRandCurrentValue() {
        return this.sharedRandCurrentValue;
    }

    @Override
    public int getDirKeyCertificateVersion() {
        return this.dirKeyCertificateVersion;
    }

    @Override
    public String getLegacyDirKey() {
        return this.legacyDirKey;
    }

    @Override
    public long getDirKeyPublishedMillis() {
        return this.dirKeyPublishedMillis;
    }

    @Override
    public long getDirKeyExpiresMillis() {
        return this.dirKeyExpiresMillis;
    }

    @Override
    public String getDirIdentityKey() {
        return this.dirIdentityKey;
    }

    @Override
    public String getDirSigningKey() {
        return this.dirSigningKey;
    }

    @Override
    public String getDirKeyCrosscert() {
        return this.dirKeyCrosscert;
    }

    @Override
    public String getDirKeyCertification() {
        return this.dirKeyCertification;
    }

    @Override
    public String getSigningKeyDigest() {
        String signingKeyDigest = null;
        if (this.signatures != null && !this.signatures.isEmpty()) {
            for (DirectorySignature signature : this.signatures) {
                if (!"sha1".equals(signature.getAlgorithm())) continue;
                signingKeyDigest = signature.getSigningKeyDigestSha1Hex();
                break;
            }
        }
        return signingKeyDigest;
    }

    @Override
    public int getNetworkStatusVersion() {
        return this.networkStatusVersion;
    }

    @Override
    public List<Integer> getConsensusMethods() {
        return this.consensusMethods == null ? null : Arrays.asList(this.consensusMethods);
    }

    @Override
    public long getPublishedMillis() {
        return this.publishedMillis;
    }

    @Override
    public long getValidAfterMillis() {
        return this.validAfterMillis;
    }

    @Override
    public long getFreshUntilMillis() {
        return this.freshUntilMillis;
    }

    @Override
    public long getValidUntilMillis() {
        return this.validUntilMillis;
    }

    @Override
    public long getVoteSeconds() {
        return this.voteSeconds;
    }

    @Override
    public long getDistSeconds() {
        return this.distSeconds;
    }

    @Override
    public List<String> getRecommendedClientVersions() {
        return this.recommendedClientVersions == null ? null : Arrays.asList(this.recommendedClientVersions);
    }

    @Override
    public List<String> getRecommendedServerVersions() {
        return this.recommendedServerVersions == null ? null : Arrays.asList(this.recommendedServerVersions);
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRecommendedClientProtocols() {
        return this.recommendedClientProtocols;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRecommendedRelayProtocols() {
        return this.recommendedRelayProtocols;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRequiredClientProtocols() {
        return this.requiredClientProtocols;
    }

    @Override
    public SortedMap<String, SortedSet<Long>> getRequiredRelayProtocols() {
        return this.requiredRelayProtocols;
    }

    @Override
    public List<String> getPackageLines() {
        return this.packageLines == null ? null : new ArrayList<String>(this.packageLines);
    }

    @Override
    public SortedSet<String> getKnownFlags() {
        return new TreeSet<String>(Arrays.asList(this.knownFlags));
    }

    @Override
    public long getStableUptime() {
        return this.stableUptime;
    }

    @Override
    public long getStableMtbf() {
        return this.stableMtbf;
    }

    @Override
    public long getFastBandwidth() {
        return this.fastBandwidth;
    }

    @Override
    public double getGuardWfu() {
        return this.guardWfu;
    }

    @Override
    public long getGuardTk() {
        return this.guardTk;
    }

    @Override
    public long getGuardBandwidthIncludingExits() {
        return this.guardBandwidthIncludingExits;
    }

    @Override
    public long getGuardBandwidthExcludingExits() {
        return this.guardBandwidthExcludingExits;
    }

    @Override
    public int getEnoughMtbfInfo() {
        return this.enoughMtbfInfo;
    }

    @Override
    public int getIgnoringAdvertisedBws() {
        return this.ignoringAdvertisedBws;
    }

    @Override
    public SortedMap<String, Integer> getConsensusParams() {
        return this.consensusParams == null ? null : new TreeMap<String, Integer>(this.consensusParams);
    }
}

